/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.search;

import com.ericsson.ere.gui.simulator.input.db.DatabaseSimulationSource;
import com.ericsson.ere.gui.simulator.search.QueryBuilder;
import ericsson.ere.gui.GuiServiceCenter;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class QueryWriter
extends JPanel
implements KeyListener {
    private CustomTextArea mySqlEditor = null;
    private JButton myGetQueryButton = null;
    private QueryBuilder myQueryBuilderPanel;

    public QueryWriter(QueryBuilder queryBuilderPanel, DatabaseSimulationSource aSource) {
        this.myQueryBuilderPanel = queryBuilderPanel;
        this.initialize();
        GuiServiceCenter.getInstance().enableHelpKey(this, this.getClass().toString(), null);
    }

    public String getQuery() {
        return this.mySqlEditor.getText();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.mySqlEditor = new CustomTextArea();
        this.mySqlEditor.setRows(3);
        this.mySqlEditor.addKeyListener(this);
        this.myGetQueryButton = new JButton("Get query from query builder");
        this.myGetQueryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryWriter.this.mySqlEditor.setText(QueryWriter.this.myQueryBuilderPanel.buildAndReturnSQLQuery());
            }
        });
        this.add((Component)new JScrollPane(this.mySqlEditor), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.myGetQueryButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 0, 0));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && e.isControlDown()) {
            this.mySqlEditor.removeKeyListener(this);
            this.mySqlEditor.fakeEnter();
            this.mySqlEditor.addKeyListener(this);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private class CustomTextArea
    extends JTextArea {
        private CustomTextArea() {
        }

        public void fakeEnter() {
            this.processKeyEvent(new KeyEvent(this, 401, EventQueue.getMostRecentEventTime(), 0, 10, '\uffff'));
        }
    }
}

