/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.testgenerator;

import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationWizardOptions;
import com.ericsson.ere.gui.wizard.panels.DefaultWizardPanel;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.ratingrules.nodes.TSCondition;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TSModifier;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;

public class TestCaseGenerationNamingPanel
extends DefaultWizardPanel
implements ActionListener,
KeyListener {
    private TestCaseGenerationWizardOptions myWizardOptions;
    private JCheckBox myAutoGenerateName;
    private JCheckBox myUserDefinedName;
    private JCheckBox myNodeNamesBox;
    private JCheckBox myModifierNameBox;
    private JTextField myUserDefinedNameField;
    private JTextField mySetNameField;
    private JLabel myExampleLabel;

    public TestCaseGenerationNamingPanel(TestCaseGenerationWizardOptions wizardOptions) {
        this.myWizardOptions = wizardOptions;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.myAutoGenerateName = new JCheckBox("Include the following in test case names");
        this.myNodeNamesBox = new JCheckBox("Node names");
        this.myModifierNameBox = new JCheckBox("Modifier name");
        this.myUserDefinedName = new JCheckBox("Use the following prefix for all test cases");
        this.myUserDefinedNameField = new JTextField();
        this.myExampleLabel = new JLabel();
        JLabel mySetNameLabel = new JLabel("Simulation set name");
        this.mySetNameField = new JTextField(((TSTariffStructure)this.myWizardOptions.myModifierPath[0].getPath()[0]).getNodeName());
        this.add((Component)mySetNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 8, 8, 8), 0, 0));
        this.add((Component)this.mySetNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 8, 8, 20), 0, 0));
        this.add((Component)this.myAutoGenerateName, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 8, 8, 8), 0, 0));
        this.add((Component)this.myNodeNamesBox, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 8, 8), 0, 0));
        this.add((Component)this.myModifierNameBox, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 8, 8), 0, 0));
        this.add((Component)this.myUserDefinedName, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(15, 8, 8, 8), 0, 0));
        this.add((Component)this.myUserDefinedNameField, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 20, 8, 20), 0, 0));
        this.add((Component)this.myExampleLabel, new GridBagConstraints(0, 7, 2, 1, 0.0, 1.0, 18, 2, new Insets(15, 8, 8, 8), 0, 0));
        this.myWizardOptions.myNamingSettings = new NamingSettings(true, false, true);
        this.myWizardOptions.myNamingSettings.simulationSetName = this.mySetNameField.getText();
        this.myAutoGenerateName.setSelected(true);
        this.myNodeNamesBox.setSelected(true);
        this.myModifierNameBox.setSelected(true);
        this.myUserDefinedNameField.setEnabled(false);
        this.myAutoGenerateName.addActionListener(this);
        this.myNodeNamesBox.addActionListener(this);
        this.myModifierNameBox.addActionListener(this);
        this.myUserDefinedName.addActionListener(this);
        this.myUserDefinedNameField.addKeyListener(this);
        this.mySetNameField.addKeyListener(this);
        this.updateComponents();
        GuiServiceCenter.getInstance().enableHelpKey(this, this.getClass().toString(), null);
    }

    private void updateComponents() {
        if (this.myWizardOptions.myModifierPath.length > 0) {
            this.myExampleLabel.setText("Example: " + TestCaseGenerationNamingPanel.getTestCaseName(this.myWizardOptions.myModifierPath[0], this.myWizardOptions.myNamingSettings));
        }
        this.triggerObservers();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myAutoGenerateName) {
            this.myNodeNamesBox.setEnabled(this.myAutoGenerateName.isSelected());
            this.myModifierNameBox.setEnabled(this.myAutoGenerateName.isSelected());
            this.myWizardOptions.myNamingSettings.autoGenerateName = this.myAutoGenerateName.isSelected();
        } else if (e.getSource() == this.myUserDefinedName) {
            this.myUserDefinedNameField.setEnabled(this.myUserDefinedName.isSelected());
            this.myWizardOptions.myNamingSettings.userDefinedName = this.myUserDefinedName.isSelected() ? this.myUserDefinedNameField.getText() : "";
        } else if (e.getSource() == this.myNodeNamesBox) {
            this.myWizardOptions.myNamingSettings.includeNodeNames = this.myNodeNamesBox.isSelected();
        } else if (e.getSource() == this.myModifierNameBox) {
            this.myWizardOptions.myNamingSettings.includeModifierName = this.myModifierNameBox.isSelected();
        }
        this.updateComponents();
    }

    @Override
    public String getPanelDescription() {
        return "Decide how the generated test cases should be named.";
    }

    @Override
    public String getPanelIdentifier() {
        return "Naming";
    }

    @Override
    public boolean hasNeededData() {
        return true;
    }

    @Override
    public void panelIsVisible() {
    }

    @Override
    public void wizardCanceled() {
    }

    static String getTestCaseName(TreePath path, NamingSettings namingSettings) {
        String pathName = "";
        if (!namingSettings.userDefinedName.equals("")) {
            pathName = namingSettings.userDefinedName + " ";
        }
        if (namingSettings.autoGenerateName) {
            Object[] pathArray = path.getPath();
            for (int i = 0; i < pathArray.length; ++i) {
                TariffDAGNode node = (TariffDAGNode)pathArray[i];
                if ((node instanceof TSNode || node instanceof TSLink) && namingSettings.includeNodeNames) {
                    pathName = pathName + node.getNodeName();
                    if (i < pathArray.length - 1) {
                        pathName = pathName + namingSettings.nodeDelimiter;
                    }
                }
                if ((node instanceof TSNode || node instanceof TSCondition) && namingSettings.includeConditionNames) {
                    int count = 0;
                    for (int j = 0; j < node.getChildCount(); ++j) {
                        if (!(node.getChildAt(j) instanceof TSCondition)) continue;
                        pathName = count == 0 ? pathName + namingSettings.conditionDelimiter : pathName + " OR ";
                        List<Variable> vars = ((TSCondition)node.getChildAt(j)).getVariablesForEditing(null);
                        String additionalInfo = ((TSCondition)node.getChildAt(j)).getConditionProfile().getAdditionalInfo(vars);
                        additionalInfo = additionalInfo.replaceAll("<[^<]*>", "");
                        pathName = pathName + additionalInfo;
                        ++count;
                    }
                }
                if (!(node instanceof TSModifier) || !namingSettings.includeModifierName) continue;
                pathName = pathName + node.getNodeName();
            }
        }
        return pathName;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.myUserDefinedNameField) {
            this.myWizardOptions.myNamingSettings.userDefinedName = this.myUserDefinedNameField.getText();
            this.updateComponents();
        } else if (e.getSource() == this.mySetNameField) {
            this.myWizardOptions.myNamingSettings.simulationSetName = this.mySetNameField.getText();
            this.updateComponents();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    static class NamingSettings {
        String conditionDelimiter = " : ";
        String nodeDelimiter = "\\";
        boolean includeNodeNames;
        boolean includeConditionNames;
        boolean includeModifierName;
        String userDefinedName = "";
        boolean autoGenerateName = true;
        String simulationSetName = "Generated";

        NamingSettings(boolean nodeNames, boolean conditionNames, boolean modifierNames) {
            this.includeConditionNames = conditionNames;
            this.includeModifierName = modifierNames;
            this.includeNodeNames = nodeNames;
        }

        void setAutoGenerateName(boolean active) {
            this.autoGenerateName = active;
        }
    }
}

