/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.testgenerator;

import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationWizardOptions;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerator;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.wizard.panels.DefaultWizardPanel;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class TestCaseGenerationProgressPanel
extends DefaultWizardPanel {
    TestCaseGenerationWizardOptions myWizardOptions;
    JLabel myCounterLabel;
    JProgressBar myProgressBar;
    JButton myStartButton;
    private int PROGRESS_BAR_MAX = 100;
    private long myMaxValue;
    private boolean isFinished = false;
    private TestCaseGenerator myTestCaseGenerator;

    public TestCaseGenerationProgressPanel(TestCaseGenerationWizardOptions wizardOptions) {
        this.myWizardOptions = wizardOptions;
        this.myWizardOptions.myProgressPanel = this;
        this.myTestCaseGenerator = new TestCaseGenerator(this, this.myWizardOptions);
        this.myCounterLabel = new JLabel();
        this.myProgressBar = new JProgressBar(0, this.PROGRESS_BAR_MAX);
        this.myStartButton = new JButton("Start generation");
        this.myStartButton.setIcon(RmaDefs.getImageIcon("gear_run16.png"));
        this.myStartButton.setName("TestCaseGenerationProgressPanel.JButton.myStartButton");
        this.myStartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TestCaseGenerationProgressPanel.this.isFinished || TestCaseGenerationProgressPanel.this.myWizardOptions.isStopped) {
                    if (TestCaseGenerationProgressPanel.this.myWizardOptions.isManualValidationPossible) {
                        boolean isValidationVariableSelected = false;
                        for (String variable : TestCaseGenerationProgressPanel.this.myWizardOptions.mySelectedValidationFields.keySet()) {
                            boolean selected = TestCaseGenerationProgressPanel.this.myWizardOptions.mySelectedValidationFields.get(variable);
                            if (!selected) continue;
                            isValidationVariableSelected = true;
                        }
                        if (!isValidationVariableSelected && !DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "RMA", "No validation fields have been set for this generation. Do you want to contine?")) {
                            return;
                        }
                    }
                    new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            try {
                                TestCaseGenerationProgressPanel.this.isFinished = false;
                                TestCaseGenerationProgressPanel.this.myMaxValue = TestCaseGenerationProgressPanel.this.myWizardOptions.myNumberOfTestCases;
                                TestCaseGenerationProgressPanel.this.myWizardOptions.myActualNumberOfTestCases = 0;
                                TestCaseGenerationProgressPanel.this.myProgressBar.setValue(0);
                                TestCaseGenerationProgressPanel.this.myCounterLabel.setText("Simulation cases generated: 0 of " + TestCaseGenerationProgressPanel.this.myMaxValue);
                                TestCaseGenerationProgressPanel.this.myWizardOptions.isStopped = false;
                                TestCaseGenerationProgressPanel.this.myStartButton.setText("Stop generation");
                                TestCaseGenerationProgressPanel.this.myStartButton.setIcon(RmaDefs.getImageIcon("gear_stop16.png"));
                                TestCaseGenerationProgressPanel.this.myWizardOptions.wizardState.setStandardMode();
                                TestCaseGenerationProgressPanel.this.myTestCaseGenerator.generate();
                            }
                            catch (Exception e) {
                                ExceptionUtil.handleException(e, "generation", 1, "Generation failed", true);
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            TestCaseGenerationProgressPanel.this.triggerObservers();
                            super.done();
                        }
                    }.execute();
                } else {
                    TestCaseGenerationProgressPanel.this.myWizardOptions.isStopped = true;
                    TestCaseGenerationProgressPanel.this.myStartButton.setText("Restart generation");
                    TestCaseGenerationProgressPanel.this.myStartButton.setIcon(RmaDefs.getImageIcon("gear_run16.png"));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.myCounterLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 16, 0, new Insets(50, 40, 8, 40), 0, 0));
        this.add((Component)this.myProgressBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(8, 40, 8, 40), 0, 0));
        this.add((Component)this.myStartButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 0, new Insets(20, 40, 8, 40), 0, 0));
        GuiServiceCenter.getInstance().enableHelpKey(this, this.getClass().toString(), null);
    }

    void setProgress(int value) {
        this.myWizardOptions.myActualNumberOfTestCases = value;
        this.myProgressBar.setValue(this.calculateProgressValue());
        this.myCounterLabel.setText("Simulation cases generated: " + this.myWizardOptions.myActualNumberOfTestCases + " of " + this.myMaxValue);
    }

    void increaseProgress() {
        ++this.myWizardOptions.myActualNumberOfTestCases;
        this.myProgressBar.setValue(this.calculateProgressValue());
        this.myCounterLabel.setText("Simulation cases generated: " + this.myWizardOptions.myActualNumberOfTestCases + " of " + this.myMaxValue);
    }

    private int calculateProgressValue() {
        int retVal = (int)((double)this.myWizardOptions.myActualNumberOfTestCases / (double)this.myMaxValue * (double)this.PROGRESS_BAR_MAX);
        return retVal > this.PROGRESS_BAR_MAX ? this.PROGRESS_BAR_MAX : retVal;
    }

    int getProgress() {
        return this.myWizardOptions.myActualNumberOfTestCases;
    }

    void setGenerationFinished() {
        this.isFinished = true;
        this.myStartButton.setText("Restart generation");
        this.myStartButton.setIcon(RmaDefs.getImageIcon("gear_run16.png"));
        if ((long)this.myWizardOptions.myActualNumberOfTestCases != this.myMaxValue) {
            this.myCounterLabel.setText("Simulation cases generated: " + this.myWizardOptions.myActualNumberOfTestCases + " of " + this.myMaxValue + " (Maximum value is only an approximation)");
            this.myProgressBar.setValue(this.PROGRESS_BAR_MAX);
        }
    }

    @Override
    public String getPanelDescription() {
        return "Wait while the generator is working...";
    }

    @Override
    public String getPanelIdentifier() {
        return "Progress";
    }

    @Override
    public boolean hasNeededData() {
        return this.isFinished && !this.myWizardOptions.isStopped;
    }

    @Override
    public void panelIsVisible() {
        int currentValue = this.getProgress();
        if (currentValue == 0) {
            this.myMaxValue = this.myWizardOptions.myNumberOfTestCases;
            this.myCounterLabel.setText("Simulation cases generated: " + currentValue + " of " + this.myMaxValue);
        }
    }

    @Override
    public void wizardCanceled() {
    }
}

