/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.testgenerator;

import com.ericsson.charging.common.dataitem.DataItem;
import com.ericsson.ere.gui.simulator.testgenerator.GenerationPathGotoModifier;
import com.ericsson.ere.gui.simulator.testgenerator.GenerationPathRenderer;
import com.ericsson.ere.gui.simulator.testgenerator.GenerationPathTree;
import com.ericsson.ere.gui.simulator.testgenerator.NodeConfigurationPanel;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionExtendedInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationDefs;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationModifierInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationWizardOptions;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerator;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.wizard.panels.DefaultWizardPanel;
import com.ericsson.ere.selectiontree.conditions.logic.CompoundBooleanConditionProfile;
import com.ericsson.ere.selectiontree.modifiers.jump.GoToModifierProfile;
import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.ratingrules.RatingJTreeErrorHandler;
import ericsson.ere.gui.ratingrules.RatingJTreeNodeFactory;
import ericsson.ere.gui.ratingrules.RatingRuleNodeTransferable;
import ericsson.ere.gui.ratingrules.nodes.TSCondition;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TSModifier;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.interfaces.ConditionProfile;
import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.ratingrules.RatingRuleBuilder;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestCaseGenerationSetupPanel
extends DefaultWizardPanel
implements DataItem,
TreeSelectionListener,
ChangeListener,
DropTargetListener {
    private TestCaseGenerationWizardOptions myWizardOptions;
    private GenerationPathTree myTree;
    private GenerationPathRenderer myTreeRenderer;
    private TSTariffStructure myRoot;
    private JLabel myCurrentNumLabel = new JLabel("Values generated for this condition: ");
    private JLabel myNumOfValuesForCurrentLabel = new JLabel("0");
    private JLabel myTotalLabel = new JLabel("Total number of tests: ");
    private JLabel myTotNumOfTestsLabel = new JLabel("0");
    private JCheckBox myOneTestCheckbox = new JCheckBox("Only generate one single test case.");
    private NodeConfigurationPanel myConfigurationPanel;
    private String myServiceName;
    private ClassRepository myRepository;
    JPanel myConfigurationPanelHolder;
    private boolean booleansExistInPath = false;

    public TestCaseGenerationSetupPanel(TestCaseGenerationWizardOptions wizardOptions, String serviceName, ClassRepository repository) {
        try {
            this.myWizardOptions = wizardOptions;
            this.myServiceName = serviceName;
            this.myRepository = repository;
            this.myWizardOptions.myModifierPath[0] = this.extractTreeCopy((TSTariffStructure)this.myWizardOptions.myRatingRuleTree.getModel().getRoot(), this.myWizardOptions.myModifierPath[0]);
            this.myRoot = (TSTariffStructure)this.myWizardOptions.myModifierPath[0].getPath()[0];
            this.myWizardOptions.mySingleTestCase = false;
            this.initComponents();
            this.initTreeNodes();
            this.updateTestCount();
            this.myTree.setSelectionPath(this.myWizardOptions.myModifierPath[0]);
            this.stateChanged(null);
            GuiServiceCenter.getInstance().enableHelpKey(this, this.getClass().toString(), null);
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "simulation", 1, "Test Generation Wizard failed to instantiate!", true);
        }
    }

    private void initTreeNodes() throws Exception {
        HashMap<String, ArrayList<String>> affectedFields = new HashMap<String, ArrayList<String>>();
        ArrayList<String> unsupportedConditionElements = new ArrayList<String>();
        ArrayList<String> unsupportedModifierElements = new ArrayList<String>();
        this.myWizardOptions.myElementConfigXML = new HashMap();
        this.myWizardOptions.myElementTestXML = new HashMap();
        this.myWizardOptions.myConditionTestCaseFieldInformation = new HashMap();
        this.myWizardOptions.myConditionSingleTestCaseFieldInformation = new HashMap();
        this.myWizardOptions.myModifierTestCaseFieldInformation = new HashMap();
        this.myWizardOptions.myFaultyTestCaseFieldInformation = new HashMap();
        Stack<TariffDAGNode> pathNodes = new Stack<TariffDAGNode>();
        TreePath generationPath = this.myWizardOptions.myModifierPath[0];
        Object[] pathArray = generationPath.getPath();
        pathNodes.push((TariffDAGNode)pathArray[0]);
        while (!pathNodes.isEmpty()) {
            TariffDAGNode node = (TariffDAGNode)pathNodes.pop();
            if (node instanceof TSTariffStructure || node instanceof TSLink) {
                pathNodes.push((TariffDAGNode)node.getChildAt(0));
            } else if (node instanceof TSNode || TestCaseGenerator.isCompoundBooleanCondition(node) || node instanceof GenerationPathGotoModifier) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    pathNodes.push((TariffDAGNode)node.getChildAt(i));
                }
            }
            if (node instanceof TSCondition) {
                TSCondition condition = (TSCondition)node;
                condition.getDescription();
                if (TestCaseGenerator.isInversed(condition)) {
                    this.myTreeRenderer.addSpecialNodes(condition);
                }
                if (TestCaseGenerator.isCompoundBooleanCondition(condition)) {
                    this.booleansExistInPath = true;
                    continue;
                }
                if (!TestCaseGenerator.supportsTestCaseGeneration(condition)) {
                    if (unsupportedConditionElements.contains(condition.getNodeName())) continue;
                    unsupportedConditionElements.add(condition.getNodeName());
                    continue;
                }
                AbstractConditionProfile conditionProfile = (AbstractConditionProfile)condition.getConditionProfile();
                TestCaseGenerationConditionInterface testProfile = (TestCaseGenerationConditionInterface)((Object)condition.getConditionProfile());
                String conditionName = conditionProfile.getName();
                String fieldName = this.myRepository.getConditionFieldName(conditionName);
                if (!fieldName.equals("")) {
                    testProfile.setTestFieldDefinition(this.myRepository.getFieldDefinitionByName(fieldName));
                }
                String settingsXML = condition.getXMLConfig();
                Element settingsElement = XMLUtil.buildDocumentFromString(settingsXML).getDocumentElement();
                this.myWizardOptions.myElementConfigXML.put(condition, settingsElement);
                List<Variable> testVariables = testProfile.getTestVariables(settingsElement, null);
                if (testVariables == null) {
                    testVariables = TestCaseGenerationDefs.getDefaultTestVariables();
                }
                Element testElement = this.printTestVariables(condition, testVariables);
                this.myWizardOptions.myElementTestXML.put(condition, testElement);
                this.updateConditionSettings(condition);
                for (String affectedField : this.myWizardOptions.myConditionTestCaseFieldInformation.get(condition).keySet()) {
                    ArrayList<String> affectingConditions = (ArrayList<String>)affectedFields.get(affectedField);
                    if (affectedFields.get(affectedField) == null) {
                        affectingConditions = new ArrayList<String>();
                    }
                    affectingConditions.add(conditionName);
                    affectedFields.put(affectedField, affectingConditions);
                }
                continue;
            }
            if (!(node instanceof TSModifier)) continue;
            TSModifier modifier = (TSModifier)node;
            modifier.getDescription();
            if (!TestCaseGenerator.supportsTestCaseGeneration(modifier) && !unsupportedModifierElements.contains(modifier.getNodeName())) {
                if (modifier instanceof GenerationPathGotoModifier) continue;
                unsupportedModifierElements.add(modifier.getNodeName());
                continue;
            }
            TestCaseGenerationModifierInterface testProfile = (TestCaseGenerationModifierInterface)((Object)modifier.getProfile());
            String settingsXML = modifier.getXMLConfig();
            Element settingsElement = XMLUtil.buildDocumentFromString(settingsXML).getDocumentElement();
            this.myWizardOptions.myElementConfigXML.put(modifier, settingsElement);
            List<Variable> testVariables = testProfile.getTestVariables(settingsElement, null);
            Element testElement = this.printTestVariables(modifier, testVariables);
            this.myWizardOptions.myElementTestXML.put(modifier, testElement);
            this.myWizardOptions.isManualValidationPossible = testProfile.isManualValidationPossible(settingsElement);
            this.updateModifierSettings(modifier);
            if (this.myWizardOptions.isManualValidationPossible) continue;
            for (String field : this.myWizardOptions.myModifierTestCaseFieldInformation.get(modifier).keySet()) {
                this.myWizardOptions.mySelectedValidationFields.put(field, true);
            }
        }
        if (unsupportedConditionElements.size() > 0 || unsupportedModifierElements.size() > 0) {
            String unsupportedString = "";
            if (unsupportedConditionElements.size() > 0) {
                unsupportedString = unsupportedString + "\n\nThe unsupported conditions are:";
                for (String element : unsupportedConditionElements) {
                    unsupportedString = unsupportedString + "\n " + element;
                }
            }
            if (unsupportedModifierElements.size() > 0) {
                unsupportedString = unsupportedString + "\n\nThe unsupported modifiers are:";
                for (String element : unsupportedModifierElements) {
                    unsupportedString = unsupportedString + "\n " + element;
                }
            }
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "RMA", "The path leading to the selected modifier contains conditions/modifiers that doesn't support automatic test case generation.\nYou will have to enter test case values manually for these elements." + unsupportedString);
        }
        String affectedString = "";
        for (String affectedField : affectedFields.keySet()) {
            List affectingConditions = (List)affectedFields.get(affectedField);
            if (affectingConditions.size() <= 1) continue;
            affectedString = affectedString + "\n" + affectedField + " (";
            for (int i = 0; i < affectingConditions.size(); ++i) {
                affectedString = affectedString + (String)affectingConditions.get(i);
                if (i >= affectingConditions.size() - 1) continue;
                affectedString = affectedString + ", ";
            }
            affectedString = affectedString + ")";
        }
        if (!affectedString.equals("")) {
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "RMA", "The path leading to the selected modifier contains multiple conditions that will affect the same simulation field.\nThis may lead to generation conflicts and it is strongly advised to review the produced simulation set afterwards.\n\nThe affected simulation fields are:" + affectedString);
        }
    }

    private void updateConditionSettings(TSCondition condition) throws Exception {
        try {
            Element settingsElement = this.myWizardOptions.myElementConfigXML.get(condition);
            Element testElement = this.myWizardOptions.myElementTestXML.get(condition);
            Map<String, Object> testCaseFieldInformation = ((TestCaseGenerationConditionInterface)((Object)condition.getConditionProfile())).getTestSimulationFieldValues(settingsElement, testElement);
            this.myWizardOptions.myConditionTestCaseFieldInformation.put(condition, testCaseFieldInformation);
            Map<String, Object> singleTestCaseFieldInformation = this.produceSingleValueMap(condition);
            this.myWizardOptions.myConditionSingleTestCaseFieldInformation.put(condition, singleTestCaseFieldInformation);
            Map<Object, Object> faultyTestCaseInformation = new HashMap();
            if (TestCaseGenerator.supportsExtendedTestCaseGeneration(condition)) {
                faultyTestCaseInformation = ((TestCaseGenerationConditionExtendedInterface)((Object)condition.getConditionProfile())).getFaultyTestSimulationFieldValues(settingsElement, testElement);
            } else {
                for (String field : testCaseFieldInformation.keySet()) {
                    faultyTestCaseInformation.put(field, TestCaseGenerationDefs.DONT_USE_SIMULATION_FIELD);
                }
            }
            this.myWizardOptions.myFaultyTestCaseFieldInformation.put(condition, faultyTestCaseInformation);
        }
        catch (Exception e) {
            this.myWizardOptions.myConditionTestCaseFieldInformation.put(condition, new HashMap());
            this.myWizardOptions.myConditionSingleTestCaseFieldInformation.put(condition, new HashMap());
            this.myWizardOptions.myFaultyTestCaseFieldInformation.put(condition, new HashMap());
            this.myTreeRenderer.addFaultyNodes(condition, e.getMessage());
        }
    }

    private void updateModifierSettings(TSModifier modifier) throws Exception {
        try {
            Element settingsElement = this.myWizardOptions.myElementConfigXML.get(modifier);
            Element testElement = this.myWizardOptions.myElementTestXML.get(modifier);
            Map<String, Object> testCaseFieldInformation = ((TestCaseGenerationModifierInterface)((Object)modifier.getProfile())).getTestSimulationFieldValues(settingsElement, testElement);
            this.myWizardOptions.myModifierTestCaseFieldInformation.put(modifier, testCaseFieldInformation);
        }
        catch (Exception e) {
            this.myWizardOptions.myModifierTestCaseFieldInformation.put(modifier, new HashMap());
            this.myTreeRenderer.addFaultyNodes(modifier, e.getMessage());
        }
    }

    private Map<String, Object> produceSingleValueMap(TSCondition condition) {
        Map<String, Object> tempTestCaseMap = this.myWizardOptions.myConditionTestCaseFieldInformation.get(condition);
        String[] fieldNames = tempTestCaseMap.keySet().toArray(new String[0]);
        HashMap<String, Object> singleTestCaseFieldInformation = new HashMap<String, Object>();
        for (int i = 0; i < fieldNames.length; ++i) {
            Object fieldInformation = tempTestCaseMap.get(fieldNames[i]);
            if (fieldInformation.getClass().isArray()) {
                singleTestCaseFieldInformation.put(fieldNames[i], ((Object[])fieldInformation)[0]);
                continue;
            }
            singleTestCaseFieldInformation.put(fieldNames[i], fieldInformation);
        }
        return singleTestCaseFieldInformation;
    }

    private void initComponents() {
        this.myConfigurationPanel = new NodeConfigurationPanel();
        this.myTree = new GenerationPathTree(this, this.myRoot, this.myConfigurationPanel, this.myWizardOptions);
        this.myTree.addTreeSelectionListener(this);
        this.myTreeRenderer = new GenerationPathRenderer();
        this.myTree.setCellRenderer(this.myTreeRenderer);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.myConfigurationPanelHolder = new JPanel(new GridBagLayout());
        this.myConfigurationPanelHolder.add((Component)this.myConfigurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)this.createRightPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        rightPanel.add((Component)this.myConfigurationPanelHolder, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.myTree), rightPanel);
        splitPane.setResizeWeight(0.3);
        splitPane.setDividerLocation(0.3);
        this.add((Component)splitPane, gbc);
    }

    private JPanel createRightPanel() {
        JPanel panel = new JPanel();
        JPanel infoPanel = new JPanel();
        panel.setBorder(BorderFactory.createBevelBorder(0));
        this.myOneTestCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TestCaseGenerationSetupPanel.this.myOneTestCheckbox.isSelected()) {
                    ((TestCaseGenerationSetupPanel)TestCaseGenerationSetupPanel.this).myWizardOptions.mySingleTestCase = true;
                    TestCaseGenerationSetupPanel.this.updateTestSettingsPanel(TestCaseGenerationSetupPanel.this.myTree.getSelectionPath());
                } else {
                    ((TestCaseGenerationSetupPanel)TestCaseGenerationSetupPanel.this).myWizardOptions.mySingleTestCase = false;
                    TestCaseGenerationSetupPanel.this.updateTestSettingsPanel(TestCaseGenerationSetupPanel.this.myTree.getSelectionPath());
                }
                TestCaseGenerationSetupPanel.this.updateTestCount();
            }
        });
        infoPanel.setLayout(new GridBagLayout());
        infoPanel.add((Component)this.myCurrentNumLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 8, 0, 0), 0, 0));
        infoPanel.add((Component)this.myNumOfValuesForCurrentLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 5, 0, 0), 0, 0));
        infoPanel.add((Component)this.myTotalLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 8, 0, 0), 0, 0));
        infoPanel.add((Component)this.myTotNumOfTestsLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 5, 0, 8), 0, 0));
        infoPanel.add((Component)this.myOneTestCheckbox, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 16, 0, new Insets(10, 8, 8, 8), 0, 0));
        panel.setLayout(new BorderLayout());
        panel.add((Component)infoPanel, "Center");
        return panel;
    }

    @Override
    public String getPanelDescription() {
        return "Decide the number of possibilities that should be included in the test set";
    }

    @Override
    public String getPanelIdentifier() {
        return "Setup";
    }

    @Override
    public boolean hasNeededData() {
        return true;
    }

    @Override
    public void panelIsVisible() {
    }

    @Override
    public void wizardCanceled() {
    }

    private TreePath extractTreeCopy(TSTariffStructure root, TreePath modifierPath) {
        TSTariffStructure rootNode = null;
        StringWriter buf = new StringWriter();
        PrintWriter out = new PrintWriter(buf);
        root.print(out, 0, "");
        RatingJTreeNodeFactory nodeFactory = new RatingJTreeNodeFactory(this.myServiceName, this.myRepository);
        RatingJTreeErrorHandler errorHandler = new RatingJTreeErrorHandler();
        RatingRuleBuilder builder = new RatingRuleBuilder(nodeFactory, (RatingRuleBuilderErrorHandler)errorHandler);
        try {
            rootNode = (TSTariffStructure)builder.buildFromString(buf.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (rootNode != null) {
            TreePath newModifierPath = this.getOldPathInNewTree(modifierPath, rootNode);
            rootNode.setTreeModel((TariffDAGModel)this.myWizardOptions.myRatingRuleTree.getModel());
            this.stripUnwantedNodes(newModifierPath);
            return newModifierPath;
        }
        return null;
    }

    private void stripUnwantedNodes(TreePath modifierPath) {
        for (int i = 0; i < modifierPath.getPathCount(); ++i) {
            TariffDAGNode currentNode = (TariffDAGNode)modifierPath.getPath()[i];
            for (int j = 0; j < currentNode.getChildCount(); ++j) {
                TariffDAGNode child = (TariffDAGNode)currentNode.getChildAt(j);
                if (child instanceof TSNode) {
                    if (child == (TariffDAGNode)modifierPath.getPath()[i + 1]) continue;
                    currentNode.remove(child);
                    --j;
                    continue;
                }
                if (child instanceof TSModifier) {
                    if (child == modifierPath.getLastPathComponent()) continue;
                    currentNode.remove(child);
                    --j;
                    continue;
                }
                if (!(child instanceof TSLink)) continue;
                if (child.getNodeType() == 1) {
                    if (child == (TariffDAGNode)modifierPath.getPath()[i + 1]) continue;
                    currentNode.remove(child);
                    --j;
                    continue;
                }
                if (child.getNodeType() != 3 || child.getChildAt(0) == modifierPath.getLastPathComponent()) continue;
                currentNode.remove(child);
                --j;
            }
        }
    }

    private TreePath getOldPathInNewTree(TreePath currentPath, TSTariffStructure rootNode) {
        if (currentPath == null || rootNode == null) {
            return null;
        }
        TreePath newPath = new TreePath(rootNode);
        for (int i = 0; i < currentPath.getPath().length - 1; ++i) {
            TariffDAGNode currentNode = (TariffDAGNode)currentPath.getPath()[i];
            int index = currentNode.getIndexOfChild((TariffDAGNode)currentPath.getPath()[i + 1]);
            newPath = newPath.pathByAddingChild(((TariffDAGNode)newPath.getLastPathComponent()).getChildAt(index));
        }
        return newPath;
    }

    @Override
    public Object getDataItem(Object reference) {
        return null;
    }

    @Override
    public Object getDataItem() {
        return null;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public void reset() {
    }

    private Element printTestVariables(TariffDAGNode node, List<Variable> modelData) throws Exception {
        if (!TestCaseGenerator.supportsTestCaseGeneration(node)) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (node instanceof TSCondition || node instanceof TSModifier) {
            TestCaseGenerationInterface generator = (TestCaseGenerationInterface)((Object)((TSElement)node).getClassProfile());
            generator.printTestVariables(pw, modelData);
        }
        pw.flush();
        String xml = sw.toString();
        if ("".equals(xml)) {
            xml = TestCaseGenerationDefs.getDefaultTestSettingsXml();
        }
        return XMLUtil.buildDocumentFromString(xml).getDocumentElement();
    }

    @Override
    public void setDataItem(Object reference, Object object) {
        try {
            boolean reloadVariables = false;
            VarTableModel model = this.myConfigurationPanel.getTable().getTableModel();
            List<Variable> modelData = model.getData();
            TreePath selectedPath = this.myTree.getSelectionPath();
            if (selectedPath != null && selectedPath.getLastPathComponent() != null) {
                TariffDAGNode selectedNode = (TariffDAGNode)selectedPath.getLastPathComponent();
                if (!TestCaseGenerator.supportsTestCaseGeneration(selectedNode)) {
                    return;
                }
                boolean isCondition = selectedNode instanceof TSCondition;
                if (isCondition || selectedNode instanceof TSModifier) {
                    TestCaseGenerationInterface generator = (TestCaseGenerationInterface)((Object)((TSElement)selectedNode).getClassProfile());
                    reloadVariables = generator.testParameterChanged((String)reference, (Variable)object, modelData);
                    Element testXML = this.printTestVariables(selectedNode, modelData);
                    this.myWizardOptions.myElementTestXML.put(selectedNode, testXML);
                    if (isCondition) {
                        this.updateConditionSettings((TSCondition)selectedNode);
                    } else {
                        this.updateModifierSettings((TSModifier)selectedNode);
                    }
                }
                if (reloadVariables) {
                    for (int i = 0; i < modelData.size(); ++i) {
                        modelData.get(i).setDataItem(this);
                    }
                    model.setData(modelData);
                }
            }
            this.updateTestCount();
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "generation", 2, "Wizard failed to update!", true);
        }
    }

    @Override
    public void setDataItem(Object object) {
    }

    public void updateTestCount() {
        long totNumOfTests;
        String numOfTestValues = "0";
        TreePath selectedPath = this.myTree.getSelectionPath();
        if (selectedPath != null && selectedPath.getLastPathComponent() != null) {
            TariffDAGNode selectedNode = (TariffDAGNode)selectedPath.getLastPathComponent();
            if (selectedNode instanceof TSCondition) {
                if (TestCaseGenerator.isInversed((TSCondition)selectedNode)) {
                    numOfTestValues = "0";
                } else if (TestCaseGenerator.isCompoundBooleanCondition(selectedNode)) {
                    numOfTestValues = "-";
                } else if (this.myWizardOptions.mySingleTestCase) {
                    numOfTestValues = "1";
                } else {
                    ConditionProfile selectedProfile = ((TSCondition)selectedNode).getConditionProfile();
                    if (selectedProfile instanceof TestCaseGenerationConditionInterface) {
                        try {
                            long count = this.calculateVariantCountForCondition(selectedNode);
                            numOfTestValues = Long.toString(count);
                        }
                        catch (Exception e) {
                            numOfTestValues = "0";
                        }
                    }
                }
            } else {
                numOfTestValues = "-";
            }
        }
        this.myNumOfValuesForCurrentLabel.setText(numOfTestValues);
        if (this.myWizardOptions.mySingleTestCase) {
            this.myWizardOptions.myNumberOfTestCases = 1L;
            this.myTotNumOfTestsLabel.setText("1");
            return;
        }
        this.myWizardOptions.myNumberOfTestCases = totNumOfTests = this.calculateTestCountAtLevel(this.myRoot);
        if (this.booleansExistInPath) {
            this.myTotalLabel.setText("Total number of tests (approximation):");
        } else {
            this.myTotalLabel.setText("Total number of tests: ");
        }
        this.myTotNumOfTestsLabel.setText(Long.toString(totNumOfTests));
    }

    private long calculateTestCountAtLevel(TariffDAGNode currentNode) {
        ArrayList<Long> subTests = new ArrayList<Long>(5);
        for (int i = 0; i < currentNode.getChildCount(); ++i) {
            if (currentNode.getChildAt(i) instanceof TSCondition || TestCaseGenerator.isConditionLink((TariffDAGNode)currentNode.getChildAt(i))) {
                TSCondition condition = TestCaseGenerator.isConditionLink((TariffDAGNode)currentNode.getChildAt(i)) ? (TSCondition)currentNode.getChildAt(i).getChildAt(0) : (TSCondition)currentNode.getChildAt(i);
                ConditionProfile selectedProfile = condition.getConditionProfile();
                if (selectedProfile instanceof CompoundBooleanConditionProfile) {
                    subTests.add(this.calculateTestCountAtLevel(condition));
                }
                if (!(selectedProfile instanceof TestCaseGenerationConditionInterface)) continue;
                try {
                    long count = this.calculateVariantCountForCondition(condition);
                    subTests.add(count);
                }
                catch (Exception e) {
                    subTests.add(0L);
                }
                continue;
            }
            if (!(currentNode.getChildAt(i) instanceof TSNode) && !TestCaseGenerator.isNodeLink((TariffDAGNode)currentNode.getChildAt(i))) continue;
            TariffDAGNode n = this.getNodeOrLinkTarget((TariffDAGNode)currentNode.getChildAt(i));
            subTests.add(this.calculateTestCountAtLevel(n));
        }
        if (!subTests.isEmpty()) {
            if (currentNode instanceof TSTariffStructure) {
                return (Long)subTests.get(0);
            }
            long subTotalTestCount = 1L;
            ArrayList<TSCondition> conditions = new ArrayList<TSCondition>();
            for (int i = 0; i < currentNode.getChildCount(); ++i) {
                TariffDAGNode child = (TariffDAGNode)currentNode.getChildAt(i);
                if (!(child instanceof TSCondition) && !TestCaseGenerator.isConditionLink(child) || TestCaseGenerator.isCompoundBooleanCondition(child)) continue;
                conditions.add((TSCondition)this.getNodeOrLinkTarget(child));
            }
            boolean hasRemovedFaultyCases = false;
            for (int i = 0; i < subTests.size(); ++i) {
                TariffDAGNode child = (TariffDAGNode)currentNode.getChildAt(i);
                if (child instanceof TSNode || TestCaseGenerator.isNodeLink(child)) {
                    subTotalTestCount = Math.max(subTotalTestCount - 1L, 1L);
                    hasRemovedFaultyCases = true;
                }
                if (child instanceof TSNode || TestCaseGenerator.isNodeLink(child) || TestCaseGenerator.isCompoundBooleanCondition(child)) {
                    subTotalTestCount *= ((Long)subTests.get(i)).longValue();
                    continue;
                }
                subTotalTestCount *= (Long)subTests.get(i) + 1L;
            }
            if (!this.booleansExistInPath && !hasRemovedFaultyCases) {
                subTotalTestCount = Math.max(subTotalTestCount - 1L, 1L);
            }
            return subTotalTestCount;
        }
        return 1L;
    }

    private TariffDAGNode getNodeOrLinkTarget(TariffDAGNode node) {
        TariffDAGNode ret = node;
        if (node.isLink()) {
            ret = (TariffDAGNode)node.getChildAt(0);
        }
        return ret;
    }

    private long calculateVariantCountForCondition(TariffDAGNode condition) {
        Map<String, Object> currentValue = this.myWizardOptions.myConditionTestCaseFieldInformation.get(condition);
        String[] keys = currentValue.keySet().toArray(new String[0]);
        long count = 1L;
        for (String key : keys) {
            if (!currentValue.get(key).getClass().isArray()) continue;
            count *= (long)((Object[])currentValue.get(key)).length;
        }
        return count;
    }

    public Node getTestSettingsForElement(TariffDAGNode element) {
        Node ret = this.myWizardOptions.myElementTestXML.get(element);
        return ret;
    }

    public static Node getVariableValueForNode(TSCondition aCondition) {
        try {
            Element rootNode = XMLUtil.buildDocumentFromString(aCondition.getXMLConfig()).getDocumentElement();
            return rootNode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        if (path != null) {
            this.updateTestSettingsPanel(e.getPath());
        }
    }

    private void updateTestSettingsPanel(TreePath path) {
        String errorMessage = this.myTreeRenderer.getErrorMessage((TariffDAGNode)path.getLastPathComponent());
        if (errorMessage != null) {
            this.setConfigurationPanel(errorMessage);
            return;
        }
        if (!(path.getLastPathComponent() instanceof TSTariffStructure) && this.myWizardOptions.mySingleTestCase) {
            this.setConfigurationPanel("<html>No settings needed if single case is generated.</html>");
        } else if (path.getLastPathComponent() instanceof TSCondition) {
            TSCondition condition = (TSCondition)path.getLastPathComponent();
            if (TestCaseGenerator.isInversed((TSCondition)path.getLastPathComponent()) && !TestCaseGenerator.isCompoundBooleanCondition(condition)) {
                this.setConfigurationPanel("<html>There are no values generated for this condition<br>since it's inversed by a node/boolean condition.</html>");
            } else if (!(condition.getConditionProfile() instanceof TestCaseGenerationConditionInterface)) {
                this.setConfigurationPanel("<html>There are no settings available for this condition</html>");
            } else {
                this.setConfigurationPanel();
            }
        } else if (path.getLastPathComponent() instanceof TSModifier) {
            TSModifier modifier = (TSModifier)path.getLastPathComponent();
            if (modifier.getProfile() instanceof TestCaseGenerationModifierInterface) {
                this.setConfigurationPanel();
            } else {
                this.setConfigurationPanel("<html>There are no settings avaliabe for this modifier.</html>");
            }
        } else if (path.getLastPathComponent() instanceof TSTariffStructure && ((TSTariffStructure)path.getLastPathComponent()).getParent() == null) {
            JPanel panel = this.setConfigurationPanel("<html>If this selection tree is a sub tree,<br>drag a goto modifier here to include it in the generation.</html>");
            new DropTarget(panel, this);
        } else {
            this.setConfigurationPanel("<html>Select a condition/modifier to view its test settings.</html>");
        }
    }

    private JPanel setConfigurationPanel(String message) {
        this.myConfigurationPanelHolder.removeAll();
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(message);
        label.setHorizontalAlignment(0);
        panel.add((Component)label, "Center");
        panel.setBorder(BorderFactory.createBevelBorder(0));
        this.myConfigurationPanelHolder.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myConfigurationPanelHolder.validate();
        this.myConfigurationPanelHolder.repaint();
        return panel;
    }

    private void setConfigurationPanel() {
        this.myConfigurationPanelHolder.removeAll();
        this.myConfigurationPanelHolder.add((Component)this.myConfigurationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myConfigurationPanelHolder.validate();
        this.myConfigurationPanelHolder.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        List<Variable> variables = this.myConfigurationPanel.getTable().getTableModel().getData();
        for (Variable var : variables) {
            this.myWizardOptions.mySelectedValidationFields.put(var.getLabel(), var.isSelected());
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable transferable = dtde.getTransferable();
            if (!transferable.isDataFlavorSupported(RatingRuleNodeTransferable.TREE_PATH_FLAVOR)) {
                throw new UnsupportedFlavorException(null);
            }
            TreePath[] data = (TreePath[])transferable.getTransferData(RatingRuleNodeTransferable.TREE_PATH_FLAVOR);
            if (data.length > 1) {
                throw new UnsupportedFlavorException(null);
            }
            TreePath selectionPath = data[0];
            if (!(selectionPath.getLastPathComponent() instanceof TSModifier) || !(((TSModifier)selectionPath.getLastPathComponent()).getProfile() instanceof GoToModifierProfile)) {
                throw new UnsupportedFlavorException(null);
            }
            TSTariffStructure root = (TSTariffStructure)selectionPath.getPath()[0];
            if (!this.myServiceName.equals(root.getServiceId())) {
                DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "RMA", "The Selection tree with the GoTo modifier must be of the same type as the sub tree.");
                return;
            }
            TreePath callingPath = this.extractTreeCopy(root, selectionPath);
            TreePath calledPath = this.myWizardOptions.myModifierPath[0];
            TSModifier gotoModifier = (TSModifier)callingPath.getLastPathComponent();
            TSNode parent = (TSNode)gotoModifier.getParent();
            int indexOfGoto = parent.getIndexOfChild(gotoModifier);
            parent.remove(gotoModifier);
            gotoModifier = new GenerationPathGotoModifier(null, this.myRepository);
            parent.insertChildAt(indexOfGoto, gotoModifier);
            callingPath = callingPath.getParentPath().pathByAddingChild(gotoModifier);
            Object[] newPath = new Object[callingPath.getPathCount() + calledPath.getPathCount()];
            System.arraycopy(callingPath.getPath(), 0, newPath, 0, callingPath.getPathCount());
            System.arraycopy(calledPath.getPath(), 0, newPath, callingPath.getPathCount(), calledPath.getPathCount());
            this.myWizardOptions.myModifierPath[0] = new TreePath(newPath);
            this.myRoot = (TSTariffStructure)this.myWizardOptions.myModifierPath[0].getPath()[0];
            TariffDAGModel newModel = new TariffDAGModel(this.myTree, this.myRoot);
            newModel.addTariffStrucureNodeAsChild(callingPath.getPath(), (TSTariffStructure)calledPath.getPathComponent(0));
            this.myTree.setModel(newModel);
            this.initTreeNodes();
            this.updateTestCount();
            this.myTree.setSelectionPath(new TreePath(newPath));
        }
        catch (UnsupportedFlavorException e) {
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "RMA", "Only GoTo modifiers may be dropped here.");
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "generation", 1, "Wizard cannot handle the content that was dropped!", true);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

