/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.tree;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.gui.simulator.SimulationExecutionEvent;
import com.ericsson.ere.gui.simulator.tree.TraceTreeNode;
import com.ericsson.ere.selectiontree.conditions.AbstractCondition;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.interfaces.TariffStructure;
import com.ericsson.ere.selectiontree.modifiers.AbstractModifier;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.selectiontree.statements.AbstractNodeStatement;
import com.ericsson.ere.selectiontree.statements.DefsStatement;
import com.ericsson.ere.selectiontree.statements.ImmutableStatement;
import com.ericsson.ere.selectiontree.structures.AbstractTariffStructure;
import com.ericsson.ere.selectiontree.structures.ImmutableTariffStructure;
import com.ericsson.ere.trace.GuiTraceTreeExecutor;
import com.ericsson.ere.trace.TraceInfoHelper;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceTreeExecutor;
import com.ericsson.ere.util.HTMLUtil;
import ericsson.ere.interfaces.AbstractDAGNode;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffNodeLink;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.SwingWorker;

public class ExecutorBasedTraceTreeNode
extends TraceTreeNode {
    private final AbstractDAGNode myTraceNode;
    private final GuiTraceTreeExecutor.GuiTraceData myTraceData;
    private List<TracePoint> myTracePoints = new ArrayList<TracePoint>();
    private static final String NODE_PATH = "NodePath";

    private ExecutorBasedTraceTreeNode(AbstractDAGNode newTraceNode, TraceTreeExecutor.TraceData traceData, Stack<Object> currentStack, Map<Object, List<TracePoint>> map, boolean newTree) {
        currentStack.push(newTraceNode);
        this.myTraceNode = newTraceNode;
        this.myTraceData = (GuiTraceTreeExecutor.GuiTraceData)traceData;
        this.buildOwnedTracePointsList(currentStack, map);
        this.checkException();
        this.checkType();
        this.myExecuted = newTree ? true : this.myTracePoints.size() > 0;
        this.checkLabel();
    }

    private static AbstractDAGNode getFirstValidNode(AbstractDAGNode node) {
        DAGNode child = node;
        while (child instanceof TariffNodeLink) {
            child = child.getChildAt(0);
        }
        return child;
    }

    private boolean isConditionSatisfied() {
        boolean result = false;
        if (this.isExecuted()) {
            for (TracePoint p : this.myTracePoints) {
                if (p.getInfo(TraceNodeInterface.TEST_RESULT) != Boolean.TRUE) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private void checkLabel() {
        String name = "?";
        String nodeId = "";
        String extra = " ";
        if (this.myTraceNode instanceof ImmutableCondition) {
            ImmutableCondition cond = (ImmutableCondition)this.myTraceNode;
            name = cond.getConditionName();
            nodeId = cond.getNodeId();
            if (this.isExecuted()) {
                boolean sated = this.isConditionSatisfied();
                extra = " (<b>" + sated + "</b>)";
            }
        } else if (this.myTraceNode instanceof AbstractCondition) {
            AbstractCondition cond = (AbstractCondition)this.myTraceNode;
            name = cond.getConditionName();
            nodeId = cond.getNodeId();
            if (this.isExecuted()) {
                boolean sated = this.isConditionSatisfied();
                extra = " (<b>" + sated + "</b>)";
            }
        } else if (this.myTraceNode instanceof ImmutableModifier) {
            ImmutableModifier mod = (ImmutableModifier)this.myTraceNode;
            name = mod.getName();
            nodeId = mod.getNodeId();
        } else if (this.myTraceNode instanceof AbstractModifier) {
            AbstractModifier mod = (AbstractModifier)this.myTraceNode;
            name = mod.getTypename();
            nodeId = mod.getNodeId();
        } else if (this.myTraceNode instanceof ImmutableStatement) {
            ImmutableStatement stat = (ImmutableStatement)this.myTraceNode;
            name = stat.getName();
            nodeId = stat.getNodeId();
        } else if (this.myTraceNode instanceof AbstractNodeStatement) {
            AbstractNodeStatement stat = (AbstractNodeStatement)this.myTraceNode;
            name = stat.getName();
            nodeId = stat.getNodeId();
        } else if (this.myTraceNode instanceof AbstractTariffStructure) {
            AbstractTariffStructure struct = (AbstractTariffStructure)this.myTraceNode;
            name = struct.toString();
            nodeId = struct.getNodeId();
        } else if (this.myTraceNode instanceof ImmutableTariffStructure) {
            ImmutableTariffStructure struct = (ImmutableTariffStructure)this.myTraceNode;
            name = struct.toString();
            nodeId = struct.getNodeId();
        }
        this.myLabel = HTMLUtil.escape(name);
        if (!nodeId.equals(name)) {
            this.myLabel = this.myLabel + " [" + HTMLUtil.escape(nodeId) + "]";
        }
        this.myLabel = this.myLabel + extra;
    }

    private void checkType() {
        this.myType = this.myTraceNode instanceof DefsStatement ? TraceTreeNode.TraceNodeType.DEFINITION : (this.myTraceNode instanceof ImmutableCondition || this.myTraceNode instanceof AbstractCondition ? TraceTreeNode.TraceNodeType.CONDITION : (this.myTraceNode instanceof ImmutableModifier || this.myTraceNode instanceof AbstractModifier ? TraceTreeNode.TraceNodeType.MODIFIER : (this.myTraceNode instanceof ImmutableStatement || this.myTraceNode instanceof AbstractNodeStatement ? TraceTreeNode.TraceNodeType.STATEMENT : TraceTreeNode.TraceNodeType.TARIFFSTRUCTURE)));
    }

    private void buildOwnedTracePointsList(Stack<Object> uiStack, Map<Object, List<TracePoint>> map) {
        this.myTracePoints = new ArrayList<TracePoint>();
        List<TracePoint> tpList = map.get(this.myTraceNode);
        if (tpList != null) {
            for (TracePoint p : tpList) {
                if (TraceInfoHelper.traceGenerationIsSuppressed(p) || !this.isStackEqual(uiStack, (Stack)p.getInfo(NODE_PATH))) continue;
                this.myTracePoints.add(p);
            }
        }
    }

    private boolean isStackEqual(Stack<Object> uiStack, Stack<Object> executionStack) {
        boolean retVal = false;
        if (uiStack.size() > 0 && uiStack.size() == executionStack.size()) {
            retVal = true;
            for (int i = 0; retVal && i < uiStack.size(); ++i) {
                if (uiStack.get(i) instanceof TariffStructure) continue;
                retVal = uiStack.get(i) == executionStack.get(i);
            }
        }
        return retVal;
    }

    private static Map<Object, List<TracePoint>> convertTracePointListToMap(List<TracePoint> tracePoints) {
        IdentityHashMap<Object, List<TracePoint>> map = new IdentityHashMap<Object, List<TracePoint>>();
        for (TracePoint tp : tracePoints) {
            Object tracedElement = TraceInfoHelper.getTracedElement(tp);
            ArrayList<TracePoint> list = (ArrayList<TracePoint>)map.get(tracedElement);
            if (list == null) {
                list = new ArrayList<TracePoint>();
                map.put(tracedElement, list);
            }
            list.add(tp);
        }
        return map;
    }

    private void checkException() {
        TracePoint p;
        Iterator<TracePoint> iterator = this.myTracePoints.iterator();
        while (iterator.hasNext() && (this.myException = TraceInfoHelper.getThrowable(p = iterator.next())) == null) {
        }
    }

    @Override
    public String getTraceString(int index) {
        TracePoint tp = this.myTracePoints.get(index);
        StringBuilder trace = new StringBuilder(TraceInfoHelper.createDenseTraceStringForTracePoint(tp));
        Boolean testResult = (Boolean)tp.getInfo(TraceNodeInterface.TEST_RESULT);
        if (testResult != null) {
            String testString = testResult != false ? "<b>(true)</b> " : "<b>(false)</b> ";
            trace.insert(0, testString);
        }
        return trace.toString();
    }

    @Override
    public String getFullTrace(DataSet pre, DataSet post) {
        return this.myTraceData.getTraceAsString(pre, post);
    }

    @Override
    public int getNumberOfTracePoints() {
        return this.myTracePoints.size();
    }

    @Override
    public String getTooltip() {
        return "<html><body>" + this.myLabel + ", number of executions: " + this.getNumberOfTracePoints() + "</html></body>";
    }

    public static ExecutorBasedTraceTreeBuilder createBuilder(GuiTraceTreeExecutor.GuiTraceData traceData, SwingWorker<SimulationExecutionEvent, String> executor, boolean ignoreChildrenToNotExecutedNodes) {
        return new ExecutorBasedTraceTreeBuilder(traceData, executor, ignoreChildrenToNotExecutedNodes);
    }

    public static final class ExecutorBasedTraceTreeBuilder {
        private final GuiTraceTreeExecutor.GuiTraceData myTraceData;
        private final SwingWorker<SimulationExecutionEvent, String> myWorker;
        private final Map<Object, List<TracePoint>> myTpMap;
        private final boolean myIgnoreChildrenToNotExecutedNodes;

        private ExecutorBasedTraceTreeBuilder(GuiTraceTreeExecutor.GuiTraceData traceData, SwingWorker<SimulationExecutionEvent, String> worker, boolean ignoreChildrenToNotExecutedNodes) {
            this.myTraceData = traceData;
            this.myWorker = worker;
            this.myIgnoreChildrenToNotExecutedNodes = ignoreChildrenToNotExecutedNodes;
            this.myTpMap = ExecutorBasedTraceTreeNode.convertTracePointListToMap(this.myTraceData.getTracePoints());
        }

        public ExecutorBasedTraceTreeNode buildTraceTreeForNode(AbstractDAGNode rootNodeToWrap) {
            Stack<Object> stack = new Stack<Object>();
            ExecutorBasedTraceTreeNode traceTreeRoot = new ExecutorBasedTraceTreeNode(rootNodeToWrap, this.myTraceData, stack, this.myTpMap, true);
            return this.buildTreeBranchFromNode(traceTreeRoot, stack);
        }

        private ExecutorBasedTraceTreeNode buildTreeBranchFromNode(ExecutorBasedTraceTreeNode parentTraceNode, Stack<Object> stack) {
            boolean continueTrace = true;
            if (this.childrenShouldBeChecked(parentTraceNode)) {
                TariffStructure rootChild = this.myTraceData.getExecutedTreeJumps().get(parentTraceNode.myTraceNode);
                if (rootChild != null) {
                    Stack currentStack = (Stack)stack.clone();
                    ExecutorBasedTraceTreeNode wrappedChild = new ExecutorBasedTraceTreeNode((AbstractDAGNode)((Object)rootChild), this.myTraceData, currentStack, this.myTpMap, true);
                    parentTraceNode.add(wrappedChild);
                    continueTrace = this.buildTreeBranchFromNode(wrappedChild, currentStack) != null;
                } else {
                    for (int i = 0; i < parentTraceNode.myTraceNode.getChildCount() && continueTrace; ++i) {
                        AbstractDAGNode currentChildToWrap = (AbstractDAGNode)parentTraceNode.myTraceNode.getChildAt(i);
                        Stack currentStack = (Stack)stack.clone();
                        ExecutorBasedTraceTreeNode wrappedChild = new ExecutorBasedTraceTreeNode(ExecutorBasedTraceTreeNode.getFirstValidNode(currentChildToWrap), this.myTraceData, currentStack, this.myTpMap, false);
                        parentTraceNode.add(wrappedChild);
                        continueTrace = this.buildTreeBranchFromNode(wrappedChild, currentStack) != null;
                    }
                }
            }
            if (continueTrace && parentTraceNode.getChildCount() == 0) {
                continueTrace = this.myWorker == null ? true : !this.myWorker.isCancelled();
            }
            return continueTrace ? parentTraceNode : null;
        }

        private boolean childrenShouldBeChecked(ExecutorBasedTraceTreeNode parentTraceNode) {
            if (this.myIgnoreChildrenToNotExecutedNodes) {
                return parentTraceNode.isExecuted();
            }
            return true;
        }
    }
}

