/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.tree;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.gui.simulator.tree.TraceTreeModel;
import com.ericsson.ere.gui.simulator.tree.TraceTreeNode;
import com.ericsson.ere.gui.simulator.tree.TraceTreeRenderer;
import com.ericsson.ere.trace.TraceTreeException;
import com.ericsson.ere.trace.filter.HtmlTraceFilter;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TraceTreeGUI
extends JPanel
implements ActionListener,
ItemListener {
    private JScrollPane myScrollPane;
    private JTree myTree;
    private JPanel myTreePanel;
    private JSplitPane mySplitPane;
    private JPanel myDataPanel;
    private JScrollPane myDataScrollPane;
    private JEditorPane myInfoArea;
    private JSlider mySlider;
    private TraceTreeNode myFullTree;
    private JButton myUpButton;
    private JButton myDownButton;
    private int myPreviousDividerLocation = 300;
    private Point myPreviousTreeScrollPosition = null;
    private int myPreviousSliderValue = 0;
    private TraceTreeModel myModel;
    private StepTraceListener myStepTraceListener = new StepTraceListener();

    public TraceTreeGUI() {
        GuiServiceCenter.getInstance().enableHelpKey(this, this.getClass().toString(), null);
    }

    public void setTreeModel(TraceTreeModel aModel) {
        this.myModel = aModel;
        this.myTree.setModel(this.myModel);
    }

    private void expandExecutionTrace() {
        List<TraceTreeNode> trace = this.myModel.getExecutionTrace();
        for (TraceTreeNode etn : trace) {
            TreePath path = this.getPathTo(etn);
            if (path == null) continue;
            this.myTree.expandPath(path.getParentPath());
        }
        TraceTreeNode theLastNodeWithException = this.myModel.getLastException();
        if (theLastNodeWithException != null) {
            TreePath path = this.getPathTo(theLastNodeWithException);
            this.myTree.expandPath(path);
            this.myTree.setSelectionPath(path);
        } else {
            this.mySlider.setValue(this.myPreviousSliderValue);
            if (this.myPreviousTreeScrollPosition != null) {
                this.myScrollPane.validate();
                this.myScrollPane.getHorizontalScrollBar().setValue(this.myPreviousTreeScrollPosition.x);
                this.myScrollPane.getVerticalScrollBar().setValue(this.myPreviousTreeScrollPosition.y);
            }
        }
    }

    public void initLayout() {
        this.myTreePanel = new JPanel(new BorderLayout());
        this.myDataPanel = new JPanel(new BorderLayout());
        if (this.mySplitPane != null) {
            this.myPreviousDividerLocation = this.mySplitPane.getDividerLocation();
        }
        this.mySplitPane = new JSplitPane(0);
        this.mySplitPane.setAutoscrolls(false);
        this.mySplitPane.setOneTouchExpandable(true);
    }

    public void addFilter() {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setMargin(new Insets(4, 8, 4, 8));
        JLabel filterLabel = new JLabel("Filter");
        filterLabel.setOpaque(false);
        String[] boxStrings = new String[]{"None", "True", "False"};
        JComboBox<String> filterList = new JComboBox<String>(boxStrings);
        filterList.setMaximumSize(filterList.getPreferredSize());
        filterList.setEnabled(false);
        filterList.setSelectedIndex(0);
        int executionTraceLength = this.myModel.getExecutionTrace().size();
        this.mySlider = new JSlider(0, Math.max(1, executionTraceLength), 0);
        this.mySlider.setMinorTickSpacing(1);
        this.mySlider.setMajorTickSpacing(1);
        this.mySlider.setPaintTicks(true);
        this.mySlider.setSnapToTicks(true);
        this.mySlider.setOpaque(false);
        this.mySlider.setEnabled(executionTraceLength > 0);
        this.mySlider.addChangeListener(this.myStepTraceListener);
        this.myUpButton = new JButton(RmaDefs.getImageIcon("navigate_up16.png"));
        this.myUpButton.setEnabled(false);
        this.myUpButton.setToolTipText("Go back to previously executed modifier ");
        this.myDownButton = new JButton(RmaDefs.getImageIcon("navigate_down16.png"));
        this.myDownButton.setEnabled(executionTraceLength > 0);
        this.myDownButton.setToolTipText("Step forward to next executed modifier");
        this.myDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TraceTreeGUI.this.mySlider.setValue(Math.min(TraceTreeGUI.this.mySlider.getMaximum(), TraceTreeGUI.this.mySlider.getValue() + 1));
            }
        });
        this.myUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TraceTreeGUI.this.mySlider.setValue(Math.max(TraceTreeGUI.this.mySlider.getMinimum(), TraceTreeGUI.this.mySlider.getValue() - 1));
            }
        });
        JButton summaryButton = new JButton(RmaDefs.getImageIcon("house16.png"));
        summaryButton.setToolTipText("Show summary");
        summaryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TraceTreeGUI.this.mySlider.getValue() == TraceTreeGUI.this.mySlider.getMinimum()) {
                    TraceTreeGUI.this.myTree.getSelectionModel().clearSelection();
                    TraceTreeGUI.this.myTree.scrollRowToVisible(0);
                    TraceTreeGUI.this.setIntoAreaText("");
                } else {
                    TraceTreeGUI.this.mySlider.setValue(TraceTreeGUI.this.mySlider.getMinimum());
                }
            }
        });
        toolBar.add(summaryButton);
        toolBar.add(this.myUpButton);
        toolBar.add(this.myDownButton);
        toolBar.addSeparator();
        toolBar.add(this.mySlider);
        filterList.addItemListener(this);
        this.myTreePanel.add((Component)toolBar, "North");
    }

    private TreePath getPathTo(TreeNode etn) {
        TreePath pathToReturn = null;
        TreeNode node = this.findNodeFor(etn, this.myFullTree);
        if (node != null) {
            ArrayList<TreeNode> path = new ArrayList<TreeNode>();
            while (node != null) {
                path.add(0, node);
                node = node.getParent();
            }
            pathToReturn = new TreePath(path.toArray());
        }
        return pathToReturn;
    }

    private TreeNode findNodeFor(TreeNode etn, TreeNode node) {
        TreeNode foundNode = null;
        if (node == etn) {
            foundNode = node;
        } else {
            for (int i = 0; foundNode == null && i < node.getChildCount(); ++i) {
                foundNode = this.findNodeFor(etn, node.getChildAt(i));
            }
        }
        return foundNode;
    }

    public void addTree(TreeNode inTree) {
        this.myTree = new JTree(inTree);
        this.myTree.setRowHeight(-1);
        ToolTipManager.sharedInstance().registerComponent(this.myTree);
        this.myTree.setShowsRootHandles(true);
        this.myScrollPane = new JScrollPane(this.myTree);
        this.myScrollPane.setVerticalScrollBarPolicy(20);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myTree.setCellRenderer(new TraceTreeRenderer());
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.addTreeSelectionListener(this.myStepTraceListener);
        this.myTreePanel.add((Component)this.myScrollPane, "Center");
    }

    public void addSearch() {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        JLabel searchLabel = new JLabel("Search");
        JTextField searchField = new JTextField(5);
        panel.add((Component)searchLabel, "West");
        panel.add((Component)searchField, "Center");
        this.myTreePanel.add((Component)panel, "South");
        searchField.addActionListener(this);
    }

    public void clearTreePanel() {
        if (this.myInfoArea != null) {
            this.setIntoAreaText("");
        }
        if (this.myTreePanel != null) {
            this.myTreePanel.removeAll();
            this.myTreePanel.validate();
            this.myTreePanel.repaint();
        }
        if (this.myTree != null) {
            ToolTipManager.sharedInstance().unregisterComponent(this.myTree);
            this.myTree.removeTreeSelectionListener(this.myStepTraceListener);
            this.myTree = null;
        }
        this.myModel = null;
        this.myFullTree = null;
        this.myScrollPane = null;
        this.removeAll();
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    public void setTree(TraceTreeNode wrappedRoot, DataSet pre, DataSet post) {
        if (this.myScrollPane != null) {
            this.myPreviousTreeScrollPosition = new Point(this.myScrollPane.getHorizontalScrollBar().getValue(), this.myScrollPane.getVerticalScrollBar().getValue());
        }
        if (this.mySlider != null) {
            this.myPreviousSliderValue = this.mySlider.getValue();
        }
        if (this.myTree != null) {
            ToolTipManager.sharedInstance().unregisterComponent(this.myTree);
        }
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.myTree = null;
        try {
            this.myFullTree = wrappedRoot;
            this.myModel = new TraceTreeModel(this.myFullTree, pre, post);
        }
        catch (TraceTreeException e) {
            throw new TraceTreeException(e);
        }
        this.initLayout();
        this.addFilter();
        this.addTree(this.myFullTree);
        this.mySplitPane.add((Component)this.myTreePanel, "top");
        this.myInfoArea = new JEditorPane("text/html", "");
        this.myInfoArea.setEditable(false);
        this.myInfoArea.setBackground(UIManager.getColor("TextField.background"));
        this.myInfoArea.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.myDataScrollPane = new JScrollPane(this.myInfoArea);
        this.myDataPanel.add((Component)this.myDataScrollPane, "Center");
        this.mySplitPane.add((Component)this.myDataPanel, "bottom");
        this.add((Component)this.mySplitPane, "Center");
        this.mySplitPane.setDividerLocation(this.myPreviousDividerLocation);
        this.expandExecutionTrace();
    }

    private void setIntoAreaText(String trace) {
        this.myInfoArea.setText(trace);
        this.myInfoArea.setCaretPosition(0);
    }

    private class StepTraceListener
    implements TreeSelectionListener,
    ChangeListener {
        private boolean myUpdateEnabled = true;

        private StepTraceListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int currentValue = TraceTreeGUI.this.mySlider.getValue();
            TraceTreeGUI.this.myUpButton.setEnabled(currentValue != TraceTreeGUI.this.mySlider.getMinimum());
            TraceTreeGUI.this.myDownButton.setEnabled(currentValue != TraceTreeGUI.this.mySlider.getMaximum());
            if (currentValue >= 1) {
                TreePath path;
                List<TraceTreeNode> executionTrace = TraceTreeGUI.this.myModel.getExecutionTrace();
                if (currentValue <= executionTrace.size() && (path = TraceTreeGUI.this.getPathTo(executionTrace.get(currentValue - 1))) != null && this.myUpdateEnabled) {
                    this.myUpdateEnabled = false;
                    TraceTreeGUI.this.myTree.expandPath(path.getParentPath());
                    TraceTreeGUI.this.myTree.scrollPathToVisible(path);
                    TraceTreeGUI.this.myTree.setSelectionPath(path);
                    this.myUpdateEnabled = true;
                }
            } else {
                if (this.myUpdateEnabled) {
                    this.myUpdateEnabled = false;
                    TraceTreeGUI.this.myTree.getSelectionModel().clearSelection();
                    TraceTreeGUI.this.myTree.scrollRowToVisible(0);
                    this.myUpdateEnabled = true;
                }
                TraceTreeGUI.this.setIntoAreaText("");
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TraceTreeNode traceNode = (TraceTreeNode)TraceTreeGUI.this.myTree.getLastSelectedPathComponent();
            if (traceNode != null) {
                if (this.myUpdateEnabled) {
                    int index = TraceTreeGUI.this.myModel.getExecutionTrace().indexOf(traceNode);
                    if (TraceTreeGUI.this.mySlider.getValue() != index + 1) {
                        this.myUpdateEnabled = false;
                        TraceTreeGUI.this.mySlider.setValue(index + 1);
                        this.myUpdateEnabled = true;
                    }
                }
                if (traceNode.isExecuted()) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 0; i < traceNode.getNumberOfTracePoints(); ++i) {
                        builder.append(traceNode.getTraceString(i)).append("<br>");
                    }
                    HtmlTraceFilter filter = new HtmlTraceFilter();
                    TraceTreeGUI.this.setIntoAreaText(filter.filterTrace(builder.toString()));
                } else {
                    TraceTreeGUI.this.setIntoAreaText("<b>Not executed</b>");
                }
                if (traceNode.hasException()) {
                    TraceTreeGUI.this.setIntoAreaText(TraceTreeGUI.this.myInfoArea.getText() + "<br><br>EXCEPTION FOUND:<br>" + traceNode.getException().toString().trim().replace("\n", "<br>"));
                }
            }
        }
    }
}

