/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.undoredo;

import com.ericsson.ere.gui.undoredo.UndoableTree;
import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.gui.ratingrules.nodes.DefaultLinkIdUpdater;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.Arrays;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;

public abstract class StructureAlteringNodeEdit
extends AbstractUndoableEdit {
    protected TreePath myPath;
    private int myIndex;
    private UndoableTree myTree;

    public StructureAlteringNodeEdit(UndoableTree tree, Object[] path, int index) {
        this.myPath = new TreePath(path);
        this.myIndex = index;
        this.myTree = tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeNode() {
        this.myTree.setOngoingUndo(true);
        try {
            this.myTree.getTreeModel().delete(this.myPath.getPath());
            TreePath parentPath = this.myPath.getParentPath();
            int nextRowSelection = this.myTree.getRowForPath(parentPath);
            if (nextRowSelection < 0) {
                nextRowSelection = 0;
            }
            TreePath p = this.myTree.getPathForRow(nextRowSelection);
            this.myTree.setSelectionPath(p);
            this.myTree.scrollPathToVisible(p);
            this.myTree.expandPath(parentPath);
        }
        finally {
            this.myTree.setOngoingUndo(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean insertNode() {
        this.myTree.setOngoingUndo(true);
        try {
            TreePath parentPath = this.myPath.getParentPath();
            TariffStructureNode node = (TariffStructureNode)this.myPath.getLastPathComponent();
            if (node instanceof TSLink) {
                node.removeAt(0);
            }
            TariffDAGNode parent = (TariffDAGNode)parentPath.getLastPathComponent();
            this.myTree.getTreeModel().insertChildAt(parent, this.myIndex, node);
            this.myTree.getTreeModel().resolveLink(node, Arrays.asList(parent));
            try {
                DefaultLinkIdUpdater updater = new DefaultLinkIdUpdater(this.myTree.getTreeModel());
                DAGUtil.visitPreorder(this.myTree.getTop(), updater);
            }
            catch (Exception e) {
                ExceptionUtil.handleException(e, "ratingperiod", 1, "Error when updating link IDs.", false);
                boolean bl = false;
                this.myTree.setOngoingUndo(false);
                return bl;
            }
            this.notifyElementInserted(node);
            this.preInsertSelect();
            this.myTree.setSelectionPath(this.myPath);
            this.myTree.scrollPathToVisible(this.myPath);
        }
        finally {
            this.myTree.setOngoingUndo(false);
        }
        return true;
    }

    private void notifyElementInserted(TariffStructureNode node) {
        if (node instanceof TSElement) {
            ((TSElement)node).notifyReinserted();
        }
    }

    protected abstract void preInsertSelect();

    protected UndoableTree getTree() {
        return this.myTree;
    }
}

