/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.gui.util.CalendarModel;
import com.ericsson.ere.gui.util.DateFieldDocument;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class AbstractDateInputField
extends JTextField
implements ChangeListener {
    private Border normalBorder;
    private int myDateFieldType;
    protected CalendarModel myCalendarModel;
    private ChangeListener myListener;
    private DateFieldDocument myDocument;

    public AbstractDateInputField(CalendarModel calModel, int dateFieldType) {
        this.myDateFieldType = dateFieldType;
        this.myCalendarModel = calModel;
        this.setColumns(this.getNumberOfColumns());
        this.myListener = this;
        this.myDocument = new DateFieldDocument(this.myCalendarModel, this.myDateFieldType);
        this.setDocument(this.myDocument);
        this.normalBorder = this.getBorder();
        this.setFieldValue();
        this.setCaretPosition(this.getText().length());
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (AbstractDateInputField.this.isValid()) {
                    AbstractDateInputField.this.update();
                    AbstractDateInputField.this.setNormalBorder();
                } else {
                    AbstractDateInputField.this.setRedBorder();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (AbstractDateInputField.this.isValid()) {
                    AbstractDateInputField.this.update();
                    AbstractDateInputField.this.setNormalBorder();
                } else {
                    AbstractDateInputField.this.setRedBorder();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (AbstractDateInputField.this.isValid()) {
                    AbstractDateInputField.this.update();
                    AbstractDateInputField.this.setNormalBorder();
                } else {
                    AbstractDateInputField.this.setRedBorder();
                }
            }
        });
    }

    public int getDateFieldType() {
        return this.myDateFieldType;
    }

    public void update() {
        this.myCalendarModel.removeChangeListener(this.myListener);
        int value = Integer.parseInt(this.getText());
        this.myCalendarModel.set(this.myDateFieldType, value);
        this.myCalendarModel.addChangeListener(this.myListener);
    }

    protected ChangeListener getListener() {
        return this.myListener;
    }

    private void setRedBorder() {
        if (this.normalBorder == null) {
            this.normalBorder = this.getBorder();
        }
        if (this.getBorder() == null) {
            this.setBorder(BorderFactory.createLineBorder(Color.RED));
        } else {
            this.setBorder(new LineBorder(Color.RED));
        }
    }

    private void setNormalBorder() {
        this.setBorder(this.normalBorder);
    }

    private int getNumberOfColumns() {
        switch (this.myDateFieldType) {
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 2;
            }
        }
        return -1;
    }

    public void setFieldValue() {
        int value = this.myCalendarModel.get(this.getDateFieldType());
        this.setText(value + "");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof CalendarModel) {
            int value = ((CalendarModel)source).get(this.myDateFieldType);
            if (this.myDateFieldType == 2) {
                ++value;
            }
            this.setFieldValue();
        }
    }

    @Override
    public abstract boolean isValid();
}

