/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.gui.util.CalendarModel;
import com.ericsson.ere.gui.util.TimeFieldDocument;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class AbstractTimeInputField
extends JTextField
implements ChangeListener {
    private Border normalBorder;
    private int myTimeFieldType;
    protected CalendarModel myCalendarModel;
    private ChangeListener myListener;
    private TimeFieldDocument myDocument;

    public AbstractTimeInputField(CalendarModel calModel, int timeFieldType) {
        this.myTimeFieldType = timeFieldType;
        this.myCalendarModel = calModel;
        this.setColumns(this.getNumberOfColumns());
        this.myListener = this;
        this.myDocument = new TimeFieldDocument(this.myCalendarModel, this.myTimeFieldType);
        this.setDocument(this.myDocument);
        this.normalBorder = this.getBorder();
        this.setFieldValue();
        this.setCaretPosition(this.getText().length());
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (AbstractTimeInputField.this.isValid()) {
                    AbstractTimeInputField.this.update();
                    AbstractTimeInputField.this.setNormalBorder();
                } else {
                    AbstractTimeInputField.this.setRedBorder();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (AbstractTimeInputField.this.isValid()) {
                    AbstractTimeInputField.this.update();
                    AbstractTimeInputField.this.setNormalBorder();
                } else {
                    AbstractTimeInputField.this.setRedBorder();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (AbstractTimeInputField.this.isValid()) {
                    AbstractTimeInputField.this.update();
                    AbstractTimeInputField.this.setNormalBorder();
                } else {
                    AbstractTimeInputField.this.setRedBorder();
                }
            }
        });
    }

    public int getTimeFieldType() {
        return this.myTimeFieldType;
    }

    public void update() {
        this.myCalendarModel.removeChangeListener(this.myListener);
        int value = Integer.parseInt(this.getText());
        this.myCalendarModel.set(this.myTimeFieldType, value);
        this.myCalendarModel.addChangeListener(this.myListener);
    }

    protected ChangeListener getListener() {
        return this.myListener;
    }

    private void setRedBorder() {
        if (this.normalBorder == null) {
            this.normalBorder = this.getBorder();
        }
        if (this.getBorder() == null) {
            this.setBorder(BorderFactory.createLineBorder(Color.RED));
        } else {
            this.setBorder(new LineBorder(Color.RED));
        }
    }

    private void setNormalBorder() {
        this.setBorder(this.normalBorder);
    }

    private int getNumberOfColumns() {
        switch (this.myTimeFieldType) {
            case 11: {
                return 2;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 2;
            }
        }
        return -1;
    }

    public void setFieldValue() {
        int value = this.myCalendarModel.get(this.getTimeFieldType());
        switch (this.myTimeFieldType) {
            case 11: 
            case 12: 
            case 13: {
                this.setText("" + (value < 10 ? "0" : "") + value);
                break;
            }
            default: {
                this.setText(value + "");
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof CalendarModel) {
            this.setFieldValue();
        }
    }

    @Override
    public abstract boolean isValid();
}

