/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.charging.common.documents.FieldValidation;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.gui.util.CalendarModel;
import com.ericsson.ere.gui.util.DatePickerDialog;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.management.DateUtil;
import ericsson.vareditor.documents.DateAndTimeDocument;
import ericsson.vareditor.documents.DateDocument;
import ericsson.vareditor.documents.RelativeTimeDocument;
import ericsson.vareditor.documents.StringDocument;
import ericsson.vareditor.documents.TimeDocument;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.RelativeTime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class DatePanel
extends AbstractPanelVariableEditor
implements FocusListener,
DocumentListener {
    private JTextField myDateTextField;
    private JButton myDatePickerButton;
    private CalendarModel myCalendarModel;
    private PlainDocument myCurrentDocument;
    private PlainDocument myStandByDocument = new StringDocument(1000L, false);
    private Mode myMode;
    private String myBOTText = "";
    private boolean myBOTisSelected = false;
    private String myEOTText = "";
    private boolean myEOTisSelected = false;

    public DatePanel(Calendar calendar, Mode mode) {
        this(DatePanel.createCalendarModel(calendar), mode);
    }

    public DatePanel(String aString, Mode aMode) {
        this(new Time().getCalendar(), aMode);
        this.setValue(aString);
    }

    public DatePanel(CalendarModel calModel) {
        this(calModel, Mode.DATETIME_MODE);
    }

    public DatePanel(EREDate date) {
        if (EREDate.BEGINNING_OF_TIME == date) {
            this.myBOTisSelected = true;
            this.myEOTisSelected = false;
            this.myCalendarModel = new CalendarModel(Calendar.getInstance());
        } else if (EREDate.END_OF_TIME == date) {
            this.myEOTisSelected = true;
            this.myBOTisSelected = false;
            this.myCalendarModel = new CalendarModel(Calendar.getInstance());
        } else {
            this.myCalendarModel = DatePanel.createCalendarModel(date.asCalendar());
        }
        this.myMode = Mode.DATE_MODE;
        this.initPanel();
    }

    public DatePanel(ERETime time) {
        if (ERETime.BEGINNING_OF_TIME == time) {
            this.myBOTisSelected = true;
            this.myEOTisSelected = false;
            this.myCalendarModel = new CalendarModel(Calendar.getInstance());
        } else if (ERETime.END_OF_TIME == time) {
            this.myEOTisSelected = true;
            this.myBOTisSelected = false;
            this.myCalendarModel = new CalendarModel(Calendar.getInstance());
        } else {
            this.myCalendarModel = DatePanel.createCalendarModel(time.asCalendar());
        }
        this.myMode = Mode.DATETIME_MODE;
        this.initPanel();
    }

    private static final CalendarModel createCalendarModel(Calendar calendar) {
        return new CalendarModel(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public DatePanel(CalendarModel calModel, Mode mode) {
        this.myCalendarModel = calModel;
        this.myMode = mode;
        this.initPanel();
    }

    public DatePanel(RelativeTime min, RelativeTime max, CalendarModel calModel, Mode mode) {
        this.myCurrentDocument = new RelativeTimeDocument(min, max);
        this.myCalendarModel = calModel;
        this.myMode = mode;
        this.initPanel();
    }

    public static String[] createFormatString() {
        String[] formats = new String[DateUtil.DATETIME_TEXT_FORMAT.length + DateUtil.DATE_TEXT_FORMAT.length + DateUtil.TIMEOFDAY_TEXT_FORMAT.length];
        System.arraycopy(DateUtil.DATETIME_TEXT_FORMAT, 0, formats, 0, DateUtil.DATETIME_TEXT_FORMAT.length);
        System.arraycopy(DateUtil.DATE_TEXT_FORMAT, 0, formats, DateUtil.DATETIME_TEXT_FORMAT.length, DateUtil.DATE_TEXT_FORMAT.length);
        System.arraycopy(DateUtil.TIMEOFDAY_TEXT_FORMAT, 0, formats, DateUtil.DATETIME_TEXT_FORMAT.length + DateUtil.DATE_TEXT_FORMAT.length, DateUtil.TIMEOFDAY_TEXT_FORMAT.length);
        return formats;
    }

    private void initPanel() {
        this.myDateTextField = new JTextField();
        this.myDateTextField.setName("DateTimeInputTextField");
        this.myDateTextField.setHorizontalAlignment(4);
        this.myDateTextField.addFocusListener(this);
        if (this.myMode == Mode.TIME_MODE) {
            this.initTimeModePanel();
        } else if (this.myMode == Mode.RELATIVE_MODE) {
            this.initRelativeModePanel();
        } else if (this.myMode == Mode.DATE_MODE) {
            this.initDateModePanel();
        } else {
            this.initDateTimeModePanel();
        }
        this.myCurrentDocument.addDocumentListener(this);
        this.myDatePickerButton = new JButton(RmaDefs.getImageIcon("date-time16.png"));
        this.myDatePickerButton.setName("DatePickerButton");
        this.myDatePickerButton.setPreferredSize(new Dimension(24, 24));
        this.myDatePickerButton.setSize(new Dimension(24, 24));
        this.myDatePickerButton.setMaximumSize(new Dimension(24, 24));
        ActionListener listener = this.createListener();
        this.myDatePickerButton.addActionListener(listener);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.myDateTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.myDatePickerButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    private ActionListener createListener() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window owner = GuiUtil.getClosestWindowParent(DatePanel.this.myDatePickerButton);
                DatePickerDialog datePickerDialog = DatePanel.this.myCalendarModel.isDateOnlyMode() ? new DatePickerDialog(owner, DatePanel.this.myCalendarModel.getCalendar(), DatePickerDialog.DIALOG_INPUT.DATE, DatePanel.this.myBOTText, DatePanel.this.myEOTText, DatePanel.this.myBOTisSelected, DatePanel.this.myEOTisSelected) : (DatePanel.this.myCalendarModel.isTimeOnlyMode() && DatePanel.this.myMode == Mode.RELATIVE_MODE ? new DatePickerDialog(owner, DatePanel.this.myCalendarModel.getCalendar(), DatePickerDialog.DIALOG_INPUT.RELATIVE) : (DatePanel.this.myCalendarModel.isTimeOnlyMode() ? new DatePickerDialog(owner, DatePanel.this.myCalendarModel.getCalendar(), DatePickerDialog.DIALOG_INPUT.TIME) : new DatePickerDialog(owner, DatePanel.this.myCalendarModel.getCalendar(), DatePickerDialog.DIALOG_INPUT.DATE_AND_TIME, DatePanel.this.myBOTText, DatePanel.this.myEOTText, DatePanel.this.myBOTisSelected, DatePanel.this.myEOTisSelected)));
                Point locationOnScreen = DatePanel.this.calculatePickerScreenLocation(datePickerDialog);
                datePickerDialog.setLocation(locationOnScreen);
                datePickerDialog.setVisible(true);
                boolean isDateModeAndBoundryDateSelected = DatePanel.this.isBoundaryDateSelected(datePickerDialog);
                if (datePickerDialog.getDialogFinishState() == DatePickerDialog.DIALOG_FINISH.OK) {
                    String textToSet;
                    if (!isDateModeAndBoundryDateSelected) {
                        DatePanel.this.myCalendarModel.setTimeInMillis(datePickerDialog.getSelectedDateAsCalendar().getTimeInMillis());
                    }
                    DatePanel.this.myBOTisSelected = false;
                    DatePanel.this.myEOTisSelected = false;
                    if (DatePanel.this.myMode == Mode.RELATIVE_MODE) {
                        textToSet = DatePanel.this.formatCalendarToRelativeString();
                    } else if (isDateModeAndBoundryDateSelected) {
                        if (datePickerDialog.isBeginningOfTimeSelected()) {
                            textToSet = DatePanel.this.myBOTText;
                            DatePanel.this.myBOTisSelected = true;
                            DatePanel.this.myEOTisSelected = false;
                        } else {
                            textToSet = DatePanel.this.myEOTText;
                            DatePanel.this.myBOTisSelected = false;
                            DatePanel.this.myEOTisSelected = true;
                        }
                    } else {
                        textToSet = DatePanel.this.myCalendarModel.toLabel();
                    }
                    DatePanel.this.setDateFieldText(textToSet, isDateModeAndBoundryDateSelected);
                }
                DatePanel.this.myDateTextField.requestFocusInWindow();
                datePickerDialog.dispose();
            }
        };
        return listener;
    }

    private void initDateTimeModePanel() {
        this.myCurrentDocument = new DateAndTimeDocument();
        this.myDateTextField.setDocument(this.myCurrentDocument);
        if (this.myBOTisSelected) {
            this.setDateFieldText(this.myBOTText, true);
        } else if (this.myEOTisSelected) {
            this.setDateFieldText(this.myEOTText, true);
        } else {
            this.setDateFieldText(DateUtil.format(this.myCalendarModel.getCalendar().getTime(), "yyyy-MM-dd HH:mm:ss"), false);
        }
    }

    private void initDateModePanel() {
        this.myCalendarModel.dateOnly();
        this.myCurrentDocument = new DateDocument();
        this.myDateTextField.setDocument(this.myCurrentDocument);
        if (this.myBOTisSelected) {
            this.setDateFieldText(this.myBOTText, true);
        } else if (this.myEOTisSelected) {
            this.setDateFieldText(this.myEOTText, true);
        } else {
            this.setDateFieldText(DateUtil.format(this.myCalendarModel.getCalendar().getTime(), "yyyy-MM-dd"), false);
        }
    }

    private void initRelativeModePanel() {
        this.myCalendarModel.timeOnly();
        this.myDateTextField.setDocument(this.myCurrentDocument);
        this.myDateTextField.setText(this.formatCalendarToRelativeString());
    }

    private void initTimeModePanel() {
        this.myCalendarModel.timeOnly();
        this.myCurrentDocument = new TimeDocument();
        this.myDateTextField.setDocument(this.myCurrentDocument);
        this.myDateTextField.setText(DateUtil.format(this.myCalendarModel.getCalendar().getTime(), "HH:mm:ss"));
    }

    Point calculatePickerScreenLocation(Window picker) {
        Point invokerScreenLocation = this.getLocationOnScreen();
        Rectangle windowBounds = picker.getBounds();
        int dx = invokerScreenLocation.x;
        int dy = invokerScreenLocation.y + this.getHeight();
        Rectangle ss = this.getGraphicsConfiguration().getBounds();
        if (dy + windowBounds.height > ss.y + ss.height) {
            dy = ss.y + ss.height - windowBounds.height - 1;
        }
        if (dx + windowBounds.width > ss.x + ss.width) {
            dx = ss.x + ss.width - windowBounds.width;
        }
        return new Point(dx, dy);
    }

    private void setDateFieldText(String text, boolean isUnformatedText) {
        if (isUnformatedText && !(this.myCurrentDocument instanceof StringDocument)) {
            this.swapCurrentDocument();
            this.myDateTextField.setDocument(this.myCurrentDocument);
            this.myDateTextField.setEditable(false);
            this.myDateTextField.setBackground(UIManager.getColor("TextField.background"));
            this.myDateTextField.setCaret(new InvisibleCaret());
        } else if (!isUnformatedText && this.myCurrentDocument instanceof StringDocument) {
            this.swapCurrentDocument();
            this.myDateTextField.setDocument(this.myCurrentDocument);
            this.myDateTextField.setEditable(true);
            this.myDateTextField.setCaret(new DefaultCaret());
        }
        this.myDateTextField.setText(text);
        this.fireDataChanged();
        this.updateEditorBackground();
    }

    private void swapCurrentDocument() {
        PlainDocument tempDoc = this.myStandByDocument;
        this.myStandByDocument = this.myCurrentDocument;
        this.myCurrentDocument = tempDoc;
    }

    private boolean isBoundaryDateSelected(DatePickerDialog datePicker) {
        return !(this.myMode != Mode.DATE_MODE && this.myMode != Mode.DATETIME_MODE || !datePicker.isBeginningOfTimeSelected() && !datePicker.isEndOfTimeSelected());
    }

    @Override
    public Object getEditorValue() {
        Object ret;
        if (this.myMode == Mode.RELATIVE_MODE) {
            String[] split = this.formatCalendarToRelativeString().split(":");
            int hours = Integer.parseInt(split[0]);
            int minutes = Integer.parseInt(split[1]);
            int seconds = Integer.parseInt(split[2]);
            ret = new RelativeTime(hours, minutes, seconds);
        } else {
            ret = this.getEditorValueForDateOrDateTimeMode();
        }
        return ret;
    }

    private Object getEditorValueForDateOrDateTimeMode() {
        Object value = this.myBOTisSelected ? EREDate.BEGINNING_OF_TIME : (this.myEOTisSelected ? EREDate.END_OF_TIME : this.myCalendarModel.getCalendar());
        return value;
    }

    public String getEditorValueAsString() {
        return this.myDateTextField.getText();
    }

    @Override
    public boolean isEditorValueValid() {
        return ((FieldValidation)((Object)this.myCurrentDocument)).isValid(this.myDateTextField.getText());
    }

    public void setValue(EREDate value) {
        if (value == EREDate.BEGINNING_OF_TIME) {
            this.myBOTisSelected = true;
            this.myEOTisSelected = false;
            this.setDateFieldText(this.myBOTText, true);
        } else if (value == EREDate.END_OF_TIME) {
            this.myBOTisSelected = false;
            this.myEOTisSelected = true;
            this.setDateFieldText(this.myEOTText, true);
        } else {
            this.myBOTisSelected = false;
            this.myEOTisSelected = false;
            this.setValue(value.asCalendar());
        }
    }

    private void setDocumentValidationEnabled(boolean enabled) {
        ((FieldValidation)((Object)this.myCurrentDocument)).enableValidation(enabled);
        ((FieldValidation)((Object)this.myStandByDocument)).enableValidation(enabled);
    }

    public void setValue(String aText) {
        if (this.myEOTisSelected || this.myBOTisSelected) {
            throw new IllegalArgumentException("Cannot set text when BOT or EOT is selected.");
        }
        this.setDocumentValidationEnabled(false);
        this.myDateTextField.setText(aText);
        this.fireDataChanged();
        this.setDocumentValidationEnabled(true);
    }

    public void setValue(Calendar c) {
        this.myBOTisSelected = false;
        this.myEOTisSelected = false;
        CalendarModel newCalendarModel = new CalendarModel(c);
        if (this.myCalendarModel.isDateOnlyMode()) {
            newCalendarModel.dateOnly();
            this.myCalendarModel = newCalendarModel;
            this.setDateFieldText(this.myCalendarModel.toLabel(), false);
        } else if (this.myCalendarModel.isTimeOnlyMode()) {
            newCalendarModel.timeOnly();
            this.myCalendarModel = newCalendarModel;
            if (this.myMode == Mode.RELATIVE_MODE) {
                this.setDateFieldText(this.formatCalendarToRelativeString(), false);
            } else {
                this.setDateFieldText(this.myCalendarModel.toLabel(), false);
            }
        } else {
            this.myCalendarModel = newCalendarModel;
            this.setDateFieldText(this.myCalendarModel.toLabel(), false);
        }
    }

    public void setRelativeTimeValue(CalendarModel newCalendarModel) {
        this.myCalendarModel = newCalendarModel;
        this.myDateTextField.setText(this.formatCalendarToRelativeString());
    }

    private String formatCalendarToRelativeString() {
        int days = this.myCalendarModel.getCalendar().get(6);
        int hours = this.myCalendarModel.getCalendar().get(11);
        int minutes = this.myCalendarModel.getCalendar().get(12);
        int seconds = this.myCalendarModel.getCalendar().get(13);
        String hoursAsString = Integer.toString(hours += (days - 1) * 24);
        String minutesAsString = Integer.toString(minutes);
        String secondsAsString = Integer.toString(seconds);
        if (hoursAsString.length() == 1) {
            hoursAsString = "0" + hoursAsString;
        }
        if (minutesAsString.length() == 1) {
            minutesAsString = "0" + minutesAsString;
        }
        if (secondsAsString.length() == 1) {
            secondsAsString = "0" + secondsAsString;
        }
        return hoursAsString + ":" + minutesAsString + ":" + secondsAsString;
    }

    public void timeOnlyMode() {
        if (this.myCalendarModel != null) {
            this.myCalendarModel.timeOnly();
        }
    }

    public void dateOnlyMode() {
        if (this.myCalendarModel != null) {
            this.myCalendarModel.dateOnly();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.myDateTextField.setBackground(UIManager.getColor("TextField.background"));
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.updateEditorBackground();
    }

    public void updateEditorBackground() {
        this.myDateTextField.setBackground(this.isEditorValueValid() ? UIManager.getColor("TextField.background") : Color.RED);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.maybeUpdateCalendar();
        this.fireDataChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.maybeUpdateCalendar();
        this.fireDataChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.maybeUpdateCalendar();
        this.fireDataChanged();
    }

    private void maybeUpdateCalendar() {
        Long timeInMillis = null;
        if (((FieldValidation)((Object)this.myCurrentDocument)).isValid(this.myDateTextField.getText())) {
            try {
                timeInMillis = DateUtil.dateToCalendar(DateUtil.stringToDate(this.myDateTextField.getText(), DatePanel.createFormatString())).getTimeInMillis();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (timeInMillis != null) {
            this.myCalendarModel.setTimeInMillis(timeInMillis);
        }
    }

    public void setAllowEdit(boolean allowEdit) {
        this.myDateTextField.setEnabled(allowEdit);
        this.myDatePickerButton.setEnabled(allowEdit);
    }

    public void setBeginningOfTimeText(String text) {
        this.myBOTText = text;
        if (this.myBOTisSelected) {
            this.setDateFieldText(text, true);
        }
    }

    public void setEndOfTimeText(String text) {
        this.myEOTText = text;
        if (this.myEOTisSelected) {
            this.setDateFieldText(text, true);
        }
    }

    @Override
    public void setKeyListenerOnComponents(KeyListener k) {
        this.myDatePickerButton.addKeyListener(k);
        this.myDateTextField.addKeyListener(k);
    }

    private static class InvisibleCaret
    implements Caret {
        private InvisibleCaret() {
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void deinstall(JTextComponent c) {
        }

        @Override
        public int getBlinkRate() {
            return 0;
        }

        @Override
        public int getDot() {
            return 0;
        }

        @Override
        public Point getMagicCaretPosition() {
            return null;
        }

        @Override
        public int getMark() {
            return 0;
        }

        @Override
        public void install(JTextComponent c) {
        }

        @Override
        public boolean isSelectionVisible() {
            return false;
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public void moveDot(int dot) {
        }

        @Override
        public void paint(Graphics g) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }

        @Override
        public void setBlinkRate(int rate) {
        }

        @Override
        public void setDot(int dot) {
        }

        @Override
        public void setMagicCaretPosition(Point p) {
        }

        @Override
        public void setSelectionVisible(boolean v) {
        }

        @Override
        public void setVisible(boolean v) {
        }
    }

    public static enum Mode {
        DATE_MODE,
        TIME_MODE,
        DATETIME_MODE,
        RELATIVE_MODE;

    }
}

