/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.charging.common.documents.NumberRangeDocument;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.util.datepicker.models.DatePickerModel;
import com.ericsson.ere.gui.util.datepicker.models.DatePickerTableModel;
import com.ericsson.ere.gui.util.datepicker.models.MonthComboBoxModel;
import com.ericsson.ere.gui.util.datepicker.renderers.DatePickerCellRendere;
import ericsson.ere.management.DateUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultFormatter;

public class DatePickerDialog
extends JDialog {
    private static final int MAX_YEAR = 9999;
    private static final int MIN_YEAR = 1;
    private DIALOG_FINISH dialogFinishState = DIALOG_FINISH.CANCEL;
    private DIALOG_INPUT dialogInputMode = DIALOG_INPUT.DATE;
    private JPanel dateSelectionPanel = null;
    private JLabel monthLabel = null;
    private JComboBox monthComboBox = null;
    private JLabel yearLabel = null;
    private JSpinner yearSpinner = null;
    private JButton todayButton = null;
    private JPanel okCancelButtonPanel = null;
    private JButton okButton = null;
    private JPanel datePanel = null;
    private JButton cancelButton = null;
    private JPanel timeInputPanel = null;
    private JLabel timeFormatLabel = null;
    private JTextField hourTextField = null;
    private JTextField minuteTextField = null;
    private JTextField secondTextField = null;
    private JTable calendarTable = null;
    private JPanel todayButtonPanel = null;
    private JPanel contentPanel = null;
    private DatePickerModel datePickerModel = null;
    private JScrollPane calendarScrollPane = null;
    private static final int MAX_RELATIVE_HOURS = 8759;
    private String myEOTText = "";
    private String myBOTText = "";
    private JCheckBox myBOTBox = null;
    private JCheckBox myEOTBox = null;
    private JPanel myDateConstantPanel = null;

    public DatePickerDialog(Window owner, Calendar parCalendar, DIALOG_INPUT inputMode) {
        super(owner, DatePickerDialog.getDialogTitle(inputMode), Dialog.ModalityType.APPLICATION_MODAL);
        this.createDatePickerDialog(parCalendar, inputMode);
        this.pack();
    }

    public DatePickerDialog(Window owner, Calendar parCalendar, DIALOG_INPUT inputMode, String botText, String eotText, boolean botSelected, boolean eotSelected) {
        super(owner, DatePickerDialog.getDialogTitle(inputMode), Dialog.ModalityType.APPLICATION_MODAL);
        boolean eotIsSelectedAndValid;
        this.myBOTText = botText;
        this.myEOTText = eotText;
        this.createDatePickerDialog(parCalendar, inputMode);
        boolean botIsSelectedAndValid = botSelected && !this.myBOTText.isEmpty();
        boolean bl = eotIsSelectedAndValid = eotSelected && !this.myEOTText.isEmpty();
        if (botIsSelectedAndValid || eotIsSelectedAndValid) {
            this.setSelectionOfBOTIfExists(botSelected);
            this.setSelectionOfEOTIfExists(eotSelected);
            this.setDatePanelEnablingStatus(false);
        } else {
            this.setDatePanelEnablingStatus(true);
        }
        this.pack();
    }

    private final void createDatePickerDialog(Calendar parCalendar, DIALOG_INPUT inputMode) {
        this.setName("DatePickerDialog");
        this.dialogInputMode = inputMode;
        this.datePickerModel = new DatePickerModel((Calendar)parCalendar.clone());
        this.initialize();
    }

    private static String getDialogTitle(DIALOG_INPUT inputMode) {
        if (inputMode == DIALOG_INPUT.RELATIVE || inputMode == DIALOG_INPUT.TIME) {
            return "Select Time";
        }
        return "Select Date";
    }

    private JScrollPane getCalendarScrollPane() {
        if (this.calendarScrollPane == null) {
            this.calendarScrollPane = new JScrollPane();
            this.calendarScrollPane.setPreferredSize(new Dimension(200, 115));
            this.calendarScrollPane.setMinimumSize(new Dimension(200, 115));
            this.calendarScrollPane.setViewportView(this.getCalendarTable());
        }
        return this.calendarScrollPane;
    }

    public Calendar getSelectedDateAsCalendar() {
        return (Calendar)this.datePickerModel.getCalendar().clone();
    }

    public String getSelectedDateAsISOString() {
        return DateUtil.format(this.getSelectedDateAsCalendar());
    }

    public DIALOG_FINISH getDialogFinishState() {
        return this.dialogFinishState;
    }

    private void initialize() {
        if (this.datePickerModel == null) {
            this.datePickerModel = new DatePickerModel(Calendar.getInstance());
        }
        this.setContentPane(this.getContentPanel());
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            JPanel dateConstantPanel;
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new GridBagLayout());
            int gridy = 0;
            GridBagConstraints calendarGBConstraints = new GridBagConstraints();
            calendarGBConstraints.gridx = 0;
            calendarGBConstraints.fill = 1;
            calendarGBConstraints.anchor = 18;
            calendarGBConstraints.weightx = 1.0;
            calendarGBConstraints.weighty = 1.0;
            calendarGBConstraints.insets = new Insets(12, 12, 0, 12);
            calendarGBConstraints.gridy = gridy++;
            this.contentPanel.add((Component)this.getDatePanel(), calendarGBConstraints);
            if ((this.dialogInputMode == DIALOG_INPUT.DATE || this.dialogInputMode == DIALOG_INPUT.DATE_AND_TIME) && (dateConstantPanel = this.getDateConstantPanel()) != null) {
                GridBagConstraints dateConstantsGBConstraints = new GridBagConstraints();
                dateConstantsGBConstraints.gridx = 0;
                dateConstantsGBConstraints.anchor = 18;
                dateConstantsGBConstraints.fill = 2;
                dateConstantsGBConstraints.insets = new Insets(12, 0, 12, 0);
                dateConstantsGBConstraints.weighty = 1.0;
                dateConstantsGBConstraints.weightx = 1.0;
                dateConstantsGBConstraints.gridy = gridy++;
                this.contentPanel.add((Component)this.getDateConstantPanel(), dateConstantsGBConstraints);
            }
            GridBagConstraints okCancelButtonsGBConstraints = new GridBagConstraints();
            okCancelButtonsGBConstraints.anchor = 18;
            okCancelButtonsGBConstraints.gridx = 0;
            okCancelButtonsGBConstraints.gridy = gridy;
            okCancelButtonsGBConstraints.weightx = 1.0;
            okCancelButtonsGBConstraints.insets = new Insets(12, 12, 12, 12);
            okCancelButtonsGBConstraints.fill = 2;
            this.contentPanel.add((Component)this.getOkCancelButtonPanel(), okCancelButtonsGBConstraints);
        }
        return this.contentPanel;
    }

    private JPanel getDateSelectionPanel() {
        if (this.dateSelectionPanel == null) {
            GridBagConstraints monthLabelGBConstraints = new GridBagConstraints();
            monthLabelGBConstraints.gridx = 2;
            monthLabelGBConstraints.anchor = 17;
            monthLabelGBConstraints.fill = 0;
            monthLabelGBConstraints.insets = new Insets(0, 12, 0, 0);
            monthLabelGBConstraints.gridy = 0;
            GridBagConstraints yearSpinnerGBConstraints = new GridBagConstraints();
            yearSpinnerGBConstraints.gridx = 1;
            yearSpinnerGBConstraints.insets = new Insets(0, 6, 0, 0);
            yearSpinnerGBConstraints.weightx = 1.0;
            yearSpinnerGBConstraints.fill = 2;
            yearSpinnerGBConstraints.anchor = 17;
            yearSpinnerGBConstraints.gridy = 0;
            GridBagConstraints yearLabelGBConstraints = new GridBagConstraints();
            yearLabelGBConstraints.gridx = 0;
            yearLabelGBConstraints.insets = new Insets(0, 12, 0, 0);
            yearLabelGBConstraints.anchor = 17;
            yearLabelGBConstraints.gridy = 0;
            GridBagConstraints monthComboGBConstraints = new GridBagConstraints();
            monthComboGBConstraints.fill = 2;
            monthComboGBConstraints.gridy = 0;
            monthComboGBConstraints.weightx = 1.0;
            monthComboGBConstraints.anchor = 17;
            monthComboGBConstraints.insets = new Insets(0, 6, 0, 12);
            monthComboGBConstraints.gridx = 3;
            this.yearLabel = new JLabel();
            this.yearLabel.setText("Year:");
            this.monthLabel = new JLabel();
            this.monthLabel.setText("Month:");
            this.monthLabel.setHorizontalAlignment(11);
            this.monthLabel.setPreferredSize(new Dimension(49, 16));
            this.dateSelectionPanel = new JPanel();
            this.dateSelectionPanel.setLayout(new GridBagLayout());
            this.dateSelectionPanel.add((Component)this.monthLabel, monthLabelGBConstraints);
            this.dateSelectionPanel.add((Component)this.getMonthComboBox(), monthComboGBConstraints);
            this.dateSelectionPanel.add((Component)this.yearLabel, yearLabelGBConstraints);
            this.dateSelectionPanel.add((Component)this.getYearSpinner(), yearSpinnerGBConstraints);
        }
        return this.dateSelectionPanel;
    }

    private JComboBox getMonthComboBox() {
        if (this.monthComboBox == null) {
            this.monthComboBox = new JComboBox();
            this.monthComboBox.setName("DatePickerDialog.JComboBox.MonthComboBox");
            this.monthComboBox.setModel(new MonthComboBoxModel(this.getLocale()));
            this.monthComboBox.setSelectedIndex(this.datePickerModel.getSelectedMonth());
            this.monthComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int theDayOfMonth = DatePickerDialog.this.datePickerModel.getSelectedDay();
                    DatePickerDialog.this.datePickerModel.setSelectedMonth(DatePickerDialog.this.monthComboBox.getSelectedIndex());
                    int theMinDayOfMonth = DatePickerDialog.this.datePickerModel.getCalendar().getActualMinimum(5);
                    int theMaxDayOfMonth = DatePickerDialog.this.datePickerModel.getCalendar().getActualMaximum(5);
                    if (theDayOfMonth < theMinDayOfMonth) {
                        DatePickerDialog.this.datePickerModel.setSelectedDay(theMinDayOfMonth);
                    } else if (theDayOfMonth > theMaxDayOfMonth) {
                        DatePickerDialog.this.datePickerModel.setSelectedDay(theMaxDayOfMonth);
                    } else {
                        DatePickerDialog.this.datePickerModel.setSelectedDay(theDayOfMonth);
                    }
                }
            });
            this.datePickerModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("MONTH") || e.getActionCommand().equals("ALL")) {
                        DatePickerDialog.this.monthComboBox.setSelectedIndex(DatePickerDialog.this.datePickerModel.getSelectedMonth());
                    }
                }
            });
        }
        return this.monthComboBox;
    }

    private JSpinner getYearSpinner() {
        if (this.yearSpinner == null) {
            this.yearSpinner = new JSpinner();
            this.yearSpinner.setName("DatePickerDialog.JSpinner.YearSpinner");
            if (this.datePickerModel.getSelectedYear() < 1) {
                this.datePickerModel.setSelectedYear(1);
            } else if (9999 < this.datePickerModel.getSelectedYear()) {
                this.datePickerModel.setSelectedYear(9999);
            }
            this.yearSpinner.setModel(new SpinnerNumberModel(this.datePickerModel.getSelectedYear(), 1, 9999, 1));
            JSpinner.NumberEditor aNumEditor = new JSpinner.NumberEditor(this.yearSpinner, "####");
            ((DefaultFormatter)aNumEditor.getTextField().getFormatter()).setAllowsInvalid(false);
            ((DefaultFormatter)aNumEditor.getTextField().getFormatter()).setCommitsOnValidEdit(true);
            this.yearSpinner.setEditor(aNumEditor);
            this.yearSpinner.setPreferredSize(new Dimension(50, 25));
            this.yearSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    DatePickerDialog.this.datePickerModel.setSelectedYear(((Number)DatePickerDialog.this.yearSpinner.getValue()).intValue());
                }
            });
            this.datePickerModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("YEAR") || e.getActionCommand().equals("ALL")) {
                        DatePickerDialog.this.yearSpinner.getModel().setValue(DatePickerDialog.this.datePickerModel.getSelectedYear());
                    }
                }
            });
        }
        return this.yearSpinner;
    }

    private JButton getTodayButton() {
        if (this.todayButton == null) {
            this.todayButton = new JButton();
            this.todayButton.setName("DatePickerDialog.JButton.todayButton");
            if (this.dialogInputMode == DIALOG_INPUT.DATE) {
                this.todayButton.setText("Today");
            } else if (this.dialogInputMode == DIALOG_INPUT.DATE_AND_TIME || this.dialogInputMode == DIALOG_INPUT.TIME || this.dialogInputMode == DIALOG_INPUT.RELATIVE) {
                this.todayButton.setText("Now");
            }
            this.todayButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (DatePickerDialog.this.dialogInputMode == DIALOG_INPUT.RELATIVE) {
                        Calendar calendar = Calendar.getInstance();
                        DatePickerDialog.this.datePickerModel.getCalendar().set(1, 2000);
                        DatePickerDialog.this.datePickerModel.getCalendar().set(6, 1);
                        DatePickerDialog.this.datePickerModel.setSelectedHour(calendar.get(11));
                        DatePickerDialog.this.datePickerModel.setSelectedMinute(calendar.get(12));
                        DatePickerDialog.this.datePickerModel.setSelectedSecond(calendar.get(13));
                    } else {
                        DatePickerDialog.this.datePickerModel.setDate(Calendar.getInstance());
                    }
                }
            });
        }
        return this.todayButton;
    }

    private JPanel getOkCancelButtonPanel() {
        if (this.okCancelButtonPanel == null) {
            GridBagConstraints okGBConstraints = new GridBagConstraints();
            okGBConstraints.gridx = 0;
            okGBConstraints.anchor = 12;
            okGBConstraints.fill = 0;
            okGBConstraints.weightx = 1.0;
            okGBConstraints.insets = new Insets(0, 0, 0, 0);
            okGBConstraints.gridy = 0;
            GridBagConstraints cancelGBConstraints = new GridBagConstraints();
            cancelGBConstraints.gridx = 1;
            cancelGBConstraints.anchor = 12;
            cancelGBConstraints.insets = new Insets(0, 12, 0, 0);
            cancelGBConstraints.gridy = 0;
            this.okCancelButtonPanel = new JPanel();
            this.okCancelButtonPanel.setLayout(new GridBagLayout());
            this.okCancelButtonPanel.add((Component)this.getOkButton(), okGBConstraints);
            this.okCancelButtonPanel.add((Component)this.getCancelButton(), cancelGBConstraints);
        }
        return this.okCancelButtonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.setName("DatePickerDialog.JButton.okButton");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatePickerDialog.this.dialogFinishState = DIALOG_FINISH.OK;
                    DatePickerDialog.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JPanel getDatePanel() {
        if (this.datePanel == null) {
            this.datePanel = new JPanel();
            this.datePanel.setLayout(new GridBagLayout());
            this.datePanel.setBorder(BorderFactory.createTitledBorder(null, "Date", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            if (this.dialogInputMode == DIALOG_INPUT.DATE || this.dialogInputMode == DIALOG_INPUT.DATE_AND_TIME) {
                GridBagConstraints dateSelectionGBConstraints = new GridBagConstraints();
                dateSelectionGBConstraints.anchor = 18;
                dateSelectionGBConstraints.gridheight = 1;
                dateSelectionGBConstraints.gridwidth = 1;
                dateSelectionGBConstraints.gridx = 0;
                dateSelectionGBConstraints.gridy = 0;
                dateSelectionGBConstraints.weightx = 1.0;
                dateSelectionGBConstraints.insets = new Insets(12, 0, 0, 0);
                dateSelectionGBConstraints.fill = 2;
                GridBagConstraints calendarGBConstraints = new GridBagConstraints();
                calendarGBConstraints.fill = 1;
                calendarGBConstraints.gridy = 1;
                calendarGBConstraints.weightx = 1.0;
                calendarGBConstraints.weighty = 0.0;
                calendarGBConstraints.insets = new Insets(12, 12, 0, 12);
                calendarGBConstraints.anchor = 18;
                calendarGBConstraints.gridx = 0;
                this.datePanel.add((Component)this.getDateSelectionPanel(), dateSelectionGBConstraints);
                this.datePanel.add((Component)this.getCalendarScrollPane(), calendarGBConstraints);
            }
            if (this.dialogInputMode == DIALOG_INPUT.TIME || this.dialogInputMode == DIALOG_INPUT.DATE_AND_TIME || this.dialogInputMode == DIALOG_INPUT.RELATIVE) {
                GridBagConstraints timeGBConstraints = new GridBagConstraints();
                timeGBConstraints.anchor = 18;
                timeGBConstraints.insets = new Insets(12, 0, 0, 0);
                timeGBConstraints.gridx = 0;
                timeGBConstraints.gridy = 3;
                timeGBConstraints.weightx = 1.0;
                timeGBConstraints.weighty = 0.0;
                timeGBConstraints.fill = 2;
                this.datePanel.add((Component)this.getTimeInputPanel(), timeGBConstraints);
            }
            GridBagConstraints todayButtonGBConstraints = new GridBagConstraints();
            todayButtonGBConstraints.gridx = 0;
            todayButtonGBConstraints.anchor = 18;
            todayButtonGBConstraints.fill = 2;
            todayButtonGBConstraints.insets = new Insets(12, 0, 12, 0);
            todayButtonGBConstraints.weighty = 1.0;
            todayButtonGBConstraints.weightx = 1.0;
            todayButtonGBConstraints.gridy = 4;
            this.datePanel.add((Component)this.getTodayButtonPanel(), todayButtonGBConstraints);
        }
        return this.datePanel;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setName("DatePickerDialog.JButton.cancelButton");
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatePickerDialog.this.dialogFinishState = DIALOG_FINISH.CANCEL;
                    DatePickerDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    private JPanel getTimeInputPanel() {
        if (this.timeInputPanel == null) {
            GridBagConstraints timeFormatGBConstraints = new GridBagConstraints();
            timeFormatGBConstraints.gridx = 0;
            timeFormatGBConstraints.weightx = 1.0;
            timeFormatGBConstraints.fill = 2;
            timeFormatGBConstraints.anchor = 13;
            timeFormatGBConstraints.insets = new Insets(0, 12, 0, 0);
            timeFormatGBConstraints.gridy = 0;
            GridBagConstraints firstSeparatorBGConstraints = new GridBagConstraints();
            firstSeparatorBGConstraints.gridx = 4;
            firstSeparatorBGConstraints.gridy = 0;
            GridBagConstraints secondSeparatorGBConstraints = new GridBagConstraints();
            secondSeparatorGBConstraints.gridx = 2;
            secondSeparatorGBConstraints.gridy = 0;
            JLabel firstSeparator = new JLabel();
            firstSeparator.setText(":");
            JLabel secondSeparator = new JLabel();
            secondSeparator.setText(":");
            GridBagConstraints secondsGBConstraints = new GridBagConstraints();
            secondsGBConstraints.fill = 2;
            secondsGBConstraints.gridy = 0;
            secondsGBConstraints.weightx = 1.0;
            secondsGBConstraints.insets = new Insets(0, 6, 0, 11);
            secondsGBConstraints.gridx = 5;
            GridBagConstraints minuteGBConstraints = new GridBagConstraints();
            minuteGBConstraints.fill = 2;
            minuteGBConstraints.gridy = 0;
            minuteGBConstraints.weightx = 1.0;
            minuteGBConstraints.insets = new Insets(0, 6, 0, 6);
            minuteGBConstraints.gridx = 3;
            GridBagConstraints hourGBConstraints = new GridBagConstraints();
            hourGBConstraints.fill = 2;
            hourGBConstraints.gridy = 0;
            hourGBConstraints.weightx = 1.0;
            hourGBConstraints.insets = new Insets(0, 6, 0, 6);
            hourGBConstraints.gridx = 1;
            this.timeFormatLabel = new JLabel();
            if (this.dialogInputMode == DIALOG_INPUT.RELATIVE) {
                this.timeFormatLabel.setText("Time (hhhh:mm:ss):");
            } else {
                this.timeFormatLabel.setText("Time (hh:mm:ss):");
            }
            this.timeFormatLabel.setHorizontalAlignment(11);
            this.timeFormatLabel.setHorizontalTextPosition(11);
            this.timeInputPanel = new JPanel();
            this.timeInputPanel.setLayout(new GridBagLayout());
            this.timeInputPanel.add((Component)this.timeFormatLabel, timeFormatGBConstraints);
            this.timeInputPanel.add((Component)this.getHourTextField(), hourGBConstraints);
            this.timeInputPanel.add((Component)this.getMinuteTextField(), minuteGBConstraints);
            this.timeInputPanel.add((Component)this.getSecondTextField(), secondsGBConstraints);
            this.timeInputPanel.add((Component)secondSeparator, secondSeparatorGBConstraints);
            this.timeInputPanel.add((Component)firstSeparator, firstSeparatorBGConstraints);
        }
        return this.timeInputPanel;
    }

    private JTextField getHourTextField() {
        if (this.hourTextField == null) {
            this.hourTextField = new JTextField("0");
            if (this.dialogInputMode == DIALOG_INPUT.RELATIVE) {
                this.hourTextField.setDocument(new NumberRangeDocument(0L, 8759L));
                this.hourTextField.setColumns(3);
                int hourToShow = (this.datePickerModel.getCalendar().get(6) - 1) * 24 + this.datePickerModel.getSelectedHour();
                this.hourTextField.setText("" + hourToShow);
            } else {
                this.hourTextField.setDocument(new NumberRangeDocument(0L, 23L));
                this.hourTextField.setColumns(2);
                this.hourTextField.setText("" + this.datePickerModel.getSelectedHour());
            }
            this.hourTextField.setHorizontalAlignment(4);
            this.hourTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!DatePickerDialog.this.hourTextField.getText().trim().isEmpty()) {
                        try {
                            int hours = Integer.parseInt(DatePickerDialog.this.hourTextField.getText().trim());
                            if (DatePickerDialog.this.dialogInputMode == DIALOG_INPUT.RELATIVE) {
                                if (hours < 24) {
                                    DatePickerDialog.this.datePickerModel.getCalendar().set(6, 1);
                                } else {
                                    int days = hours / 24 + 1;
                                    hours %= 24;
                                    DatePickerDialog.this.datePickerModel.getCalendar().set(6, days);
                                }
                            }
                            DatePickerDialog.this.datePickerModel.setSelectedHour(hours);
                        }
                        catch (NumberFormatException ex) {
                            ExceptionUtil.handleException(ex, "ratingRuleFrame");
                        }
                    } else {
                        DatePickerDialog.this.hourTextField.setText("" + DatePickerDialog.this.datePickerModel.getSelectedHour());
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                    DatePickerDialog.this.hourTextField.selectAll();
                }
            });
            this.datePickerModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("HOUR") || e.getActionCommand().equals("ALL")) {
                        String hourTextToSet;
                        if (DatePickerDialog.this.dialogInputMode == DIALOG_INPUT.RELATIVE) {
                            int hourToShow = (DatePickerDialog.this.datePickerModel.getCalendar().get(6) - 1) * 24 + DatePickerDialog.this.datePickerModel.getSelectedHour();
                            hourTextToSet = "" + hourToShow;
                        } else {
                            hourTextToSet = "" + DatePickerDialog.this.datePickerModel.getSelectedHour();
                        }
                        DatePickerDialog.this.hourTextField.setText(hourTextToSet);
                    }
                }
            });
        }
        return this.hourTextField;
    }

    private JTextField getMinuteTextField() {
        if (this.minuteTextField == null) {
            this.minuteTextField = new JTextField("0");
            this.minuteTextField.setDocument(new NumberRangeDocument(0L, 59L));
            this.minuteTextField.setHorizontalAlignment(4);
            this.minuteTextField.setColumns(2);
            this.minuteTextField.setText("" + this.datePickerModel.getSelectedMinute());
            this.minuteTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!DatePickerDialog.this.minuteTextField.getText().trim().isEmpty()) {
                        try {
                            int minute = Integer.parseInt(DatePickerDialog.this.minuteTextField.getText().trim());
                            DatePickerDialog.this.datePickerModel.setSelectedMinute(minute);
                        }
                        catch (NumberFormatException ex) {
                            ExceptionUtil.handleException(ex, "ratingRuleFrame");
                        }
                    } else {
                        DatePickerDialog.this.minuteTextField.setText("" + DatePickerDialog.this.datePickerModel.getSelectedMinute());
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                    DatePickerDialog.this.minuteTextField.selectAll();
                }
            });
            this.datePickerModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("MINUTE") || e.getActionCommand().equals("ALL")) {
                        DatePickerDialog.this.minuteTextField.setText("" + DatePickerDialog.this.datePickerModel.getSelectedMinute());
                    }
                }
            });
        }
        return this.minuteTextField;
    }

    private JTextField getSecondTextField() {
        if (this.secondTextField == null) {
            this.secondTextField = new JTextField("0");
            this.secondTextField.setDocument(new NumberRangeDocument(0L, 59L));
            this.secondTextField.setHorizontalAlignment(4);
            this.secondTextField.setColumns(2);
            this.secondTextField.setText("" + this.datePickerModel.getSelectedSecond());
            this.secondTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!DatePickerDialog.this.secondTextField.getText().trim().isEmpty()) {
                        try {
                            int second = Integer.parseInt(DatePickerDialog.this.secondTextField.getText().trim());
                            DatePickerDialog.this.datePickerModel.setSelectedSecond(second);
                        }
                        catch (NumberFormatException ex) {
                            ExceptionUtil.handleException(ex, "ratingRuleFrame");
                        }
                    } else {
                        DatePickerDialog.this.secondTextField.setText("" + DatePickerDialog.this.datePickerModel.getSelectedSecond());
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                    DatePickerDialog.this.secondTextField.selectAll();
                }
            });
            this.datePickerModel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("SECOND") || e.getActionCommand().equals("ALL")) {
                        DatePickerDialog.this.secondTextField.setText("" + DatePickerDialog.this.datePickerModel.getSelectedSecond());
                    }
                }
            });
        }
        return this.secondTextField;
    }

    private JTable getCalendarTable() {
        if (this.calendarTable == null) {
            this.calendarTable = new JTable(){

                @Override
                public TableCellRenderer getCellRenderer(int row, int column) {
                    return new UseEnablingAtTableCellRenderingWrapper(super.getCellRenderer(row, column));
                }
            };
            final DatePickerTableModel datePickerTableModel = new DatePickerTableModel(this.datePickerModel, this.getLocale());
            final FocusListener tableFocusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    DatePickerDialog.this.calendarTable.changeSelection(datePickerTableModel.getRowForSelectedDay(), datePickerTableModel.getColumnForSelectedDay(), true, false);
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            };
            this.calendarTable.setName("DatePickerDialog.JTable.CalendarTable");
            this.calendarTable.setModel(datePickerTableModel);
            this.calendarTable.setCellSelectionEnabled(false);
            this.calendarTable.setDefaultRenderer(Integer.class, new DatePickerCellRendere(this.datePickerModel.getCalendar(), this.datePickerModel));
            this.calendarTable.setSelectionMode(0);
            this.calendarTable.getTableHeader().setReorderingAllowed(false);
            this.calendarTable.getTableHeader().setResizingAllowed(false);
            this.calendarTable.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    Integer newDate;
                    if (e.getKeyChar() == '\t') {
                        if (e.getModifiersEx() == 64) {
                            DatePickerDialog.this.monthComboBox.requestFocus();
                        } else if (DatePickerDialog.this.dialogInputMode == DIALOG_INPUT.DATE) {
                            DatePickerDialog.this.todayButton.requestFocus();
                        } else {
                            DatePickerDialog.this.hourTextField.requestFocus();
                        }
                    } else if (e.getKeyChar() == ' ' && (newDate = (Integer)datePickerTableModel.getValueAt(DatePickerDialog.this.calendarTable.getSelectedRow(), DatePickerDialog.this.calendarTable.getSelectedColumn())) != null) {
                        DatePickerDialog.this.datePickerModel.setSelectedDay(newDate);
                        DatePickerDialog.this.calendarTable.changeSelection(datePickerTableModel.getRowForSelectedDay(), datePickerTableModel.getColumnForSelectedDay(), true, false);
                    }
                }
            });
            this.calendarTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    DatePickerDialog.this.calendarTable.removeFocusListener(tableFocusListener);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Object tObj = datePickerTableModel.getValueAt(DatePickerDialog.this.calendarTable.getSelectedRow(), DatePickerDialog.this.calendarTable.getSelectedColumn());
                    try {
                        DatePickerDialog.this.datePickerModel.setSelectedDay((Integer)tObj);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    DatePickerDialog.this.calendarTable.changeSelection(datePickerTableModel.getRowForSelectedDay(), datePickerTableModel.getColumnForSelectedDay(), true, false);
                    DatePickerDialog.this.calendarTable.addFocusListener(tableFocusListener);
                }
            });
            this.calendarTable.addFocusListener(tableFocusListener);
        }
        return this.calendarTable;
    }

    private JPanel getDateConstantPanel() {
        if (this.myDateConstantPanel == null) {
            GridBagConstraints firstGBConstraints = new GridBagConstraints();
            firstGBConstraints.insets = new Insets(0, 12, 0, 0);
            firstGBConstraints.gridy = 0;
            firstGBConstraints.anchor = 21;
            firstGBConstraints.weightx = 1.0;
            firstGBConstraints.gridx = 0;
            GridBagConstraints secondGBConstraints = new GridBagConstraints();
            secondGBConstraints.insets = new Insets(0, 12, 0, 12);
            secondGBConstraints.gridy = 1;
            secondGBConstraints.anchor = 21;
            secondGBConstraints.gridx = 0;
            if (!this.myBOTText.isEmpty()) {
                this.myDateConstantPanel = new JPanel();
                this.myDateConstantPanel.setLayout(new GridBagLayout());
                this.myDateConstantPanel.add((Component)this.getBOTBox(), firstGBConstraints);
                if (!this.myEOTText.isEmpty()) {
                    this.myDateConstantPanel.add((Component)this.getEOTBox(), secondGBConstraints);
                }
            } else if (!this.myEOTText.isEmpty()) {
                this.myDateConstantPanel = new JPanel();
                this.myDateConstantPanel.setLayout(new GridBagLayout());
                this.myDateConstantPanel.add((Component)this.getEOTBox(), firstGBConstraints);
            }
        }
        return this.myDateConstantPanel;
    }

    private JCheckBox getBOTBox() {
        if (this.myBOTBox == null) {
            this.myBOTBox = new JCheckBox(this.myBOTText);
            this.myBOTBox.setName("DatePickerDialog.JCheckBox.BOTBox");
            this.myBOTBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractButton abstractButton = (AbstractButton)e.getSource();
                    boolean isChecked = abstractButton.getModel().isSelected();
                    DatePickerDialog.this.handleSelectionComponentEnabling(isChecked, false);
                }
            });
        }
        return this.myBOTBox;
    }

    private JCheckBox getEOTBox() {
        if (this.myEOTBox == null) {
            this.myEOTBox = new JCheckBox(this.myEOTText);
            this.myEOTBox.setName("DatePickerDialog.JCheckBox.EOTBox");
            this.myEOTBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractButton abstractButton = (AbstractButton)e.getSource();
                    boolean isChecked = abstractButton.getModel().isSelected();
                    DatePickerDialog.this.handleSelectionComponentEnabling(false, isChecked);
                }
            });
        }
        return this.myEOTBox;
    }

    private void handleSelectionComponentEnabling(boolean botWasChecked, boolean eotWasChecked) {
        if (botWasChecked) {
            this.setSelectionOfEOTIfExists(false);
            this.setDatePanelEnablingStatus(false);
        } else if (eotWasChecked) {
            this.setSelectionOfBOTIfExists(false);
            this.setDatePanelEnablingStatus(false);
        } else {
            this.setDatePanelEnablingStatus(true);
        }
    }

    public boolean isBeginningOfTimeSelected() {
        return this.getBOTBox().isSelected();
    }

    public boolean isEndOfTimeSelected() {
        return this.getEOTBox().isSelected();
    }

    private void setDatePanelEnablingStatus(boolean enabled) {
        this.monthLabel.setEnabled(enabled);
        this.getMonthComboBox().setEnabled(enabled);
        this.yearLabel.setEnabled(enabled);
        this.getYearSpinner().setEnabled(enabled);
        this.getCalendarTable().setEnabled(enabled);
        this.getTodayButton().setEnabled(enabled);
    }

    private void setSelectionOfEOTIfExists(boolean selected) {
        if (!this.myEOTText.isEmpty()) {
            this.getEOTBox().setSelected(selected);
        }
    }

    private void setSelectionOfBOTIfExists(boolean selected) {
        if (!this.myBOTText.isEmpty()) {
            this.getBOTBox().setSelected(selected);
        }
    }

    private JPanel getTodayButtonPanel() {
        if (this.todayButtonPanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(0, 12, 0, 12);
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridx = 1;
            this.todayButtonPanel = new JPanel();
            this.todayButtonPanel.setLayout(new GridBagLayout());
            this.todayButtonPanel.add((Component)this.getTodayButton(), gridBagConstraints4);
        }
        return this.todayButtonPanel;
    }

    private static class UseEnablingAtTableCellRenderingWrapper
    implements TableCellRenderer {
        private TableCellRenderer myRenderer;

        public UseEnablingAtTableCellRenderingWrapper(TableCellRenderer renderer) {
            this.myRenderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.myRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component.isEnabled() != table.isEnabled()) {
                component.setEnabled(table.isEnabled());
            }
            return component;
        }
    }

    public static enum DIALOG_INPUT {
        DATE,
        DATE_AND_TIME,
        TIME,
        RELATIVE;

    }

    public static enum DIALOG_FINISH {
        OK,
        CANCEL;

    }
}

