/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.gui.util.AbstractDateInputField;
import com.ericsson.ere.gui.util.CalendarModel;

public class MonthInputField
extends AbstractDateInputField {
    public MonthInputField(CalendarModel calModel) {
        super(calModel, 2);
    }

    @Override
    public void setFieldValue() {
        int value = this.myCalendarModel.get(this.getDateFieldType());
        if (this.getDateFieldType() == 2) {
            ++value;
        }
        this.setText(value + "");
    }

    @Override
    public void update() {
        this.myCalendarModel.removeChangeListener(this.getListener());
        int value = Integer.parseInt(this.getText());
        if (this.getDateFieldType() == 2) {
            --value;
        }
        this.myCalendarModel.set(this.getDateFieldType(), value);
        this.myCalendarModel.addChangeListener(this.getListener());
    }

    @Override
    public boolean isValid() {
        String text = this.getText();
        if (this.getText().length() <= 2) {
            try {
                int month = Integer.parseInt(text);
                if (month >= 1 && month <= 12) {
                    return true;
                }
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }
}

