/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.datatype.EREDateFactory;
import com.ericsson.ere.expression.BinaryTimeOperator;
import com.ericsson.ere.expression.Unit;
import com.ericsson.ere.gui.util.RelativeDialog;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.management.DateUtil;
import ericsson.vareditor.components.SelectableMultipler;
import java.awt.Window;

public class RelativeTimeDialog
extends RelativeDialog {
    private static final long serialVersionUID = 150840510806699510L;
    private static final Unit[] TIME_UNITS = new Unit[]{BinaryTimeOperator.TimeUnit.SECONDS, BinaryTimeOperator.TimeUnit.MINUTES, BinaryTimeOperator.TimeUnit.HOURS, BinaryTimeOperator.TimeUnit.DAYS, BinaryTimeOperator.TimeUnit.MONTHS, BinaryTimeOperator.TimeUnit.YEARS};

    public RelativeTimeDialog(Window parent, String aValue, String[] possibleFields, ClassRepository aRep, FieldDefinition field) {
        super(parent, DataType.TIME, aValue, possibleFields, TIME_UNITS, aRep, field);
    }

    @Override
    protected void setDefault() {
        String timeStr = DateUtil.formatISODate(EREDateFactory.today());
        this.myFirstField = ValueFieldCompositeObject.createForValue(timeStr, DataType.TIME);
        this.mySecondValue = 0;
        this.myOperation = "ADD";
        this.myUnit = BinaryTimeOperator.TimeUnit.DAYS;
    }

    @Override
    protected SelectableMultipler[] createUnitOptions() {
        SelectableMultipler[] options = new SelectableMultipler[this.myUnits.length];
        for (int i = 0; i < this.myUnits.length; ++i) {
            BinaryTimeOperator.TimeUnit du = (BinaryTimeOperator.TimeUnit)this.myUnits[i];
            options[i] = new SelectableMultipler(du.toString(), Long.valueOf(i));
        }
        return options;
    }
}

