/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicLabelUI;

public class UnderlineLabelUI
extends BasicLabelUI {
    private boolean myDrawUnderline = false;
    private String myText = null;
    private String myTrimmedText = null;
    private Font myFont = null;
    private Rectangle2D myTextBounds = null;
    private int myDescent = 0;
    private HoverMouseAdapter myHoverAdapter;
    private int myTextX;
    private int myTextY;

    public UnderlineLabelUI() {
        this(false);
    }

    public UnderlineLabelUI(boolean autoUnderlineHover) {
        if (autoUnderlineHover) {
            this.myHoverAdapter = new HoverMouseAdapter();
        }
    }

    @Override
    public void installUI(JComponent comp) {
        super.installUI(comp);
        if (this.myHoverAdapter != null) {
            comp.addMouseListener(this.myHoverAdapter);
        }
    }

    @Override
    public void uninstallUI(JComponent comp) {
        if (this.myHoverAdapter != null) {
            comp.removeMouseListener(this.myHoverAdapter);
        }
        super.uninstallUI(comp);
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        super.paintDisabledText(l, g, s, textX, textY);
        this.drawUnderline(l, g, s, textX, textY);
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        super.paintEnabledText(l, g, s, textX, textY);
        this.drawUnderline(l, g, s, textX, textY);
    }

    protected void drawUnderline(JLabel l, Graphics g, String s, int textX, int textY) {
        this.myTextX = textX;
        this.myTextY = textY;
        if (!this.myDrawUnderline || s == null) {
            return;
        }
        Font f = l.getFont();
        if (!s.equals(this.myText) || !f.equals(this.myFont)) {
            this.myText = s;
            this.myFont = f;
            this.myTrimmedText = s.replaceFirst("\\s+$", "");
            FontMetrics fm = l.getFontMetrics(this.myFont);
            this.myTextBounds = fm.getStringBounds(this.myTrimmedText, g);
            this.myDescent = fm.getDescent();
        }
        int w = (int)this.myTextBounds.getWidth();
        int y = textY + this.myDescent - 1;
        g.drawLine(textX, y, textX + w, y);
    }

    public void setDrawUnderline(boolean mode) {
        if (this.myHoverAdapter == null) {
            this.myDrawUnderline = mode;
        }
    }

    public boolean getDrawUnderline() {
        return this.myDrawUnderline;
    }

    public void hover(JComponent source, boolean b) {
        this.myDrawUnderline = b;
        Dimension dim = source.getPreferredSize();
        source.repaint(this.myTextX, this.myTextY, dim.width + 1, dim.height + 1);
    }

    public static JLabel createHyperlinkLabelFromAction(final Action a) {
        Icon icon = (Icon)a.getValue("SmallIcon");
        String text = (String)a.getValue("ShortDescription");
        if (text == null) {
            text = (String)a.getValue("LongDescription");
        }
        JLabel label = new JLabel(text);
        label.setUI(new UnderlineLabelUI(true));
        label.setIcon(icon);
        label.setForeground(Color.blue);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                String command = (String)a.getValue("ActionCommandKey");
                ActionEvent ae = new ActionEvent(e.getSource(), 1001, command, e.getWhen(), e.getModifiers());
                a.actionPerformed(ae);
            }
        });
        return label;
    }

    private class HoverMouseAdapter
    extends MouseAdapter {
        private HoverMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            UnderlineLabelUI.this.hover((JComponent)e.getSource(), true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            UnderlineLabelUI.this.hover((JComponent)e.getSource(), false);
        }
    }
}

