/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import ericsson.ere.management.DateUtil;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Calendar;

public class UniqueId {
    private static SecureRandom s_secureRandom = new SecureRandom();
    private static int s_hash = System.identityHashCode(s_secureRandom);
    private static byte[] s_addr;

    private static String hexFormat(int data) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("00000000");
        stringBuffer.append(Integer.toHexString(data));
        return stringBuffer.substring(stringBuffer.length() - 8);
    }

    private static String hexFormat(byte data) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("00");
        stringBuffer.append(Integer.toHexString(data));
        return stringBuffer.substring(stringBuffer.length() - 2);
    }

    public static String generateHex() {
        StringBuffer stringBuffer = new StringBuffer();
        int time = (int)System.currentTimeMillis();
        int rand = s_secureRandom.nextInt();
        stringBuffer.append(UniqueId.hexFormat(time));
        stringBuffer.append("-");
        stringBuffer.append(UniqueId.hexFormat(s_addr[0]));
        stringBuffer.append(".");
        stringBuffer.append(UniqueId.hexFormat(s_addr[1]));
        stringBuffer.append(".");
        stringBuffer.append(UniqueId.hexFormat(s_addr[2]));
        stringBuffer.append(".");
        stringBuffer.append(UniqueId.hexFormat(s_addr[3]));
        stringBuffer.append("-");
        stringBuffer.append(UniqueId.hexFormat(s_hash));
        stringBuffer.append("-");
        stringBuffer.append(UniqueId.hexFormat(rand));
        return stringBuffer.toString();
    }

    public static String generate() {
        StringBuffer stringBuffer = new StringBuffer();
        long time = System.currentTimeMillis();
        int rand = s_secureRandom.nextInt();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        stringBuffer.append(DateUtil.format(calendar));
        stringBuffer.append("-");
        stringBuffer.append(s_addr[0] & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(s_addr[1] & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(s_addr[2] & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(s_addr[3] & 0xFF);
        stringBuffer.append("-");
        stringBuffer.append(Math.abs(s_hash));
        stringBuffer.append("-");
        stringBuffer.append(Math.abs(rand));
        return stringBuffer.toString();
    }

    static {
        try {
            s_addr = InetAddress.getLocalHost().getAddress();
        }
        catch (Exception ex) {
            s_addr = new byte[4];
            s_secureRandom.nextBytes(s_addr);
        }
    }
}

