/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.gui.util.UniqueId;
import ericsson.ere.xml.XMLUtil;
import java.io.PrintWriter;
import java.util.Calendar;
import org.w3c.dom.Element;

public class Version {
    public static final String TAG_VERSION = "Version";
    public static final String ATTR_ID = "id";
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_CREATED = "created";
    public static final String ATTR_MODIFIED = "modified";
    private String myId;
    private long myVersion = -1L;
    private String myCreatedDate;
    private String myModifiedDate = this.myCreatedDate = Calendar.getInstance().getTime().toString();
    VersionUpdateListener myListener;

    public Version(Version version) {
        this.myId = version.getId();
        this.myVersion = version.getVersion();
        this.myCreatedDate = version.getCreatedDate();
        this.myModifiedDate = version.getLastModifiedDate();
        this.myListener = version.getListener();
    }

    public Version(VersionUpdateListener listener) {
        this.myListener = listener;
        this.myId = UniqueId.generate();
        this.myVersion = 0L;
    }

    @Deprecated
    public Version(Element iterator, VersionUpdateListener listener) throws Exception {
        this(iterator, listener, true);
    }

    public static Version create(Element config, VersionUpdateListener listener) {
        Version v;
        try {
            v = new Version(config, listener, false);
        }
        catch (Exception e) {
            throw new AssertionError((Object)"Checked exception not expected!");
        }
        return v;
    }

    private Version(Element iterator, VersionUpdateListener listener, boolean throwCheckedExceptions) throws Exception {
        this.myListener = listener;
        if (!(iterator.hasAttribute(ATTR_ID) && iterator.hasAttribute(ATTR_VERSION) && iterator.hasAttribute(ATTR_CREATED) && iterator.hasAttribute(ATTR_MODIFIED))) {
            String msg = String.format("Missing attribute, requires '%s', '%s', '%s' and '%s.", ATTR_ID, ATTR_VERSION, ATTR_CREATED, ATTR_MODIFIED);
            if (throwCheckedExceptions) {
                throw new Exception(msg);
            }
            throw new IllegalArgumentException(msg);
        }
        this.myId = iterator.getAttribute(ATTR_ID);
        try {
            this.myVersion = Long.parseLong(iterator.getAttribute(ATTR_VERSION));
        }
        catch (NumberFormatException nfe) {
            if (throwCheckedExceptions) {
                throw new Exception(nfe);
            }
            throw nfe;
        }
        this.myCreatedDate = iterator.getAttribute(ATTR_CREATED);
        this.myModifiedDate = iterator.getAttribute(ATTR_MODIFIED);
    }

    private VersionUpdateListener getListener() {
        return this.myListener;
    }

    public String getId() {
        return this.myId;
    }

    public long getVersion() {
        return this.myVersion;
    }

    public String getCreatedDate() {
        return this.myCreatedDate;
    }

    public String getLastModifiedDate() {
        return this.myModifiedDate;
    }

    public void setModifiedDate(String date) {
        Version backupVersion = new Version(this);
        this.myModifiedDate = date;
        this.updateVersion(backupVersion);
    }

    public void setCreatedDate(String date) {
        Version backupVersion = new Version(this);
        this.myCreatedDate = date;
        this.updateVersion(backupVersion);
    }

    public void setVersion(long version) {
        Version backupVersion = new Version(this);
        this.myVersion = version;
        this.updateVersion(backupVersion);
    }

    public void updateLastModifiedDate() {
        Version backupVersion = new Version(this);
        this.myModifiedDate = Calendar.getInstance().getTime().toString();
        ++this.myVersion;
        this.updateVersion(backupVersion);
    }

    public void set(Version version) {
        Version backupVersion = new Version(this);
        this.myId = new String(version.getId());
        this.myVersion = version.getVersion();
        this.myCreatedDate = new String(version.getCreatedDate());
        this.myModifiedDate = new String(version.getLastModifiedDate());
        this.myListener = version.getListener();
        this.updateVersion(backupVersion);
    }

    public void print(PrintWriter out, int indentLevel, String indentMarker) {
        for (int i = 0; i < indentLevel; ++i) {
            out.write(indentMarker);
        }
        out.write(this.getXml() + "\n");
    }

    public String getXml() {
        StringBuffer xml = new StringBuffer("<Version ");
        xml.append("id='" + this.myId + "' ");
        xml.append("version='" + this.myVersion + "' ");
        xml.append("created='" + this.myCreatedDate + "' ");
        xml.append("modified='" + this.myModifiedDate + "' ");
        xml.append("/>");
        return xml.toString();
    }

    public Element getVersionElement() throws Exception {
        return XMLUtil.buildDocumentFromString(this.getXml()).getDocumentElement();
    }

    public String toString() {
        return this.myVersion + " " + this.myId;
    }

    private void updateVersion(Version backupVersion) {
        try {
            if (this.myListener != null) {
                this.myListener.versionUpdated();
            }
        }
        catch (Exception e) {
            this.myId = backupVersion.getId();
            this.myVersion = backupVersion.getVersion();
            this.myCreatedDate = backupVersion.getCreatedDate();
            this.myModifiedDate = backupVersion.getLastModifiedDate();
        }
    }

    public static interface VersionUpdateListener {
        public void versionUpdated() throws Exception;
    }
}

