/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util.datepicker.models;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Vector;

public class DatePickerModel {
    public static final String COMMAND_DAY_OF_MONTH = "DAY_OF_MONTH";
    public static final String COMMAND_MONTH = "MONTH";
    public static final String COMMAND_YEAR = "YEAR";
    public static final String COMMAND_HOUR = "HOUR";
    public static final String COMMAND_MINUTE = "MINUTE";
    public static final String COMMAND_SECOND = "SECOND";
    public static final String COMMAND_ALL = "ALL";
    private Calendar calendar = null;
    private Vector<ActionListener> listenerList = new Vector();

    public DatePickerModel() {
        this(Calendar.getInstance());
    }

    public DatePickerModel(Calendar parCalendar) {
        this.calendar = (Calendar)parCalendar.clone();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setSelectedDay(int day) {
        this.calendar.set(5, day);
        this.fireActionEvent(new ActionEvent(this, 1001, COMMAND_DAY_OF_MONTH));
    }

    public void setSelectedYear(int year) {
        this.calendar.set(1, year);
        this.fireActionEvent(new ActionEvent(this, 1001, COMMAND_ALL));
    }

    public void setSelectedMonth(int month) {
        Calendar tCalendar = (Calendar)this.calendar.clone();
        tCalendar.set(5, 1);
        tCalendar.set(2, month);
        int maxDayOfMonth = tCalendar.getActualMaximum(5);
        if (maxDayOfMonth < this.getSelectedDay()) {
            this.setSelectedDay(maxDayOfMonth);
        }
        this.calendar.set(2, month);
        this.fireActionEvent(new ActionEvent(this, 1001, COMMAND_MONTH));
    }

    public void setSelectedHour(int hour) {
        this.calendar.set(11, hour);
        this.fireActionEvent(new ActionEvent(this, 1001, COMMAND_HOUR));
    }

    public void setSelectedMinute(int minute) {
        this.calendar.set(12, minute);
        this.fireActionEvent(new ActionEvent(this, 1001, COMMAND_MINUTE));
    }

    public void setSelectedSecond(int second) {
        this.calendar.set(13, second);
        this.fireActionEvent(new ActionEvent(this, 1001, COMMAND_SECOND));
    }

    public void setDate(Calendar instance) {
        this.calendar.set(1, instance.get(1));
        this.calendar.set(2, instance.get(2));
        this.calendar.set(5, instance.get(5));
        this.calendar.set(11, instance.get(11));
        this.calendar.set(12, instance.get(12));
        this.calendar.set(13, instance.get(13));
        this.fireActionEvent(new ActionEvent(this, 1001, COMMAND_ALL));
    }

    public int getSelectedDay() {
        return this.calendar.get(5);
    }

    public int getSelectedMonth() {
        return this.calendar.get(2);
    }

    public int getSelectedYear() {
        return this.calendar.get(1);
    }

    public int getSelectedHour() {
        return this.calendar.get(11);
    }

    public int getSelectedMinute() {
        return this.calendar.get(12);
    }

    public int getSelectedSecond() {
        return this.calendar.get(13);
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(listener);
    }

    public void fireActionEvent(ActionEvent e) {
        for (ActionListener listener : this.listenerList) {
            listener.actionPerformed(e);
        }
    }
}

