/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.wizard;

import com.ericsson.ere.gui.wizard.AbstractWizardState;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.swing.EDT;
import java.util.Observable;
import javax.swing.ImageIcon;

public abstract class AbstractWizardModel
extends Observable {
    private static final String CANCEL = "Cancel";
    private static final String STOP = "Stop";
    private static final String FINISH = "Finish";
    private AbstractWizardState myCurrentState;
    private boolean myIsStarted = false;
    private String myWizardTitle = "ERE Wizard";
    private ImageIcon myWizardIcon;
    private boolean myBackIsEnabled;
    private boolean myNextIsEnabled;
    private boolean myControlButtonIsEnabled;
    private String myControlButtonText = "Cancel";

    public abstract void cancelAllActions();

    public abstract void wizardDataChanged();

    public void startWizard() {
        if (!this.myIsStarted) {
            this.myIsStarted = true;
            this.activateCurrentState();
        }
    }

    public AbstractWizardState getCurrentState() {
        return this.myCurrentState;
    }

    public void setCurrentState(AbstractWizardState state) {
        if (state != null && state != this.myCurrentState) {
            this.myCurrentState = state;
            this.triggerObservers();
            this.activateCurrentState();
        }
    }

    protected void activateCurrentState() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                if (AbstractWizardModel.this.myIsStarted) {
                    AbstractWizardModel.this.myCurrentState.activate();
                }
            }
        });
    }

    public ImageIcon getWizardIcon() {
        return this.myWizardIcon;
    }

    public String getWizardTitle() {
        return this.myWizardTitle;
    }

    public boolean isBackEnabled() {
        return this.myBackIsEnabled;
    }

    public boolean isNextEnabled() {
        return this.myNextIsEnabled;
    }

    public boolean isControlEnabled() {
        return this.myControlButtonIsEnabled;
    }

    public void setBackEnabled(boolean isEnabled) {
        if (this.myBackIsEnabled != isEnabled) {
            this.myBackIsEnabled = isEnabled;
            this.triggerObservers();
        }
    }

    public void setNextEnabled(boolean isEnabled) {
        if (this.myNextIsEnabled != isEnabled) {
            this.myNextIsEnabled = isEnabled;
            this.triggerObservers();
        }
    }

    public void setBackAndNextEnabled(boolean isBackEnabled, boolean isNextEnabled) {
        boolean isChange;
        boolean bl = isChange = this.myBackIsEnabled != isBackEnabled || this.myNextIsEnabled != isNextEnabled;
        if (isChange) {
            this.myBackIsEnabled = isBackEnabled;
            this.myNextIsEnabled = isNextEnabled;
            this.triggerObservers();
        }
    }

    public void setControlButtonEnabled(boolean isEnabled) {
        if (this.myControlButtonIsEnabled != isEnabled) {
            this.myControlButtonIsEnabled = isEnabled;
            this.triggerObservers();
        }
    }

    public void setControlButtonText(String text) {
        if (text != null && !text.equals(this.myControlButtonText)) {
            this.myControlButtonText = text;
            this.triggerObservers();
        }
    }

    public String getControlButtonText() {
        return this.myControlButtonText;
    }

    public void setStandardStartNavigationButtonMode() {
        this.myNextIsEnabled = false;
        this.myBackIsEnabled = false;
        this.myControlButtonIsEnabled = true;
        this.myControlButtonText = CANCEL;
        this.triggerObservers();
    }

    public void setStopNavigationButtonMode() {
        this.myNextIsEnabled = false;
        this.myBackIsEnabled = false;
        this.myControlButtonIsEnabled = true;
        this.myControlButtonText = STOP;
        this.triggerObservers();
    }

    public void setFinishedNavigationButtonMode() {
        this.myNextIsEnabled = false;
        this.myBackIsEnabled = false;
        this.myControlButtonIsEnabled = true;
        this.myControlButtonText = FINISH;
        this.triggerObservers();
    }

    public WizardStateView getCurrentPanel() {
        return this.myCurrentState.getPanel();
    }

    private void triggerObservers() {
        this.setChanged();
        this.notifyObservers();
    }
}

