/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.wizard;

import com.ericsson.ere.gui.wizard.WizardOptions;
import com.ericsson.ere.gui.wizard.WizardState;
import com.ericsson.ere.gui.wizard.panels.DefaultWizardPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

@Deprecated
public class WizardDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel mainPanel = null;
    private JPanel topInstructionPanel = null;
    protected JPanel middlePanel = null;
    protected JPanel buttonPanel = null;
    protected JTextArea instructionsArea = null;
    private JButton backButton = null;
    private JButton nextButton = null;
    private JButton cancelButton = null;
    private JSeparator upperSeparator = new JSeparator();
    private JSeparator buttonSeparator = null;
    private WizardState wizardState = null;
    private Container myWindow;
    private WizardType myType;
    private WizardStatus status = WizardStatus.OK;

    public WizardDialog(JFrame owner, WizardOptions wizardOptions) {
        this(owner, wizardOptions, WizardType.DIALOG);
    }

    public WizardDialog(JDesktopPane owner, WizardOptions wizardOptions) {
        this(owner, wizardOptions, WizardType.INTERNAL_FRAME);
    }

    private WizardDialog(Container owner, WizardOptions wizardOptions, WizardType type) {
        this.myType = type;
        if (type == WizardType.DIALOG) {
            this.myWindow = new JDialog((Frame)((JFrame)owner), true);
            this.myWindow.setSize(459, 499);
            ((JDialog)this.myWindow).setContentPane(this.getJContentPane());
            ((JDialog)this.myWindow).setTitle(wizardOptions.wizardTitle);
            if (wizardOptions.wizardIcon != null) {
                ((JDialog)this.myWindow).setIconImage(wizardOptions.wizardIcon.getImage());
            }
            ((JDialog)this.myWindow).setLocationRelativeTo(owner);
        } else if (type == WizardType.INTERNAL_FRAME) {
            this.myWindow = new JInternalFrame(wizardOptions.wizardTitle, true, true, true, true);
            this.myWindow.setSize(459, 499);
            ((JInternalFrame)this.myWindow).setTitle(wizardOptions.wizardTitle);
            ((JInternalFrame)this.myWindow).setFrameIcon(wizardOptions.wizardIcon);
            ((JInternalFrame)this.myWindow).setContentPane(this.getJContentPane());
            this.myWindow.setName("WizardDialog.JInternalFrame.myWindow");
            ((JDesktopPane)owner).add(this.myWindow);
        }
        this.registerActionsForWindow();
        wizardOptions.wizardState = this.wizardState = new WizardState(this, this.backButton, this.nextButton, this.cancelButton);
        this.status = WizardStatus.OK;
        Enumeration<DefaultWizardPanel> e = wizardOptions.wizardPanels.elements();
        while (e.hasMoreElements()) {
            this.wizardState.register(e.nextElement());
        }
    }

    public void setSize(int width, int height) {
        this.myWindow.setSize(width, height);
    }

    public void setVisible(boolean visible) {
        this.myWindow.setVisible(visible);
    }

    public void dispose() {
        if (this.myType == WizardType.INTERNAL_FRAME) {
            ((JInternalFrame)this.myWindow).dispose();
        } else if (this.myType == WizardType.DIALOG) {
            ((JDialog)this.myWindow).dispose();
        }
    }

    public void cancel() {
        this.status = WizardStatus.CANCEL;
    }

    public boolean isCancelled() {
        return this.status == WizardStatus.CANCEL;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 0;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.getTopInstructionPanel(), gridBagConstraints);
            this.mainPanel.add((Component)this.getMiddlePanel(), gridBagConstraints1);
            this.mainPanel.add((Component)this.getButtonPanel(), gridBagConstraints2);
        }
        return this.mainPanel;
    }

    private JPanel getTopInstructionPanel() {
        if (this.topInstructionPanel == null) {
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.insets = new Insets(22, 11, 22, 11);
            gridBagConstraints3.weightx = 1.0;
            this.topInstructionPanel = new JPanel();
            this.topInstructionPanel.setLayout(new GridBagLayout());
            this.topInstructionPanel.setBackground(Color.white);
            this.topInstructionPanel.add((Component)this.upperSeparator, gridBagConstraints8);
            this.topInstructionPanel.add((Component)this.getInstructionsArea(), gridBagConstraints3);
        }
        return this.topInstructionPanel;
    }

    private JPanel getMiddlePanel() {
        if (this.middlePanel == null) {
            this.middlePanel = new JPanel();
            this.middlePanel.setLayout(new CardLayout());
        }
        return this.middlePanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridwidth = 4;
            gridBagConstraints9.gridy = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 3;
            gridBagConstraints7.insets = new Insets(17, 0, 11, 11);
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.insets = new Insets(17, 0, 11, 5);
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(17, 0, 11, 5);
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.gridy = 1;
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new GridBagLayout());
            this.buttonPanel.add((Component)this.getBackButton(), gridBagConstraints4);
            this.buttonPanel.add((Component)this.getNextButton(), gridBagConstraints5);
            this.buttonPanel.add((Component)this.getCancelButton(), gridBagConstraints7);
            this.buttonPanel.add((Component)this.getButtonSeparator(), gridBagConstraints9);
        }
        return this.buttonPanel;
    }

    private JTextArea getInstructionsArea() {
        if (this.instructionsArea == null) {
            this.instructionsArea = new JTextArea();
            this.instructionsArea.setText("Hello this is an example");
            this.instructionsArea.setEditable(false);
            this.instructionsArea.setName("WizardDialog.JTextArea.instructionsArea");
        }
        return this.instructionsArea;
    }

    private JButton getBackButton() {
        if (this.backButton == null) {
            this.backButton = new JButton();
            this.backButton.setText("< Back");
            this.backButton.setName("WizardDialog.JButton.backButton");
        }
        return this.backButton;
    }

    private JButton getNextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton();
            this.nextButton.setText("Next >");
            this.nextButton.setName("WizardDialog.JButton.nextButton");
        }
        return this.nextButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setName("WizardDialog.JButton.cancelAndFinishButton");
        }
        return this.cancelButton;
    }

    private JSeparator getButtonSeparator() {
        if (this.buttonSeparator == null) {
            this.buttonSeparator = new JSeparator();
        }
        return this.buttonSeparator;
    }

    private void registerActionsForWindow() {
        AbstractAction close = this.createCloseAction();
        String actionName = (String)close.getValue("Name");
        KeyStroke key = KeyStroke.getKeyStroke(27, 0);
        if (this.myWindow instanceof JInternalFrame) {
            ((JInternalFrame)this.myWindow).getInputMap(1).put(key, actionName);
            ((JInternalFrame)this.myWindow).getActionMap().put(actionName, close);
        } else if (this.myWindow instanceof JDialog) {
            ((JDialog)this.myWindow).getRootPane().getInputMap(2).put(key, actionName);
            ((JDialog)this.myWindow).getRootPane().getActionMap().put(actionName, close);
        } else {
            throw new AssertionError((Object)"Wizards are currently only supported in JInternalFrames and JDialogs");
        }
    }

    private AbstractAction createCloseAction() {
        return new AbstractAction("close"){

            @Override
            public void actionPerformed(ActionEvent event) {
                WizardDialog.this.cancel();
                WizardDialog.this.dispose();
            }
        };
    }

    private static enum WizardStatus {
        OK,
        CANCEL;

    }

    private static enum WizardType {
        DIALOG,
        INTERNAL_FRAME;

    }
}

