/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.wizard;

import com.ericsson.ere.gui.navigator.nodednd.DndWizardModel;
import com.ericsson.ere.gui.navigator.nodeexport.ExportWizardModel;
import com.ericsson.ere.gui.navigator.nodeimport.ImportWizardModel;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.wizard.AbstractWizardModel;
import com.ericsson.ere.gui.wizard.WizardController;
import com.ericsson.ere.gui.wizard.WizardView;
import com.ericsson.ere.selectiontree.tdfexport.TDFExportDefaultStateFactory;
import com.ericsson.ere.selectiontree.tdfexport.TDFExportWizardModel;
import com.ericsson.ere.selectiontree.tdfimport.TDFImportWizardModel;
import com.ericsson.ere.selectiontree.tdfimport.TDFImportWizardStateFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedField;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import org.w3c.dom.Element;

public class WizardFactory {
    public static WizardView createNavigatorExportWizard(JFrame owner, AbstractNavigatorNode sourceNode) {
        AbstractWizardModel aModel = WizardFactory.createModelForGeneralElementExportWizard(sourceNode);
        WizardController aController = new WizardController(aModel);
        return WizardFactory.createWizardDialogForInternalFrame(owner, aController, aModel);
    }

    public static WizardView createNavigatorDnDWizard(JFrame owner, AbstractNavigatorNode sourceNode, AbstractNavigatorNode targetNode, boolean includeService) {
        AbstractWizardModel aModel = WizardFactory.createModelForDnDWizard(sourceNode, targetNode, includeService);
        WizardController aController = new WizardController(aModel);
        return WizardFactory.createWizardDialogForInternalFrame(owner, aController, aModel);
    }

    public static WizardView createNavigatorImportWizard(JFrame owner, AbstractNavigatorNode targetNode) {
        return WizardFactory.createNavigatorImportWizard(owner, null, targetNode);
    }

    public static WizardView createNavigatorImportWizard(JFrame owner, File importFile, AbstractNavigatorNode targetNode) {
        AbstractWizardModel aModel = WizardFactory.createModelForImportWizard(targetNode, importFile);
        WizardController aController = new WizardController(aModel);
        return WizardFactory.createWizardDialogForInternalFrame(owner, aController, aModel);
    }

    private static AbstractWizardModel createModelForDnDWizard(AbstractNavigatorNode sourceNode, AbstractNavigatorNode targetNode, boolean includeService) {
        DndWizardModel aModel = new DndWizardModel(sourceNode, targetNode);
        aModel.setExportRequiringService(includeService);
        return aModel;
    }

    private static AbstractWizardModel createModelForImportWizard(AbstractNavigatorNode targetNode, File importFile) {
        ImportWizardModel aModel = importFile == null ? new ImportWizardModel(targetNode) : new ImportWizardModel(targetNode, importFile);
        return aModel;
    }

    private static AbstractWizardModel createModelForGeneralElementExportWizard(AbstractNavigatorNode sourceNode) {
        return new ExportWizardModel(sourceNode);
    }

    private static WizardView createWizardDialogForInternalFrame(JFrame owner, WizardController controller, AbstractWizardModel model) {
        return new WizardView(owner, controller, model);
    }

    private static WizardView createWizardDialogForDialog(JDesktopPane owner, WizardController controller, AbstractWizardModel model) {
        return new WizardView(owner, controller, model);
    }

    public static WizardView createTDFImportWizard(List<String> existingTDFs, List<String> tdfsInUse, ClassRepository rep, Map<String, Element> resultingTDFs) {
        TDFImportWizardModel model = new TDFImportWizardModel(existingTDFs, tdfsInUse, rep, resultingTDFs, new TDFImportWizardStateFactory());
        WizardController aController = new WizardController(model);
        return new WizardView(GuiServiceCenter.getInstance().getMainWindow(), aController, (AbstractWizardModel)model);
    }

    public static WizardView createTDFExportWizard(Map<String, TreeDefinedField> allTDFs) {
        TDFExportWizardModel model = new TDFExportWizardModel(allTDFs, new TDFExportDefaultStateFactory());
        WizardController aController = new WizardController(model);
        return new WizardView(GuiServiceCenter.getInstance().getMainWindow(), aController, (AbstractWizardModel)model);
    }
}

