/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.wizard.selectabletree;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class SelectableNodeWrapper
extends DefaultMutableTreeNode {
    boolean markedForExport = false;
    public DefaultMutableTreeNode wrappedNode = null;

    public SelectableNodeWrapper(DefaultMutableTreeNode tNode) {
        this.wrappedNode = tNode;
    }

    public boolean isMarkedForExport() {
        return this.markedForExport;
    }

    @Override
    public String toString() {
        return this.wrappedNode.toString();
    }

    public DefaultMutableTreeNode getWrappedNode() {
        return this.wrappedNode;
    }

    public void toggleMarkedForExport() {
        this.markedForExport = !this.markedForExport;
        this.setMarkedForExport(this.markedForExport);
        this.checkParents(this);
    }

    public void setMarkedForExport(boolean mark) {
        this.markedForExport = mark;
        if (this.getChildCount() != 0) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                SelectableNodeWrapper tNode = (SelectableNodeWrapper)e.nextElement();
                tNode.setMarkedForExport(mark);
            }
        }
    }

    private void checkParents(SelectableNodeWrapper node) {
        SelectableNodeWrapper parent = (SelectableNodeWrapper)node.getParent();
        if (parent != null) {
            parent.markedForExport = this.hasNodesMarkedForExport(parent);
            this.checkParents(parent);
        }
    }

    private boolean hasNodesMarkedForExport(SelectableNodeWrapper node) {
        boolean result = false;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            SelectableNodeWrapper child = (SelectableNodeWrapper)e.nextElement();
            if (!child.markedForExport) continue;
            result = true;
        }
        return result;
    }
}

