/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.math;

import com.ericsson.ere.math.BaseRationalNumber;
import com.ericsson.ere.math.BigRationalNumber;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;

public class LongRationalNumber
extends BaseRationalNumber
implements Comparable<BaseRationalNumber> {
    private static final LongRationalNumber ZERO = new LongRationalNumber(0L, 1L);
    private final long myNumerator;
    private final long myDenominator;
    private transient int hash;

    public LongRationalNumber(LongRationalNumber number) {
        this.myNumerator = number.myNumerator;
        this.myDenominator = number.myDenominator;
        this.myBase = 1;
    }

    public LongRationalNumber(long numerator, long denominator) {
        if (denominator <= 0L) {
            throw new ArithmeticException("Negative or zero denominator not allowed");
        }
        this.myNumerator = numerator;
        this.myDenominator = denominator;
        this.myBase = 1;
    }

    public LongRationalNumber(byte[] data) {
        if (data.length == 17 && data[0] == 1) {
            long n = 0L;
            long d = 0L;
            n |= ((long)data[1] & 0xFFL) << 56;
            n |= ((long)data[2] & 0xFFL) << 48;
            n |= ((long)data[3] & 0xFFL) << 40;
            n |= ((long)data[4] & 0xFFL) << 32;
            n |= ((long)data[5] & 0xFFL) << 24;
            n |= ((long)data[6] & 0xFFL) << 16;
            n |= ((long)data[7] & 0xFFL) << 8;
            n |= ((long)data[8] & 0xFFL) << 0;
            d |= ((long)data[9] & 0xFFL) << 56;
            d |= ((long)data[10] & 0xFFL) << 48;
            d |= ((long)data[11] & 0xFFL) << 40;
            d |= ((long)data[12] & 0xFFL) << 32;
            d |= ((long)data[13] & 0xFFL) << 24;
            d |= ((long)data[14] & 0xFFL) << 16;
            d |= ((long)data[15] & 0xFFL) << 8;
            this.myNumerator = n;
            this.myDenominator = d |= ((long)data[16] & 0xFFL) << 0;
            if (this.myDenominator <= 0L) {
                throw new ArithmeticException("Negative or zero denominator not allowed");
            }
        } else {
            throw new ArithmeticException("Can not create LongRatingDecimal from byte array");
        }
        this.myBase = 1;
    }

    @Override
    public BaseRationalNumber add(BaseRationalNumber bnumber) {
        if (this.myNumerator == 0L) {
            return bnumber;
        }
        if (bnumber.myBase == 2) {
            return new BigRationalNumber(this).add(bnumber);
        }
        LongRationalNumber number = (LongRationalNumber)bnumber;
        if (number.myNumerator == 0L) {
            return this;
        }
        boolean simplified = false;
        boolean overflow = false;
        Holder own = new Holder(this.myNumerator, this.myDenominator);
        Holder other = new Holder(number.myNumerator, number.myDenominator);
        while (true) {
            overflow = this.findCommonDenominator(own, other);
            Holder holder = own;
            holder.numerator = holder.numerator + other.numerator;
            if (this.myNumerator < 0L && number.myNumerator < 0L) {
                if (own.numerator >= 0L) {
                    overflow = true;
                }
            } else if (this.myNumerator > 0L && number.myNumerator > 0L && own.numerator < 0L) {
                overflow = true;
            }
            if (!overflow) break;
            if (simplified) {
                BigRationalNumber ownBig = new BigRationalNumber(this);
                return ownBig.add(number);
            }
            simplified = true;
            overflow = false;
            own = this.simplify();
            other = number.simplify();
        }
        return new LongRationalNumber(own.numerator, own.denominator);
    }

    private boolean findCommonDenominator(Holder own, Holder other) {
        if (other.denominator != own.denominator) {
            if (other.denominator % own.denominator == 0L) {
                long scale = other.denominator / own.denominator;
                long org = own.denominator;
                Holder holder = own;
                holder.denominator = holder.denominator * scale;
                if (own.denominator / org != scale) {
                    return true;
                }
                org = own.numerator;
                holder = own;
                holder.numerator = holder.numerator * scale;
                if (org != 0L && own.numerator / org != scale) {
                    return true;
                }
            } else if (own.denominator % other.denominator == 0L) {
                long scale = own.denominator / other.denominator;
                long org = other.denominator;
                Holder holder = other;
                holder.denominator = holder.denominator * scale;
                if (other.denominator / org != scale) {
                    return true;
                }
                org = other.numerator;
                holder = other;
                holder.numerator = holder.numerator * scale;
                if (org != 0L && other.numerator / org != scale) {
                    return true;
                }
            } else {
                long org = own.numerator;
                Holder holder = own;
                holder.numerator = holder.numerator * other.denominator;
                if (org != 0L && own.numerator / org != other.denominator) {
                    return true;
                }
                org = other.numerator;
                holder = other;
                holder.numerator = holder.numerator * own.denominator;
                if (org != 0L && other.numerator / org != own.denominator) {
                    return true;
                }
                org = own.denominator;
                holder = own;
                holder.denominator = holder.denominator * other.denominator;
                if (own.denominator / org != other.denominator) {
                    return true;
                }
                other.denominator = own.denominator;
            }
        }
        return false;
    }

    @Override
    public BaseRationalNumber add(long number) {
        return this.add(new LongRationalNumber(number, 1L));
    }

    @Override
    public BaseRationalNumber subtract(BaseRationalNumber bnumber) {
        if (this.myNumerator == 0L) {
            return bnumber.negate();
        }
        if (bnumber.myBase == 2) {
            return new BigRationalNumber(this).subtract(bnumber);
        }
        LongRationalNumber number = (LongRationalNumber)bnumber;
        if (number.myNumerator == 0L) {
            return this;
        }
        boolean simplified = false;
        boolean overflow = false;
        Holder own = new Holder(this.myNumerator, this.myDenominator);
        Holder other = new Holder(number.myNumerator, number.myDenominator);
        while (true) {
            overflow = this.findCommonDenominator(own, other);
            Holder holder = own;
            holder.numerator = holder.numerator - other.numerator;
            if (this.myNumerator < 0L && number.myNumerator > 0L) {
                if (own.numerator > 0L) {
                    overflow = true;
                }
            } else if (this.myNumerator > 0L && number.myNumerator < 0L && own.numerator < 0L) {
                overflow = true;
            }
            if (!overflow) break;
            if (simplified) {
                BigRationalNumber ownBig = new BigRationalNumber(this);
                return ownBig.subtract(number);
            }
            simplified = true;
            own = this.simplify();
            other = number.simplify();
        }
        return new LongRationalNumber(own.numerator, own.denominator);
    }

    @Override
    public BaseRationalNumber subtract(long number) {
        return this.subtract(new LongRationalNumber(number, 1L));
    }

    @Override
    public BaseRationalNumber multiply(BaseRationalNumber bnumber) {
        if (this.myNumerator == 0L) {
            return ZERO;
        }
        if (bnumber.myBase == 2) {
            return new BigRationalNumber(this).multiply(bnumber);
        }
        LongRationalNumber number = (LongRationalNumber)bnumber;
        if (number.myNumerator == 0L) {
            return ZERO;
        }
        boolean simplified = false;
        Holder own = new Holder(this.myNumerator, this.myDenominator);
        Holder other = new Holder(number.myNumerator, number.myDenominator);
        while (true) {
            if (other.denominator == other.numerator) {
                return this;
            }
            if (own.denominator == own.numerator) {
                return number;
            }
            Holder holder = own;
            holder.denominator = holder.denominator * other.denominator;
            holder = own;
            holder.numerator = holder.numerator * other.numerator;
            boolean overflow = false;
            if (own.denominator / this.myDenominator != other.denominator) {
                overflow = true;
            }
            if (own.numerator / this.myNumerator != other.numerator) {
                overflow = true;
            }
            if (!overflow) break;
            if (simplified) {
                return new BigRationalNumber(this.myNumerator, this.myDenominator).multiply(number);
            }
            simplified = true;
            own = this.simplify();
            other = number.simplify();
        }
        return new LongRationalNumber(own.numerator, own.denominator);
    }

    @Override
    public BaseRationalNumber multiply(long number) {
        return this.multiply(new LongRationalNumber(number, 1L));
    }

    @Override
    public BaseRationalNumber divide(BaseRationalNumber bnumber) {
        if (this.myNumerator == 0L) {
            return ZERO;
        }
        if (bnumber.myBase == 2) {
            return new BigRationalNumber(this).divide(bnumber);
        }
        LongRationalNumber number = (LongRationalNumber)bnumber;
        if (number.myNumerator == 0L) {
            throw new ArithmeticException("Divide by zero");
        }
        boolean simplified = false;
        Holder own = new Holder(this.myNumerator, this.myDenominator);
        Holder other = new Holder(number.myNumerator, number.myDenominator);
        while (true) {
            Holder holder = own;
            holder.denominator = holder.denominator * other.numerator;
            holder = own;
            holder.numerator = holder.numerator * other.denominator;
            boolean overflow = false;
            if (own.denominator / this.myDenominator != other.numerator) {
                overflow = true;
            }
            if (own.numerator / this.myNumerator != other.denominator) {
                overflow = true;
            }
            if (other.numerator < 0L) {
                own.numerator = -own.numerator;
            }
            if (own.denominator < 0L) {
                own.denominator = -own.denominator;
            }
            if (!overflow) break;
            if (simplified) {
                return new BigRationalNumber(this.myNumerator, this.myDenominator).divide(number);
            }
            simplified = true;
            own = this.simplify();
            other = number.simplify();
        }
        return new LongRationalNumber(own.numerator, own.denominator);
    }

    @Override
    public BaseRationalNumber divide(long number) {
        return this.divide(new LongRationalNumber(number, 1L));
    }

    @Override
    public boolean isZero() {
        return this.myNumerator == 0L;
    }

    @Override
    public int compareTo(long o) {
        return this.compareTo(new LongRationalNumber(o, 1L));
    }

    @Override
    public int compareTo(BaseRationalNumber o) {
        if (o.myBase == 2) {
            return new BigRationalNumber(this).compareTo(o);
        }
        LongRationalNumber number = (LongRationalNumber)o;
        if (this.myNumerator == 0L) {
            return number.myNumerator == 0L ? 0 : (0L > number.myNumerator ? 1 : -1);
        }
        if (number.myNumerator == 0L) {
            return this.myNumerator == 0L ? 0 : (this.myNumerator > 0L ? 1 : -1);
        }
        Holder own = new Holder(this.myNumerator, this.myDenominator);
        Holder other = new Holder(number.myNumerator, number.myDenominator);
        if (this.findCommonDenominator(own, other)) {
            return new BigRationalNumber(this).compareTo(o);
        }
        if (own.numerator == other.numerator) {
            return 0;
        }
        if (own.numerator > other.numerator) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            Holder own = this.simplify();
            int PRIME = 31;
            result = 1;
            result = 31 * result + (int)(own.denominator ^ own.denominator >>> 32);
            this.hash = result = 31 * result + (int)(own.numerator ^ own.numerator >>> 32);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BigRationalNumber) {
            return this.equalsBig((BigRationalNumber)obj);
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equals((LongRationalNumber)obj);
    }

    boolean equals(long numerator, long denominator) {
        Holder own = this.simplify();
        return own.numerator == numerator && own.denominator == denominator;
    }

    public boolean equals(LongRationalNumber otherNumber) {
        Holder own = this.simplify();
        Holder other = otherNumber.simplify();
        return own.numerator == other.numerator && own.denominator == other.denominator;
    }

    private boolean equalsBig(BigRationalNumber otherNumber) {
        return otherNumber.equalsLong(this);
    }

    public boolean equals(long o) {
        Holder own = this.simplify();
        return own.denominator == 1L && own.numerator == o;
    }

    private Holder simplify() {
        Holder value = new Holder(this.myNumerator, this.myDenominator);
        long gcd = Math.abs(this.euclid(value.numerator, value.denominator));
        Holder holder = value;
        holder.numerator = holder.numerator / gcd;
        holder = value;
        holder.denominator = holder.denominator / gcd;
        return value;
    }

    public BaseRationalNumber normalize() {
        Holder simplified = this.simplify();
        if (simplified.numerator != this.myNumerator || simplified.denominator != this.myDenominator) {
            return new LongRationalNumber(simplified.numerator, simplified.denominator);
        }
        return this;
    }

    private long euclid(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return this.euclid(b, a % b);
    }

    @Override
    public double doubleValue() {
        return (double)this.myNumerator / (double)this.myDenominator;
    }

    @Override
    public float floatValue() {
        return (float)this.myNumerator / (float)this.myDenominator;
    }

    @Override
    public int intValue() {
        return (int)(this.myNumerator / this.myDenominator);
    }

    @Override
    public long longValue() {
        return this.myNumerator / this.myDenominator;
    }

    @Override
    public BigDecimal bigDecimalValue(int scale, int roundingMode) {
        BigDecimal numer = new BigDecimal(this.myNumerator);
        BigDecimal denom = new BigDecimal(this.myDenominator);
        return numer.divide(denom, scale, roundingMode);
    }

    @Override
    public BigDecimal toBigDecimal(MathContext mc) {
        return new BigDecimal(this.myNumerator).divide(new BigDecimal(this.myDenominator), mc);
    }

    public String toString() {
        double d;
        double ad;
        String s = this.isZero() ? "0.0" : (this.isWholeNumber() ? String.valueOf(this.longValue()) + ".0" : ((ad = Math.abs(d = this.doubleValue())) >= 0.001 && ad < 1.0E7 ? Double.toString(d) : this.toBigDecimal(MathContext.DECIMAL128).toPlainString()));
        return s;
    }

    @Override
    public String toDotString(int scale, int roundingMode) {
        BigDecimal numer = new BigDecimal(this.myNumerator);
        BigDecimal denom = new BigDecimal(this.myDenominator);
        BigDecimal result = numer.divide(denom, scale, roundingMode);
        return result.toPlainString();
    }

    @Override
    public BaseRationalNumber negate() {
        if (this.myNumerator == 0L) {
            return ZERO;
        }
        if (this.myNumerator == Long.MIN_VALUE) {
            return new BigRationalNumber(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE), BigInteger.valueOf(this.myDenominator));
        }
        return new LongRationalNumber(-this.myNumerator, this.myDenominator);
    }

    @Override
    public BaseRationalNumber remainder(BaseRationalNumber bdivisor) {
        if (bdivisor.myBase == 2) {
            return new BigRationalNumber(this).remainder(bdivisor);
        }
        LongRationalNumber divisor = (LongRationalNumber)bdivisor;
        if (divisor.myNumerator == 0L) {
            throw new ArithmeticException("Zero divisor");
        }
        if (divisor.myNumerator < 0L) {
            throw new ArithmeticException("Negative divisor");
        }
        return this.subtract(divisor.multiply(this.divideToIntegralValue(divisor)));
    }

    private BaseRationalNumber divideToIntegralValue(BaseRationalNumber number) {
        BaseRationalNumber divRes = this.divide(number);
        return new LongRationalNumber(((LongRationalNumber)divRes).longValue(), 1L);
    }

    @Override
    public BaseRationalNumber abs() {
        assert (this.myDenominator > 0L);
        if (this.myNumerator < 0L) {
            return new LongRationalNumber(-this.myNumerator, this.myDenominator);
        }
        return this;
    }

    @Override
    public byte[] toByteArray() {
        byte[] data = new byte[17];
        data[0] = 1;
        long n = this.myNumerator;
        long d = this.myDenominator;
        data[1] = (byte)(n >> 56);
        data[2] = (byte)(n >> 48);
        data[3] = (byte)(n >> 40);
        data[4] = (byte)(n >> 32);
        data[5] = (byte)(n >> 24);
        data[6] = (byte)(n >> 16);
        data[7] = (byte)(n >> 8);
        data[8] = (byte)(n >> 0);
        data[9] = (byte)(d >> 56);
        data[10] = (byte)(d >> 48);
        data[11] = (byte)(d >> 40);
        data[12] = (byte)(d >> 32);
        data[13] = (byte)(d >> 24);
        data[14] = (byte)(d >> 16);
        data[15] = (byte)(d >> 8);
        data[16] = (byte)(d >> 0);
        return data;
    }

    public long getDenominator() {
        return this.myDenominator;
    }

    public long getNumerator() {
        return this.myNumerator;
    }

    @Override
    public boolean isWholeNumber() {
        return this.myNumerator % this.myDenominator == 0L;
    }

    private static class Holder {
        private long numerator;
        private long denominator;

        public Holder(long n, long d) {
            this.numerator = n;
            this.denominator = d;
        }
    }
}

