/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.math;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.math.BaseRationalNumber;
import com.ericsson.ere.math.RationalNumber;
import java.math.BigDecimal;
import java.math.MathContext;

@Immutable
public final class RatingDecimal
extends Number
implements Cloneable,
Comparable<RatingDecimal> {
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    public static final RatingDecimal ZERO = new RatingDecimal(0L, 1L);
    public static final RatingDecimal ONE = new RatingDecimal(1L, 1L);
    public static final RatingDecimal MINUS_ONE = new RatingDecimal(-1L, 1L);
    public static final RatingDecimal ONE_HUNDRED = new RatingDecimal(100L, 1L);
    public static final RatingDecimal LONG_MAX_VALUE = new RatingDecimal(Long.MAX_VALUE, 1L);
    public static final RatingDecimal LONG_MIN_VALUE = new RatingDecimal(Long.MIN_VALUE, 1L);
    public static final RatingDecimal INT_MAX_VALUE = new RatingDecimal(Integer.MAX_VALUE, 1L);
    public static final RatingDecimal INT_MIN_VALUE = new RatingDecimal(Integer.MIN_VALUE, 1L);
    private final BaseRationalNumber myNumber;

    public RatingDecimal(double value) {
        this.myNumber = BaseRationalNumber.valueOf((long)(value * 1000000.0), 1000000L);
    }

    public RatingDecimal(String number) {
        this.myNumber = BaseRationalNumber.valueOf(number, -1);
    }

    public RatingDecimal(long n, long d) {
        this.myNumber = BaseRationalNumber.valueOf(n, d);
    }

    @Deprecated
    public RatingDecimal(RationalNumber n) {
        throw new IllegalArgumentException("Method not usable");
    }

    private RatingDecimal(BaseRationalNumber n) {
        this.myNumber = n;
    }

    public RatingDecimal(byte[] data) {
        this.myNumber = BaseRationalNumber.valueof(data);
    }

    @Override
    public double doubleValue() {
        return this.myNumber.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.myNumber.floatValue();
    }

    public int intValueLegacy() {
        return this.myNumber.intValue();
    }

    public long longValueLegacy() {
        return this.myNumber.longValue();
    }

    @Override
    public int intValue() {
        int value = this.isMoreThan(INT_MAX_VALUE) ? Integer.MAX_VALUE : (this.isLessThan(INT_MIN_VALUE) ? Integer.MIN_VALUE : this.myNumber.intValue());
        return value;
    }

    @Override
    public long longValue() {
        long value = this.isMoreThan(LONG_MAX_VALUE) ? Long.MAX_VALUE : (this.isLessThan(LONG_MIN_VALUE) ? Long.MIN_VALUE : this.myNumber.longValue());
        return value;
    }

    public long intValueExact() {
        if (this.isMoreThan(INT_MAX_VALUE)) {
            throw new ArithmeticException("RatingDecimal too large for a int value");
        }
        if (this.isLessThan(INT_MIN_VALUE)) {
            throw new ArithmeticException("RatingDecimal too small for a int value");
        }
        return this.myNumber.intValue();
    }

    public long longValueExact() {
        if (this.isMoreThan(LONG_MAX_VALUE)) {
            throw new ArithmeticException("RatingDecimal too large for a long value");
        }
        if (this.isLessThan(LONG_MIN_VALUE)) {
            throw new ArithmeticException("RatingDecimal too small for a long value");
        }
        return this.myNumber.longValue();
    }

    public BigDecimal bigDecimalValue(int scale, int roundingMode) {
        return this.myNumber.bigDecimalValue(scale, roundingMode);
    }

    public BigDecimal bigDecimalValue(MathContext context) {
        return this.myNumber.toBigDecimal(context);
    }

    public boolean isMinusOne() {
        return this.myNumber.compareTo(RatingDecimal.MINUS_ONE.myNumber) == 0;
    }

    public boolean isZero() {
        return this.myNumber.isZero();
    }

    public boolean isOne() {
        return this.myNumber.compareTo(RatingDecimal.ONE.myNumber) == 0;
    }

    public boolean isLessThanZero() {
        return this.myNumber.compareTo(RatingDecimal.ZERO.myNumber) < 0;
    }

    public boolean isMoreThanZero() {
        return this.myNumber.compareTo(RatingDecimal.ZERO.myNumber) > 0;
    }

    public boolean isLessThanOrEqualToZero() {
        return this.myNumber.compareTo(RatingDecimal.ZERO.myNumber) <= 0;
    }

    public boolean isMoreThanOrEqualToZero() {
        return this.myNumber.compareTo(RatingDecimal.ZERO.myNumber) >= 0;
    }

    public boolean isLessThan(RatingDecimal rvalue) {
        return this.myNumber.compareTo(rvalue.myNumber) < 0;
    }

    public boolean isMoreThan(RatingDecimal rvalue) {
        return this.myNumber.compareTo(rvalue.myNumber) > 0;
    }

    public boolean isLessThanOrEqual(RatingDecimal rvalue) {
        return this.myNumber.compareTo(rvalue.myNumber) <= 0;
    }

    public boolean isMoreThanOrEqual(RatingDecimal o) {
        return this.myNumber.compareTo(o.myNumber) >= 0;
    }

    public RatingDecimal multiply(RatingDecimal multiplicant) {
        return new RatingDecimal(this.myNumber.multiply(multiplicant.myNumber));
    }

    public RatingDecimal divide(RatingDecimal divisor) {
        return new RatingDecimal(this.myNumber.divide(divisor.myNumber));
    }

    public RatingDecimal add(RatingDecimal augend) {
        return new RatingDecimal(this.myNumber.add(augend.myNumber));
    }

    public RatingDecimal subtract(RatingDecimal subtrahend) {
        return new RatingDecimal(this.myNumber.subtract(subtrahend.myNumber));
    }

    public RatingDecimal negate() {
        return new RatingDecimal(this.myNumber.negate());
    }

    public RatingDecimal remainder(RatingDecimal divisor) {
        return new RatingDecimal(this.myNumber.remainder(divisor.myNumber));
    }

    @Override
    public int compareTo(RatingDecimal compare) {
        return this.myNumber.compareTo(compare.myNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.myNumber.equals(((RatingDecimal)obj).myNumber);
    }

    public boolean equals(RatingDecimal obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.myNumber.equals(obj.myNumber);
    }

    public int hashCode() {
        return this.myNumber.hashCode();
    }

    public RatingDecimal abs() {
        return new RatingDecimal(this.myNumber.abs());
    }

    public RatingDecimal round(int precision, int roundingMode) {
        return new RatingDecimal(this.myNumber.round(precision, roundingMode));
    }

    public String toDotString(int scale, int roundingMode) {
        return this.myNumber.toDotString(scale, roundingMode);
    }

    public String toString() {
        return this.myNumber.toString();
    }

    public byte[] toByteArray() {
        return this.myNumber.toByteArray();
    }

    public static RatingDecimal valueOf(String value, int scale) {
        return new RatingDecimal(BaseRationalNumber.valueOf(value, scale));
    }

    public boolean isWholeNumber() {
        return this.myNumber.isWholeNumber();
    }
}

