/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.migration;

import com.ericsson.ere.gui.navigator.nodeimport.ImportUtil;
import com.ericsson.ere.migration.MigrationContext;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MigrationDocumentBuilder {
    Document buildDocumentFromTariffStructure(Document originalDoc, MigrationContext ctx) {
        Document resultDoc = MigrationDocumentBuilder.createEmptyEreExportElement();
        Node orgNodes = resultDoc.adoptNode(originalDoc.getDocumentElement());
        DocumentFragment fragment = resultDoc.createDocumentFragment();
        Element serviceProviderListNode = MigrationDocumentBuilder.createElement(resultDoc, "ServiceProviderList", null);
        String[][] serviceProviderAttr = new String[][]{{"Name", ctx.getServiceProviderName()}};
        Element serviceProviderNode = MigrationDocumentBuilder.createElement(resultDoc, "ServiceProvider", serviceProviderAttr);
        String[][] ratingPlanAttr = new String[][]{{"Name", ctx.getRatingPlanName()}, {"Service", ctx.getServiceName()}};
        Element ratingPlanNode = MigrationDocumentBuilder.createElement(resultDoc, "RatingPlan", ratingPlanAttr);
        String[][] ratingPeriodAttr = new String[][]{{"Name", ctx.getRatingPeriodName()}, {"RatingStructureFile", ctx.getRatingStructureFile()}, {"StartDate", ctx.getRatingPeriodStartTime()}};
        Element ratingPeriodNode = MigrationDocumentBuilder.createElement(resultDoc, "RatingPeriod", ratingPeriodAttr);
        fragment.appendChild(serviceProviderListNode).appendChild(serviceProviderNode).appendChild(ratingPlanNode).appendChild(ratingPeriodNode).appendChild(orgNodes);
        resultDoc.getDocumentElement().setAttribute("Type", "RatingPlanNode");
        resultDoc.getDocumentElement().appendChild(fragment);
        return resultDoc;
    }

    Document buildDocumentFromRatingPlan(Document originalDoc, MigrationContext ctx) {
        Document resultDoc = MigrationDocumentBuilder.createEmptyEreExportElement();
        this.appendServiceListNode(originalDoc, resultDoc);
        DocumentFragment fragment = resultDoc.createDocumentFragment();
        Node orgNodes = resultDoc.adoptNode(originalDoc.getElementsByTagName("RatingPlan").item(0));
        Element serviceProviderListElement = MigrationDocumentBuilder.createElement(resultDoc, "ServiceProviderList", null);
        fragment.appendChild(serviceProviderListElement);
        String[][] serviceProviderAttr = new String[][]{{"Name", ctx.getServiceProviderName()}};
        Element serviceProviderNode = MigrationDocumentBuilder.createElement(resultDoc, "ServiceProvider", serviceProviderAttr);
        fragment.appendChild(serviceProviderListElement).appendChild(serviceProviderNode).appendChild(orgNodes);
        resultDoc.getDocumentElement().setAttribute("Type", originalDoc.getDocumentElement().getAttribute("Type"));
        resultDoc.getDocumentElement().appendChild(fragment);
        return resultDoc;
    }

    Document buildDocumentFromServiceProvider(Document originalDoc) {
        Document resultDoc = MigrationDocumentBuilder.createEmptyEreExportElement();
        this.appendServiceListNode(originalDoc, resultDoc);
        DocumentFragment fragment = resultDoc.createDocumentFragment();
        Node originalServiceProviderNodes = resultDoc.adoptNode(originalDoc.getElementsByTagName("ServiceProvider").item(0));
        Element serviceProviderListElement = MigrationDocumentBuilder.createElement(resultDoc, "ServiceProviderList", null);
        fragment.appendChild(serviceProviderListElement);
        fragment.appendChild(serviceProviderListElement).appendChild(originalServiceProviderNodes);
        resultDoc.getDocumentElement().setAttribute("Type", originalDoc.getDocumentElement().getAttribute("Type"));
        resultDoc.getDocumentElement().appendChild(fragment);
        return resultDoc;
    }

    Document buildDocumentFromRatingPeriod(Document originalDoc, MigrationContext ctx) {
        Document resultDoc = MigrationDocumentBuilder.createEmptyEreExportElement();
        this.appendServiceListNode(originalDoc, resultDoc);
        DocumentFragment fragment = resultDoc.createDocumentFragment();
        Element serviceProviderListElement = MigrationDocumentBuilder.createElement(resultDoc, "ServiceProviderList", null);
        fragment.appendChild(serviceProviderListElement);
        String[][] serviceProviderAttr = new String[][]{{"Name", ctx.getServiceProviderName()}};
        Element serviceProviderNode = MigrationDocumentBuilder.createElement(resultDoc, "ServiceProvider", serviceProviderAttr);
        String[][] ratingPlanAttr = new String[][]{{"Name", ctx.getRatingPlanName()}, {"Service", ctx.getServiceName()}};
        Element ratingPlanNode = MigrationDocumentBuilder.createElement(resultDoc, "RatingPlan", ratingPlanAttr);
        Node node = fragment.appendChild(serviceProviderListElement).appendChild(serviceProviderNode).appendChild(ratingPlanNode);
        NodeList orgNodes = originalDoc.getElementsByTagName("RatingPeriod");
        for (int i = 0; i < orgNodes.getLength(); ++i) {
            Node tmp = resultDoc.adoptNode(orgNodes.item(i));
            node.appendChild(tmp);
        }
        resultDoc.getDocumentElement().setAttribute("Type", originalDoc.getDocumentElement().getAttribute("Type"));
        resultDoc.getDocumentElement().appendChild(fragment);
        return resultDoc;
    }

    private void appendServiceListNode(Document originalDoc, Document resultDoc) {
        NodeList originalServiceListNodes = originalDoc.getElementsByTagName("ServiceList");
        if (originalServiceListNodes != null && originalServiceListNodes.getLength() > 0) {
            Node serviceListNode = originalServiceListNodes.item(0);
            resultDoc.adoptNode(serviceListNode);
            resultDoc.getDocumentElement().appendChild(serviceListNode);
        }
    }

    Document buildDocumentFromRatingManager(Document originalDoc) {
        Document resultDoc = MigrationDocumentBuilder.createEmptyEreExportElement();
        DocumentFragment fragment = resultDoc.createDocumentFragment();
        Node orgServiceListNodes = resultDoc.adoptNode(originalDoc.getElementsByTagName("ServiceList").item(0));
        Node orgServiceProviderListNodes = resultDoc.adoptNode(originalDoc.getElementsByTagName("ServiceProviderList").item(0));
        fragment.appendChild(orgServiceListNodes);
        fragment.appendChild(orgServiceProviderListNodes);
        resultDoc.getDocumentElement().setAttribute("Type", originalDoc.getDocumentElement().getAttribute("Type"));
        resultDoc.getDocumentElement().appendChild(fragment);
        return resultDoc;
    }

    Document buildDocumentFromService(Document originalDoc) {
        Document resultDoc = MigrationDocumentBuilder.createEmptyEreExportElement();
        DocumentFragment fragment = resultDoc.createDocumentFragment();
        Node orgNodes = resultDoc.adoptNode(originalDoc.getElementsByTagName("Service").item(0));
        Element serviceProviderListElement = MigrationDocumentBuilder.createElement(resultDoc, "ServiceList", null);
        fragment.appendChild(serviceProviderListElement);
        fragment.appendChild(serviceProviderListElement).appendChild(orgNodes);
        resultDoc.getDocumentElement().setAttribute("Type", originalDoc.getDocumentElement().getAttribute("Type"));
        resultDoc.getDocumentElement().appendChild(fragment);
        return resultDoc;
    }

    Document buildDocumentFromFloatingServiceElement(Document originalDoc) {
        Document resultDoc = MigrationDocumentBuilder.createEmptyDocument();
        Node nodes = originalDoc.getDocumentElement().cloneNode(true);
        resultDoc.adoptNode(nodes);
        resultDoc.appendChild(nodes);
        List<Node> floatingServiceNodes = ImportUtil.getFlotingServiceElements(resultDoc);
        for (Node floatingNode : floatingServiceNodes) {
            resultDoc.getDocumentElement().removeChild(floatingNode);
        }
        NodeList serviceListNodeList = resultDoc.getElementsByTagName("ServiceList");
        if (serviceListNodeList != null && serviceListNodeList.getLength() > 0) {
            Node serviceListNode = serviceListNodeList.item(0);
            for (Node floatingNode : floatingServiceNodes) {
                serviceListNode.appendChild(floatingNode);
            }
        }
        return resultDoc;
    }

    private static Element createElement(Document doc, String nodeName, String[] ... attributes) {
        Element node = doc.createElement(nodeName);
        if (attributes != null && attributes[0] != null) {
            for (String[] attr : attributes) {
                node.setAttribute(attr[0], attr[1]);
            }
        }
        return node;
    }

    private static Document createEmptyEreExportElement() {
        Document resultDoc = MigrationDocumentBuilder.createEmptyDocument();
        Element rootElement = MigrationDocumentBuilder.createElement(resultDoc, "EreExport", new String[][]{null});
        resultDoc.appendChild(rootElement);
        return resultDoc;
    }

    private static Document createEmptyDocument() throws IllegalStateException {
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fac.newDocumentBuilder();
            return builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Failed to create root document", e);
        }
    }

    public Document buildDocumentFromServiceDefinition(Document originalDoc, MigrationContext ctx) {
        Document resultDoc = MigrationDocumentBuilder.createEmptyEreExportElement();
        DocumentFragment fragment = resultDoc.createDocumentFragment();
        Node orgNodes = resultDoc.adoptNode(originalDoc.getElementsByTagName("ServiceDefinition").item(0));
        Element serviceProviderListElement = MigrationDocumentBuilder.createElement(resultDoc, "ServiceList", null);
        String[][] serviceNameAttr = new String[][]{{"Name", ctx.getServiceName()}};
        Element serviceElement = MigrationDocumentBuilder.createElement(resultDoc, "Service", serviceNameAttr);
        fragment.appendChild(serviceProviderListElement).appendChild(serviceElement).appendChild(orgNodes);
        resultDoc.getDocumentElement().setAttribute("Type", "ServiceList");
        resultDoc.getDocumentElement().appendChild(fragment);
        return resultDoc;
    }
}

