/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.dataset.jump.JumpContext;
import com.ericsson.ere.proxy.ActiveListProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.ProgressWrapper;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.SavedListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.management.RatingPlan;
import org.w3c.dom.Element;

public class ActiveSavedRatingPlanProxy
extends RatingPlanProxy {
    protected transient SavedListProxy savedListProxy;
    protected transient ActiveListProxy activeListProxy;

    public ActiveSavedRatingPlanProxy(AbstractConnector conn, ServiceProviderProxy parentProxy, String ratingPlanName) {
        super(conn, parentProxy, ratingPlanName);
    }

    @Override
    public SavedListProxy getSavedListProxy() {
        return this.savedListProxy;
    }

    @Override
    public ActiveListProxy getActiveListProxy() {
        return this.activeListProxy;
    }

    public void setSavedListProxy(SavedListProxy savedListProxy) {
        this.savedListProxy = savedListProxy;
    }

    public void setActiveListProxy(ActiveListProxy activeListProxy) {
        this.activeListProxy = activeListProxy;
    }

    @Override
    public void refresh() {
        String name = this.getName();
        ProgressWrapper progress = EreProxyManager.getInstance().getProgressWrapper();
        progress.setInfo("Building RatingPlan: " + name);
        this.myEreSettings = new SettingsMap();
        String ratingPlanService = "UNDEFINED";
        try {
            Element rpElement = this.connector.getRatingPlanElement(this.parentProxy.getName(), name);
            ratingPlanService = rpElement.getAttribute("Service");
            this.setName(name);
            this.myEreSettings.setParameter("Service", ratingPlanService, 1, true);
            if (this.activeListProxy == null && this.savedListProxy == null) {
                this.setActiveListProxy(new ActiveListProxy(this.connector, this, name));
                this.setSavedListProxy(new SavedListProxy(this.connector, this, name));
            } else {
                this.getActiveListProxy().refresh();
                this.getSavedListProxy().refresh();
            }
            progress.progressIncrement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int validateDate(String startDate) {
        return 0;
    }

    @Override
    public RatingPlan getRatingPlanObject(JumpContext jctx) {
        RatingPlan plan = this.constructRatingPlanObject(jctx);
        return this.populateRatingPlanObject(plan, jctx, this.activeListProxy.getRatingPeriodList());
    }

    @Override
    public RatingPeriodProxy getRatingPeriodProxy(String ratingPeriodName, String startTime) {
        RatingPeriodProxy proxy = this.savedListProxy.getRatingPeriod(ratingPeriodName, startTime);
        return proxy;
    }

    @Override
    public boolean hasActiveAndSavedPeriods() {
        return this.savedListProxy != null || this.activeListProxy != null;
    }
}

