/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import ericsson.ere.progress.ProgressIndicator;

public class ProgressWrapper {
    private ProgressIndicator progressIndicator = null;

    public ProgressWrapper(ProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    public ProgressWrapper() {
    }

    public ProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    public void progressIncrement() {
        if (this.progressIndicator == null) {
            return;
        }
        this.progressIndicator.progressIncrement();
    }

    public void progressFinished() {
        if (this.progressIndicator == null) {
            return;
        }
        this.progressIndicator.progressFinished();
    }

    public void progressStart() {
        if (this.progressIndicator == null) {
            return;
        }
        this.progressIndicator.progressStart();
    }

    public void progressStart(int goal) {
        if (this.progressIndicator == null) {
            return;
        }
        this.progressIndicator.progressStart(goal);
    }

    public void setInfo(String message) {
        if (this.progressIndicator == null) {
            return;
        }
        this.progressIndicator.setInfo(message);
    }

    public ProgressWrapper[] splitProgress(int slices) {
        ProgressWrapper[] newWrappers = new ProgressWrapper[slices];
        ProgressIndicator[] newSlices = null;
        if (this.progressIndicator != null) {
            newSlices = this.progressIndicator.splitProgress(slices);
        }
        for (int i = 0; i < newWrappers.length; ++i) {
            newWrappers[i] = this.progressIndicator != null ? new ProgressWrapper(newSlices[i]) : new ProgressWrapper();
        }
        return newWrappers;
    }

    public ProgressWrapper[] splitProgress(int[] slices) {
        ProgressWrapper[] newWrappers = new ProgressWrapper[slices.length];
        ProgressIndicator[] newSlices = null;
        if (this.progressIndicator != null) {
            newSlices = this.progressIndicator.splitProgress(slices);
        }
        for (int i = 0; i < newWrappers.length; ++i) {
            newWrappers[i] = this.progressIndicator != null ? new ProgressWrapper(newSlices[i]) : new ProgressWrapper();
        }
        return newWrappers;
    }
}

