/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.util.FieldDefinitionUtil;
import com.ericsson.ere.util.Location;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.vareditor.variable.BitPatternVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.Variable;

public abstract class AbstractBaseConditionProfile
extends AbstractConditionProfileV2 {
    protected ClassRepository myRepository;

    protected FieldDefinition getFieldDefinition() {
        assert (this.myRepository != null);
        FieldDefinition fieldDefinition = this.myRepository.getFieldDefinitionByName(this.getFieldName());
        return fieldDefinition;
    }

    protected Variable createInputVariable(String label, String key, String defaultValue, DataType dataType) {
        Variable var;
        try {
            FieldDefinition fieldDefinition = this.getFieldDefinition();
            assert (fieldDefinition != null);
            var = VariableFactory.createInputVariable(label, key, this.getFieldDefinition(), this.myRepository, defaultValue, Location.SELECTION_TREE, dataType);
        }
        catch (Exception e) {
            long logNum = ExceptionUtil.handleException(e, "ratingRuleFrame", 1, "The base condition profile failed to create variables.", false);
            String msg = String.format("Failed to create variable. Please see log entry %d for more information.", logNum);
            var = new NotAllowedVariable(label, msg);
        }
        return var;
    }

    @Override
    public String getFieldName() {
        String fieldName = this.isMapped() ? this.myRepository.getConditionFieldName(this.getName()) : super.getFieldName();
        return fieldName;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        super.setClassRepository(repository);
        this.myRepository = repository;
    }

    @Override
    public boolean needsRepository() {
        return true;
    }

    protected boolean supportsInequalityOperators(Variable inputVariable) {
        return !(inputVariable instanceof DropDownVariable) && !(inputVariable instanceof BitPatternVariable);
    }

    protected String makeDisplayString(String value, DataType dataType) {
        Object valueObject = null;
        if (dataType == null) {
            ValueResolver resolver = FieldDefinitionUtil.createValueResolver(this.myRepository, this.getFieldDefinition());
            valueObject = resolver.parseValueString(value);
        } else {
            valueObject = dataType.parseValue(value);
        }
        DefaultDataDescriber desc = new DefaultDataDescriber();
        FieldDefinition def = this.getFieldDefinition();
        String displayString = def != null ? desc.describeObject(valueObject, def) : desc.describeObject(valueObject, dataType);
        return displayString;
    }
}

