/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import com.ericsson.ere.interfaces.NamedClassProfile;
import com.ericsson.ere.interfaces.ProductTagClassProfile;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.ratingrules.nodes.TSElementProductTagSupport;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.ClassProfile;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.List;

public abstract class AbstractClassProfile
implements ClassProfile,
NamedClassProfile,
ProductTagClassProfile {
    private static final String TAG_COMMENT = "Comment";
    protected String myName;
    private String myTag;
    private boolean myUseComment;

    protected AbstractClassProfile(String tag, boolean useComment) {
        this.myTag = tag;
        this.myUseComment = useComment;
    }

    @Override
    public void setName(String aName) {
        this.myName = aName;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public boolean supportsProductTag(ClassRepository repository, List<Variable> stateVariables) {
        return TSElementProductTagSupport.hasConfigurationClass(repository, this);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = null;
        if (variables != null) {
            name = VarListUtil.getValueStringForKey(variables, "Name");
        }
        if (name == null) {
            name = this.getName();
        }
        return name != null ? name : "";
    }

    @Override
    public String getDescription() {
        return null;
    }

    public String getComment(List<Variable> variables) {
        String comment = VarListUtil.getValueStringForKey(variables, TAG_COMMENT);
        if (comment == null) {
            comment = "";
        }
        return comment;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String info = "<b>" + this.getDescription(variables) + "</b>\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public String getAdditionalInfo() {
        return null;
    }

    @Override
    public void printParameters(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        this.printName(out, variables);
        out.println();
        this.printCommentConditionally(out, indentLevel + 1, indentMarker, variables);
        this.printParametersImpl(out, indentLevel, indentMarker, variables);
    }

    protected void printName(PrintWriter out, List<Variable> variables) {
        String name = VarListUtil.getValueStringForKey(variables, "Name");
        if (name != null) {
            out.print(XMLUtil.escape(name));
        }
    }

    protected void printCommentConditionally(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String comment;
        if (this.myUseComment && !StringUtil.isEmptyString(comment = VarListUtil.getValueStringForKey(variables, TAG_COMMENT))) {
            out.print(this.indentation(indentLevel, indentMarker));
            out.print(XMLUtil.wrapInTag(TAG_COMMENT, comment));
        }
    }

    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
    }

    @Override
    public void printPreamble(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String id = VarListUtil.getValueStringForKey(variables, "Id");
        id = id != null ? id.trim() : null;
        out.print(this.indentation(indentLevel, indentMarker));
        out.print("<");
        out.print(this.myTag);
        out.print(XMLUtil.wrapInAttribute("id", id));
        TSElementProductTagSupport.printProductTagAsXMLAttribute(out, variables);
        this.printAdditionalPreamble(out, indentLevel, indentMarker, variables);
        out.print(">");
    }

    protected void printAdditionalPreamble(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
    }

    @Override
    public void printPostamble(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        out.print(this.indentation(indentLevel, indentMarker));
        out.print("</");
        out.print(this.myTag);
        out.println(">");
    }

    protected final String indentation(int indentLevel, String indentMarker) {
        return StringUtil.repeat(indentMarker, indentLevel);
    }

    @Override
    public boolean needsRepository() {
        return false;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
    }

    @Override
    public void setTariffStructureNode(DAGNode tariffStructureNode) {
    }
}

