/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.interfaces.ConfigurationParameter;
import com.ericsson.ere.selectiontree.interfaces.PluginConfiguration;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import ericsson.ere.util.StringUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AnnotationBasedPluginConfiguration
implements PluginConfiguration {
    private Map<String, ConfigurationParameter> myParameters;
    private final String myTypeName;

    protected AnnotationBasedPluginConfiguration(ParseContext ctx) {
        this.myTypeName = ctx != null ? PluginConfigurationHelper.getElementTypeName(ctx.getClassRepository(), ctx.getXMLNode(), true) : null;
    }

    @Override
    public String getTypeName() {
        return this.myTypeName;
    }

    protected Map<String, ConfigurationParameter> discoverParameters() {
        String propName;
        HashMap<String, ConfigurationParameter> params = new HashMap<String, ConfigurationParameter>();
        Method[] publicMethods = this.getClass().getMethods();
        HashMap<String, Method> getterMethods = new HashMap<String, Method>();
        HashMap<String, Method> setterMethods = new HashMap<String, Method>();
        for (Method method : publicMethods) {
            if (method.isAnnotationPresent(ParameterGetter.class)) {
                if (method.getParameterTypes().length != 0) {
                    throw new IllegalStateException("Found getter with parameters: " + method);
                }
                if (method.getReturnType() == Void.TYPE) {
                    throw new IllegalStateException("Found void getter: " + method);
                }
                propName = method.getAnnotation(ParameterGetter.class).parameterName();
                getterMethods.put(propName, method);
                continue;
            }
            if (!method.isAnnotationPresent(ParameterSetter.class)) continue;
            if (method.getParameterTypes().length != 1) {
                throw new IllegalStateException("Found setter without parameter: " + method);
            }
            if (method.getReturnType() != Void.TYPE) {
                throw new IllegalStateException("Found non-void setter: " + method);
            }
            propName = method.getAnnotation(ParameterSetter.class).parameterName();
            setterMethods.put(propName, method);
        }
        for (Map.Entry entry : getterMethods.entrySet()) {
            propName = (String)entry.getKey();
            Method getter = (Method)entry.getValue();
            Class<?> propType = getter.getReturnType();
            Method setter = (Method)setterMethods.get(propName);
            if (setter != null) {
                Class<?> setterType = setter.getParameterTypes()[0];
                if (setterType != propType) {
                    throw new IllegalStateException("Setter is not compatible with the corresponding getter: " + setter);
                }
                setterMethods.remove(propName);
            }
            params.put(propName, new ConfigurationParameterImpl(propName, getter, setter));
        }
        Iterator iterator = setterMethods.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            throw new IllegalStateException("Found setter without corresponding getter: " + entry.getValue());
        }
        return params;
    }

    @Override
    public Object getParameterValue(String name) {
        ConfigurationParameterImpl cpi = this.findConfigurationParameter(name);
        return this.invokeMethodOnThis(cpi.getter, new Object[0]);
    }

    @Override
    public Collection<ConfigurationParameter> getParameters() {
        this.ensureParameters();
        return Collections.unmodifiableCollection(this.myParameters.values());
    }

    @Override
    public void setParameterValue(String name, Object value) {
        ConfigurationParameterImpl cpi = this.findConfigurationParameter(name);
        if (cpi.isReadOnly()) {
            throw new IllegalArgumentException("Parameter is read only: " + name);
        }
        this.invokeMethodOnThis(cpi.setter, value);
    }

    private ConfigurationParameterImpl findConfigurationParameter(String name) {
        this.ensureParameters();
        ConfigurationParameter c = this.myParameters.get(name);
        if (c == null) {
            throw new IllegalArgumentException("Unknown parameter: " + name);
        }
        return (ConfigurationParameterImpl)c;
    }

    private void ensureParameters() {
        if (this.myParameters == null) {
            this.myParameters = this.discoverParameters();
            this.verifyParameterTypes();
        }
    }

    private void verifyParameterTypes() {
        for (ConfigurationParameter p : this.myParameters.values()) {
            if (p instanceof ConfigurationParameterImpl) continue;
            throw new IllegalArgumentException("Configuration parameter " + p.getName() + " has an invalid type, must be ConfigurationParameterImpl.");
        }
    }

    private Object invokeMethodOnThis(Method m, Object ... args) {
        try {
            return m.invoke((Object)this, args);
        }
        catch (IllegalAccessException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    protected static class ConfigurationParameterImpl
    implements ConfigurationParameter {
        private final String myName;
        private final String myDisplayName;
        final Method getter;
        final Method setter;

        protected ConfigurationParameterImpl(String name, Method getter, Method setter) {
            this.myName = name;
            this.getter = getter;
            this.setter = setter;
            assert (getter.isAnnotationPresent(ParameterGetter.class));
            String dispName = getter.getAnnotation(ParameterGetter.class).displayName();
            this.myDisplayName = dispName = StringUtil.isEmptyString(dispName) ? name : dispName;
        }

        protected ConfigurationParameterImpl(ConfigurationParameter param) {
            if (!(param instanceof ConfigurationParameterImpl)) {
                throw new IllegalArgumentException("Expected a ConfigurationParameterImpl instance.");
            }
            this.myName = param.getName();
            this.myDisplayName = param.getDisplayName();
            this.getter = ((ConfigurationParameterImpl)param).getter;
            this.setter = ((ConfigurationParameterImpl)param).setter;
        }

        @Override
        public String getDisplayName() {
            return this.myDisplayName;
        }

        @Override
        public String getName() {
            return this.myName;
        }

        @Override
        public Class<?> getOwnerClass() {
            return this.getter.getDeclaringClass();
        }

        @Override
        public Class<?> getType() {
            return this.getter.getReturnType();
        }

        @Override
        public boolean isReadOnly() {
            return this.setter == null;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface ParameterSetter {
        public String parameterName();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface ParameterGetter {
        public String parameterName();

        public String displayName() default "";
    }
}

