/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import ericsson.ere.interfaces.DAGNode;

public abstract class Applicable<T> {
    private final Class<T> targetClass_;

    public Applicable(Class<T> cls) {
        this.targetClass_ = cls;
    }

    public abstract void apply(T var1);

    public final void traversePreorder(DAGNode n) {
        if (this.targetClass_.isAssignableFrom(n.getClass())) {
            T element = this.targetClass_.cast(n);
            this.apply(element);
        }
        int len = n.getChildCount();
        for (int i = 0; i < len; ++i) {
            this.traversePreorder(n.getChildAt(i));
        }
    }

    public final void traversePostorder(DAGNode n) {
        int len = n.getChildCount();
        for (int i = 0; i < len; ++i) {
            this.traversePostorder(n.getChildAt(i));
        }
        if (this.targetClass_.isAssignableFrom(n.getClass())) {
            T element = this.targetClass_.cast(n);
            this.apply(element);
        }
    }
}

