/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.interfaces.ConfigurationParameter;
import com.ericsson.ere.selectiontree.interfaces.PluginConfiguration;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import ericsson.ere.util.StringUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class BeanBasedPluginConfiguration
implements PluginConfiguration {
    private Map<String, ConfigurationParameter> myParameterMap;
    private final String myTypeName;

    protected BeanBasedPluginConfiguration(ParseContext ctx) {
        this.myTypeName = ctx != null ? PluginConfigurationHelper.getElementTypeName(ctx.getClassRepository(), ctx.getXMLNode(), true) : null;
    }

    @Override
    public String getTypeName() {
        return this.myTypeName;
    }

    @Override
    public Object getParameterValue(String name) {
        PropertyDescriptor pd = this.findPropertyDescriptor(name);
        return this.invokeMethodOnThis(pd.getReadMethod(), new Object[0]);
    }

    @Override
    public Collection<ConfigurationParameter> getParameters() {
        this.ensureParameterMap();
        return Collections.unmodifiableCollection(this.myParameterMap.values());
    }

    @Override
    public void setParameterValue(String name, Object value) {
        PropertyDescriptor pd = this.findPropertyDescriptor(name);
        this.invokeMethodOnThis(pd.getWriteMethod(), value);
    }

    private Object invokeMethodOnThis(Method m, Object ... args) {
        try {
            return m.invoke((Object)this, args);
        }
        catch (IllegalArgumentException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (IllegalAccessException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private PropertyDescriptor findPropertyDescriptor(String name) {
        this.ensureParameterMap();
        ConfigurationParameter param = this.myParameterMap.get(name);
        if (param == null) {
            throw new IllegalArgumentException("Unknown parameter: " + name);
        }
        return ((PropertyDescriptorBasedConfigurationParameter)param).myProp;
    }

    private void ensureParameterMap() {
        if (this.myParameterMap == null) {
            PropertyDescriptor[] props;
            BeanInfo info;
            this.myParameterMap = new HashMap<String, ConfigurationParameter>();
            try {
                info = this.getBeanInfo();
            }
            catch (IntrospectionException ex) {
                throw new RuntimeException(ex);
            }
            for (PropertyDescriptor prop : props = info.getPropertyDescriptors()) {
                if (prop.isHidden() || prop.getReadMethod() == null) continue;
                this.myParameterMap.put(prop.getName(), new PropertyDescriptorBasedConfigurationParameter(prop, this.getClass()));
            }
        }
    }

    protected BeanInfo getBeanInfo() throws IntrospectionException {
        return Introspector.getBeanInfo(this.getClass(), BeanBasedPluginConfiguration.class);
    }

    private static class PropertyDescriptorBasedConfigurationParameter
    implements ConfigurationParameter {
        private PropertyDescriptor myProp;
        private Class<?> myOwner;
        private String myDisplayName;

        PropertyDescriptorBasedConfigurationParameter(PropertyDescriptor input, Class<?> owner) {
            this.myProp = input;
            this.myOwner = owner;
            this.myDisplayName = this.getDisplayName(input);
        }

        private String getDisplayName(PropertyDescriptor input) {
            String name = input.getName();
            String dispName = input.getDisplayName();
            if (dispName.equals(name)) {
                dispName = StringUtil.getDisplayStringFromCamelCaseString(name);
            }
            return dispName;
        }

        @Override
        public String getDisplayName() {
            return this.myDisplayName;
        }

        @Override
        public String getName() {
            return this.myProp.getName();
        }

        @Override
        public Class<?> getOwnerClass() {
            return this.myOwner;
        }

        @Override
        public Class<?> getType() {
            return this.myProp.getPropertyType();
        }

        @Override
        public boolean isReadOnly() {
            return this.myProp.getWriteMethod() == null;
        }
    }
}

