/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import com.ericsson.ere.util.Transformer;
import ericsson.ere.interfaces.TariffStructureConstants;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ElementConfigurationHelper {
    private ElementConfigurationHelper() {
    }

    public static List<Node> getTreeChildren(Node node) {
        List<String> treeTags = Arrays.asList(TariffStructureConstants.TREE_TAGS);
        NodeList children = node.getChildNodes();
        ArrayList<Node> treeChildren = new ArrayList<Node>(children.getLength());
        for (Node child : new NodeListIterable(children, 1)) {
            if (!treeTags.contains(child.getNodeName())) continue;
            treeChildren.add(child);
        }
        return treeChildren;
    }

    public static boolean isXMLConfigConnectedToParent(TariffStructureNode element, ConfigExtractor extractor) {
        TariffStructureNode parent = (TariffStructureNode)element.getParent();
        assert (parent != null) : "Element must have a parent.";
        Node parentNode = ElementConfigurationHelper.getXMLConfig(parent, extractor);
        assert (parentNode != null) : "Parent is supposed to have a DOM node.";
        return ElementConfigurationHelper.getXMLConfig(element, extractor).getParentNode() == parentNode;
    }

    public static void removeDOMFromParent(TariffStructureNode element, ConfigExtractor extractor) {
        Node configXml = ElementConfigurationHelper.getXMLConfig(element, extractor);
        if (configXml == null || ElementConfigurationHelper.isParentLess(element)) {
            return;
        }
        TariffStructureNode parent = (TariffStructureNode)element.getParent();
        Node parentXml = ElementConfigurationHelper.getXMLConfig(parent, extractor);
        if (parentXml != null && configXml.getParentNode() == parentXml) {
            parentXml.removeChild(configXml);
        }
    }

    public static boolean isParentLess(TariffStructureNode element) {
        return element.getParent() == null;
    }

    public static Node insertNodeInDocument(TariffStructureNode element, Node n, ConfigExtractor extractor) {
        Node xmlToInsert = n;
        TariffStructureNode parent = (TariffStructureNode)element.getParent();
        Node xmlOfParent = ElementConfigurationHelper.getXMLConfig(parent, extractor);
        if (xmlOfParent != null) {
            Node xmlOfElement;
            if (xmlOfParent.getOwnerDocument() != xmlToInsert.getOwnerDocument()) {
                xmlToInsert = XMLUtil.adoptNode(xmlOfParent.getOwnerDocument(), xmlToInsert);
            }
            if ((xmlOfElement = ElementConfigurationHelper.getXMLConfig(element, extractor)) != null && xmlOfElement.getParentNode() == xmlOfParent) {
                xmlOfParent.replaceChild(xmlToInsert, xmlOfElement);
            } else {
                List<Node> existingChildren;
                int index = element.getParent().getIndexOfChild(element);
                if (index >= (existingChildren = ElementConfigurationHelper.getTreeChildren(xmlOfParent)).size()) {
                    xmlOfParent.appendChild(xmlToInsert);
                } else {
                    Node child = existingChildren.get(index);
                    xmlOfParent.insertBefore(xmlToInsert, child);
                }
            }
        }
        return xmlToInsert;
    }

    public static Node adoptIntoDocumentOfElement(TariffStructureNode element, Node n, ConfigExtractor extractor) {
        Node orphan = n;
        Node reference = ElementConfigurationHelper.getXMLConfig(element, extractor);
        if (reference == null && !ElementConfigurationHelper.isParentLess(element)) {
            reference = ElementConfigurationHelper.getXMLConfig((TariffStructureNode)element.getParent(), extractor);
        }
        if (reference != null) {
            orphan = XMLUtil.adoptNode(reference.getOwnerDocument(), orphan);
        }
        return orphan;
    }

    public static void ensureXMLConfigPositionInParent(TariffStructureNode element, ConfigExtractor extractor) {
        Node elementXML;
        Node parentXML;
        List<Node> treeChildren;
        int xmlIndex;
        TariffStructureNode parent = (TariffStructureNode)element.getParent();
        int elementIndex = parent.getIndexOfChild(element);
        if (elementIndex != (xmlIndex = (treeChildren = ElementConfigurationHelper.getTreeChildren(parentXML = (elementXML = ElementConfigurationHelper.getXMLConfig(element, extractor)).getParentNode())).indexOf(elementXML))) {
            int referenceIndex = elementIndex;
            if (xmlIndex < elementIndex) {
                referenceIndex = elementIndex + 1;
            }
            boolean moveLast = referenceIndex >= parent.getChildCount();
            Node reference = moveLast ? null : treeChildren.get(referenceIndex);
            parentXML.insertBefore(elementXML, reference);
        }
    }

    private static Node getXMLConfig(TariffStructureNode tn, ConfigExtractor extractor) {
        return (Node)extractor.transform(tn);
    }

    public static interface ConfigExtractor
    extends Transformer<TariffStructureNode, Node> {
    }
}

