/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import com.ericsson.ere.annotations.jcip.Immutable;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Immutable
public class IdMapSupport {
    private final Map<String, TariffStructureNode> uniqueNodes_;
    private final Set<String> duplicates_;

    public static IdMapSupport create(Collection<TariffStructureNode> c) {
        HashMap<String, TariffStructureNode> nodes = new HashMap<String, TariffStructureNode>();
        HashSet<String> duplicates = new HashSet();
        for (TariffStructureNode n : c) {
            String id = n.getNodeId();
            if (duplicates.contains(id)) continue;
            if (nodes.containsKey(id)) {
                nodes.remove(id);
                duplicates.add(id);
                continue;
            }
            nodes.put(id, n);
        }
        if (duplicates.isEmpty()) {
            duplicates = Collections.emptySet();
        }
        return new IdMapSupport(nodes, duplicates);
    }

    private IdMapSupport(Map<String, TariffStructureNode> uniques, Set<String> ambigous) {
        this.uniqueNodes_ = uniques;
        this.duplicates_ = ambigous;
    }

    public IdMapSupport() {
        this(new HashMap<String, TariffStructureNode>(), new HashSet<String>());
    }

    public TariffStructureNode getUniqueNode(String id) {
        if (this.duplicates_.contains(id)) {
            throw new IllegalArgumentException("Ambigous node id: " + id);
        }
        return this.uniqueNodes_.get(id);
    }
}

