/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.executor.TreeExecutorHelper;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ConditionTestResult;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.interfaces.ResultConditionality;
import com.ericsson.ere.trace.TraceNodeCondition;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.Traceable;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.ClassRepositoryUtil;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.AbstractDAGNode;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import ericsson.ere.interfaces.UsedFieldLister;
import ericsson.ere.xml.XMLUtil;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class ImmutableCondition
extends AbstractDAGNode
implements Conditionality,
TariffStructureNode,
Traceable,
UsedFieldLister {
    protected final String conditionName;
    protected final String key;
    protected final int tag;
    protected final boolean tagIsSet;
    protected final String myNodeId;
    protected final String myAlias;

    protected ImmutableCondition(ParseContext ctx) {
        this(ctx, null);
    }

    protected ImmutableCondition(ParseContext ctx, String keyOverride) {
        Node node;
        if (ctx == null) {
            this.conditionName = null;
            this.key = null;
            this.tag = 0;
            this.tagIsSet = false;
            this.myNodeId = null;
            this.myAlias = null;
            return;
        }
        ClassRepository rep = ctx.getClassRepository();
        Node iterator = ctx.getXMLNode();
        String name = XMLUtil.getFirstTextContent(iterator);
        this.conditionName = name.intern();
        String fieldKey = keyOverride != null ? keyOverride : (rep != null ? rep.getConditionFieldName(name) : null);
        FieldDefinition def = rep != null ? rep.getFieldDefinitionByName(fieldKey) : null;
        this.key = def == null ? fieldKey : def.getCanonicalName();
        int tagValue = 0;
        boolean usingTags = false;
        if (def != null && def.usesTagNumber()) {
            tagValue = def.getTagNumber();
            usingTags = true;
        }
        this.tag = tagValue;
        this.tagIsSet = usingTags;
        String id = null;
        NamedNodeMap attr = null;
        if (iterator.hasAttributes()) {
            attr = iterator.getAttributes();
        }
        if (attr != null && (node = attr.getNamedItem("id")) != null) {
            id = node.getNodeValue().trim().replace('/', '\\');
        }
        this.myNodeId = id;
        this.myAlias = rep != null ? rep.getAliasForCondition(name) : null;
    }

    protected ImmutableCondition(String pconditionName, String pkey, int ptag, boolean ptagIsSet, String nodeId, String alias) {
        this.conditionName = pconditionName;
        this.key = pkey;
        this.tag = ptag;
        this.tagIsSet = ptagIsSet;
        this.myNodeId = nodeId;
        this.myAlias = alias;
    }

    public String getAlias() {
        return this.myAlias;
    }

    @Override
    protected int hashCodeImpl() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.conditionName == null ? 0 : this.conditionName.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.myAlias == null ? 0 : this.myAlias.hashCode());
        result = 31 * result + (this.myNodeId == null ? 0 : this.myNodeId.hashCode());
        result = 31 * result + this.tag;
        result = 31 * result + (this.tagIsSet ? 1231 : 1237);
        return result;
    }

    @Override
    protected boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableCondition other = (ImmutableCondition)obj;
        if (this.conditionName == null ? other.conditionName != null : !this.conditionName.equals(other.conditionName)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.myAlias == null ? other.myAlias != null : !this.myAlias.equals(other.myAlias)) {
            return false;
        }
        if (this.myNodeId == null ? other.myNodeId != null : !this.myNodeId.equals(other.myNodeId)) {
            return false;
        }
        if (this.tag != other.tag) {
            return false;
        }
        return this.tagIsSet == other.tagIsSet;
    }

    @Override
    public String getTypename() {
        return this.getConditionName();
    }

    public String getConditionName() {
        return this.conditionName;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public long getConditionSatisfiedDuration(DataSet theData) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getConditionUnsatisfiedDuration(DataSet theData) {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("Condition has no children");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public void insertChildAt(int index, DAGNode node) throws IndexOutOfBoundsException, IllegalArgumentException {
        throw new IndexOutOfBoundsException("Condition may not have any children");
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) throws IndexOutOfBoundsException, IllegalArgumentException {
        throw new IndexOutOfBoundsException("Condition may not have any children");
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        throw new IllegalArgumentException("Child not found: " + child);
    }

    @Override
    protected void removeChild(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public int getNodeType() {
        return 2;
    }

    @Override
    public String getNodeId() {
        String id = this.myNodeId;
        if (id == null || "".equals(id.trim())) {
            id = this.getTypename();
        }
        id = id.replace('/', '\\');
        return id;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public void startVisit(TariffStructureVisitor v) throws Exception {
        v.enterCondition(this);
    }

    @Override
    public void endVisit(TariffStructureVisitor v) throws Exception {
        v.leaveCondition(this);
    }

    @Override
    public TariffStructureNode createTraceNode(int childIndex, TraceNodeInterface parent) {
        TraceNodeCondition tnc = null;
        tnc = new TraceNodeCondition(this);
        tnc.setParent(parent);
        parent.addChild(tnc);
        tnc.setChildIndex(childIndex);
        return tnc;
    }

    public String toString() {
        String alias = this.getAlias();
        if (alias != null && !"".equals(alias)) {
            return alias;
        }
        return this.getTypename();
    }

    @Override
    public void enter(DataSet data) {
    }

    @Override
    public boolean isReadyToLeave(DataSet data) {
        return true;
    }

    @Override
    public void leave(DataSet data) {
    }

    protected Object getObjectValue(DataSet set) {
        if (this.tagIsSet) {
            return set.getDataAsObject(this.tag);
        }
        return set.getDataAsObject(this.key);
    }

    protected final boolean testConditionUsingExecutor(Conditionality condition, DataSet dataSet) {
        return TreeExecutorHelper.testCondition(condition, dataSet);
    }

    protected final ConditionTestResult testConditionUsingExecutor(ResultConditionality condition, DataSet dataSet) {
        return TreeExecutorHelper.testCondition(condition, dataSet);
    }

    @Override
    public abstract boolean test(DataSet var1);

    @Override
    public abstract String describeTrace(TracePoint var1);

    @Override
    public abstract void setTracePointInfo(TracePoint var1);

    protected final String createTraceDescriptionText(String typeName, String fieldName, String fieldValue, String operationText, String condConfigValue) {
        StringBuilder traceDescription = new StringBuilder();
        traceDescription.append(typeName).append(" : ").append(fieldName != null ? fieldName : "").append("(");
        traceDescription.append(fieldValue != null ? fieldValue : "[VALUE NOT FOUND]").append(")");
        traceDescription.append(" ").append(operationText).append(" ").append(condConfigValue);
        return traceDescription.toString();
    }

    protected String describeValue(Object value, DataSet dataSet) {
        ClassRepository repo = ImmutableCondition.getClassRepository(dataSet);
        FieldDefinition field = repo.getFieldDefinitionByName(this.key);
        DefaultDataDescriber dataDesc = new DefaultDataDescriber(repo);
        String desc = dataDesc.describeObject(value, field);
        return desc;
    }

    protected static ClassRepository getClassRepository(DataSet dataSet) {
        return dataSet.getService().getClassRepository(ClassRepositoryUtil.getCurrentFieldContext(dataSet));
    }

    protected String describeStringValue(String value, DataSet dataSet) {
        String describedValue = this.describeValue(value, dataSet);
        return value != null ? (describedValue.equals(value) ? "\"" + value + "\"" : describedValue) : null;
    }

    protected String describeOctetString(OctetString value, DataSet dataSet) {
        String retVal = null;
        if (value != null) {
            retVal = this.describeValue(value, dataSet);
            retVal = retVal.equals(value.toString()) ? this.concatOctetValueString(retVal, value) : retVal;
        }
        return retVal;
    }

    private String concatOctetValueString(String valueString, OctetString originalValue) {
        StringBuilder newValueString = new StringBuilder();
        boolean displayableUSAscii = OctetString.isDisplayableUSAscii(originalValue);
        if (displayableUSAscii) {
            newValueString.append(originalValue.toPrintableAscii()).append(" (");
        }
        return newValueString.append("0x").append(valueString).append(displayableUSAscii ? ")" : "").toString();
    }

    @Override
    public Set<String> getUsedFields() {
        HashSet<String> set = new HashSet<String>();
        if (this.key != null) {
            set.add(this.key);
        }
        return set;
    }
}

