/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.trace.TraceNodeCondition;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.Traceable;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.Arrays;

public abstract class ImmutableParentCondition
extends ImmutableCondition
implements Cloneable {
    protected Conditionality[] myConditions;
    private int myHashCodeCache;

    protected ImmutableParentCondition(ParseContext ctx, TariffStructureNode[] children) {
        super(ctx);
        this.myConditions = new Conditionality[children.length];
        for (int i = 0; i < children.length; ++i) {
            children[i].setParent(this);
            if (!(children[i] instanceof Traceable)) {
                throw new IllegalArgumentException("Children of ImmutableParentCondition needs to be Traceable too");
            }
            this.myConditions[i] = (Conditionality)((Object)children[i]);
        }
        this.myHashCodeCache = this.internalHashCode();
    }

    protected ImmutableParentCondition(String pconditionName, String pkey, int ptag, boolean ptagIsSet, String nodeId, String alias, Conditionality[] conditions) {
        super(pconditionName, pkey, ptag, ptagIsSet, nodeId, alias);
        this.myConditions = conditions;
        this.myHashCodeCache = this.internalHashCode();
    }

    private int internalHashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + Arrays.hashCode(this.myConditions);
        return result;
    }

    @Override
    protected int hashCodeImpl() {
        return this.myHashCodeCache;
    }

    @Override
    protected boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableParentCondition other = (ImmutableParentCondition)obj;
        if (this.myHashCodeCache != other.myHashCodeCache) {
            return false;
        }
        return Arrays.equals(this.myConditions, other.myConditions);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        return (DAGNode)((Object)this.myConditions[index]);
    }

    @Override
    public int getChildCount() {
        return this.myConditions.length;
    }

    @Override
    public void insertChildAt(int index, DAGNode node) throws IndexOutOfBoundsException, IllegalArgumentException {
        throw new IndexOutOfBoundsException("Condition is immutable, not allowed to add children");
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) throws IndexOutOfBoundsException, IllegalArgumentException {
        throw new IndexOutOfBoundsException("Condition is immutable, not allowed to add children");
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        int i = DAGUtil.indexOf(child, Arrays.asList(this.myConditions));
        if (i < 0) {
            throw new IllegalArgumentException("Child not found: " + child);
        }
        this.myConditions[i] = (Conditionality)((Object)replacement);
    }

    @Override
    protected void removeChild(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public TariffStructureNode createTraceNode(int childIndex, TraceNodeInterface parent) {
        TraceNodeCondition tnc = null;
        if (this.myConditions == null) {
            tnc = new TraceNodeCondition(this);
            tnc.setParent(parent);
            parent.addChild(tnc);
            tnc.setChildIndex(childIndex);
        } else {
            try {
                ImmutableParentCondition clone = (ImmutableParentCondition)this.clone();
                clone.myConditions = new Conditionality[this.myConditions.length];
                tnc = new TraceNodeCondition(clone);
                tnc.setParent(parent);
                parent.addChild(tnc);
                tnc.setChildIndex(childIndex);
                for (int i = 0; i < this.myConditions.length; ++i) {
                    TariffStructureNode tni = this.myConditions[i].createTraceNode(i, tnc);
                    clone.myConditions[i] = (Conditionality)((Object)tni);
                }
                clone.myHashCodeCache = clone.internalHashCode();
            }
            catch (CloneNotSupportedException e) {
                throw new TreeExecutionException(e);
            }
        }
        return tnc;
    }

    @Override
    public abstract boolean test(DataSet var1);

    @Override
    public abstract String describeTrace(TracePoint var1);

    @Override
    public abstract void setTracePointInfo(TracePoint var1);
}

