/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.bit;

import com.ericsson.ere.selectiontree.conditions.bit.BitPatternMatcher;
import com.ericsson.ere.selectiontree.conditions.bit.RangeMatcher;
import com.ericsson.ere.selectiontree.conditions.bit.ValuePairMatcher;
import ericsson.ere.datatype.DataType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class BitPatternMatcherFactory {
    public static final BigInteger DFLT_MASK = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    public static final int SHORT = 1;
    public static final int INTEGER = 2;
    public static final int LONG = 3;

    public static ArrayList<BitPatternMatcher> createBitPatternMatchers(String numberList, DataType dataType) throws Exception {
        ArrayList<BitPatternMatcher> l = new ArrayList<BitPatternMatcher>();
        StringTokenizer st = new StringTokenizer(numberList, " ,\t\n\r\u0000");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() == 0) continue;
            int rangeIndicatorPos = token.indexOf(45);
            if (rangeIndicatorPos != -1) {
                BigInteger stop;
                BigInteger start = new BigInteger(token.substring(0, rangeIndicatorPos));
                if (start.compareTo(stop = new BigInteger(token.substring(rangeIndicatorPos + 1, token.length()))) > 0) {
                    throw new Exception("Invalid number range");
                }
                BitPatternMatcherFactory.createRangeMatcher(start, stop, dataType, l);
                continue;
            }
            rangeIndicatorPos = token.indexOf(59);
            if (rangeIndicatorPos != -1) {
                BitPatternMatcherFactory.createValuePair(new BigInteger(token.substring(0, rangeIndicatorPos)), new BigInteger(token.substring(rangeIndicatorPos + 1, token.length())), dataType, l);
                continue;
            }
            BitPatternMatcherFactory.createValuePair(new BigInteger(token), DFLT_MASK, dataType, l);
        }
        return l;
    }

    private static void createValuePair(BigInteger value, BigInteger mask, DataType dataType, ArrayList<BitPatternMatcher> l) {
        switch (dataType) {
            case SHORT: 
            case UNSIGNEDSHORT: {
                l.add(new ValuePairMatcher(value.shortValue(), mask.shortValue()));
                break;
            }
            case INTEGER: 
            case UNSIGNEDINT: {
                l.add(new ValuePairMatcher(value.intValue(), mask.intValue()));
                break;
            }
            case LONG: 
            case UNSIGNEDLONG: {
                l.add(new ValuePairMatcher(value.longValue(), mask.longValue()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type: " + dataType + " is not supported.");
            }
        }
    }

    private static void createRangeMatcher(BigInteger aStart, BigInteger aStop, DataType dataType, ArrayList<BitPatternMatcher> l) {
        switch (dataType) {
            case SHORT: 
            case UNSIGNEDSHORT: {
                l.add(new RangeMatcher(aStart.shortValue(), aStop.shortValue()));
                break;
            }
            case INTEGER: 
            case UNSIGNEDINT: {
                l.add(new RangeMatcher(aStart.intValue(), aStop.intValue()));
                break;
            }
            case LONG: 
            case UNSIGNEDLONG: {
                l.add(new RangeMatcher(aStart.longValue(), aStop.longValue()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Data type: " + dataType + " is not supported.");
            }
        }
    }
}

