/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.date;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.datatype.LazyEvaluatedValue;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.util.OperatorUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Immutable
public final class DateCondition
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
TraceableV2 {
    public static final String TAG_DATE_OPERATOR = "Operator";
    public static final String TAG_DATE_VALUE = "DateValue";
    protected static final String TESTED_VALUE = "Tested_Value";
    private static final Object COMPARISON_DATE = new Object();
    private final EREDate myInputDateToTest;
    private final OperatorUtil.Operator myOperator;

    private DateCondition(ParseContext ctx) {
        super(ctx);
        NodeList childNodes = ctx.getXMLNode().getChildNodes();
        Element operatorNode = XMLUtil.getNamedElement(TAG_DATE_OPERATOR, childNodes);
        String escapedOperator = XMLUtil.getFirstTextContent(operatorNode);
        String operator = OperatorUtil.tokenToOperator(escapedOperator);
        this.myOperator = OperatorUtil.getOperatorAsEnum(operator);
        Element fieldValueNode = XMLUtil.getNamedElement(TAG_DATE_VALUE, childNodes);
        String fieldValue = XMLUtil.getFirstTextContent(fieldValueNode);
        ClassRepository repository = ctx.getClassRepository();
        FieldDefinition field = repository.getFieldDefinitionByName(this.key);
        DataType resolver = field != null ? FieldDefinitionUtil.createValueResolver(repository, field) : DataType.DATE;
        this.myInputDateToTest = (EREDate)resolver.parseValueString(fieldValue);
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.DATE);
    }

    public static DateCondition create(ParseContext ctx, TariffStructureNode[] notUsed) {
        return new DateCondition(ctx);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myInputDateToTest == null ? 0 : this.myInputDateToTest.hashCode());
        result = 31 * result + (this.myOperator == null ? 0 : this.myOperator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() || !super.equalsImpl(obj)) {
            return false;
        }
        DateCondition other = (DateCondition)obj;
        if (this.myInputDateToTest == null ? other.myInputDateToTest != null : !this.myInputDateToTest.equals(other.myInputDateToTest)) {
            return false;
        }
        return !(this.myOperator == null ? other.myOperator != null : !this.myOperator.equals((Object)other.myOperator));
    }

    @Override
    public boolean test(DataSet theData) {
        boolean testRes = false;
        try {
            EREDate dateToCompareTo = this.getComparisonDate(theData);
            EREDate dateToTest = EREDateUtil.convertToEREDate(this.extractFieldValueFromDataSet(theData, this.myField));
            testRes = this.myOperator.test(dateToTest.compareTo(dateToCompareTo), 0L);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return testRes;
    }

    private EREDate getComparisonDate(DataSet theData) {
        EREDate dateToCompareTo = this.myInputDateToTest;
        if (dateToCompareTo instanceof LazyEvaluatedValue) {
            dateToCompareTo = (EREDate)((LazyEvaluatedValue)((Object)dateToCompareTo)).evaluate(theData);
        }
        return dateToCompareTo;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String fieldNameString = this.describeFieldName(dataSet);
        String dateFormatted = null;
        try {
            Object dataSetFieldValue = this.extractFieldValueFromDataSet(dataSet, this.myField);
            dateFormatted = dataSetFieldValue != null ? this.describeValue(dataSetFieldValue, dataSet) : "";
        }
        catch (DataSetValueNotFoundException dataSetFieldValue) {
            // empty catch block
        }
        EREDate comparisonDate = (EREDate)tp.getInfo(COMPARISON_DATE);
        String inputDateFormatted = comparisonDate != null ? this.describeValue(comparisonDate, dataSet) : "[VALUE NOT FOUND]";
        return this.createTraceDescriptionText("Date", fieldNameString, dateFormatted, OperatorUtil.operatorString[this.myOperator.ordinal()], inputDateFormatted);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
        try {
            tp.addInfo(COMPARISON_DATE, this.getComparisonDate(tp.getPreDataSet()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }
}

