/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.date;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.LegacyAutoConditionMapProfile;
import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.selectiontree.conditions.date.Days;
import com.ericsson.ere.selectiontree.conditions.date.DaysProfileContract;
import com.ericsson.ere.selectiontree.conditions.field.FieldSelectionConditionProfile;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Constrainable(contractClass=DaysProfileContract.class)
@RequiresNonMapField
@LegacyAutoConditionMapProfile
public class DaysProfile
extends AbstractConditionProfileV2
implements FieldMappable {
    protected static final String LBL_COMPARISON_DATE = "Comparison date";
    protected static final String LBL_OPERATION = "Operation";
    protected static final String LBL_NUM_OF_DAYS = "Days";
    private ClassRepository myRepository;
    private ClassRepositoryHelper myRepositoryHelper;
    private static final String DATE_TIME_INTEROPERABILITY_FEATURE = "Date_Time_Interoperability_Support";
    private boolean mySupportDataSetTimeField = false;

    private Variable createVariableForLabel(String label, String selectedValue) {
        if (label.equals(LBL_COMPARISON_DATE)) {
            String fieldName = this.isMapped() ? this.myRepository.getConditionFieldName(this.getName()) : this.getFieldName();
            Object[] allDateFields = this.extractAllDateFields(fieldName);
            return new DropDownVariable(label, (Object)(selectedValue == null ? allDateFields[0] : selectedValue), allDateFields);
        }
        if (label.equals(LBL_OPERATION)) {
            return new DropDownVariable(LBL_OPERATION, Days.numericOperatorArr, Days.tokenOperatorArr, (Object)selectedValue);
        }
        throw new IllegalArgumentException("Label '" + label + "' does not exist");
    }

    private String[] extractAllDateFields(String fieldName) {
        List<String> supportedFieldNameList = this.getSupportedFields(fieldName);
        ConstraintContext ctx = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, fieldName).build();
        List<String> constrainedFieldNameList = ConstraintService.constrainItems(this, ctx, ConstraintTargetType.FIELD, this.myRepository, supportedFieldNameList);
        constrainedFieldNameList.add(0, "StartTime()");
        constrainedFieldNameList.add(0, "CurrentTime()");
        return constrainedFieldNameList.toArray(new String[constrainedFieldNameList.size()]);
    }

    private Variable createVariableForLabel(String label, long value) {
        if (label.equals(LBL_NUM_OF_DAYS)) {
            return new LongVariable(LBL_NUM_OF_DAYS, value);
        }
        throw new IllegalArgumentException("Label '" + label + "' does not exist");
    }

    private String tokenToOperator(String token) {
        for (int i = 0; i < Days.tokenOperatorArr.length; ++i) {
            if (!Days.tokenOperatorArr[i].equals(token)) continue;
            return Days.numericOperatorArr[i];
        }
        return token;
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(this.createVariableForLabel(LBL_COMPARISON_DATE, null));
        l.add(this.createVariableForLabel(LBL_OPERATION, Days.tokenOperatorArr[0]));
        l.add(this.createVariableForLabel(LBL_NUM_OF_DAYS, 0L));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        if (Days.hasValueProperty((Element)iterator, "date1")) {
            String dateFld = Days.getValueStringForProperty((Element)iterator, "date1");
            l.add(this.createVariableForLabel(LBL_COMPARISON_DATE, dateFld));
        }
        if (Days.hasValueProperty((Element)iterator, "operator")) {
            String operator = Days.getValueStringForProperty((Element)iterator, "operator");
            l.add(this.createVariableForLabel(LBL_OPERATION, operator));
        }
        if (Days.hasValueProperty((Element)iterator, "days")) {
            Long days = Days.getValueLongForProperty((Element)iterator, "days");
            l.add(this.createVariableForLabel(LBL_NUM_OF_DAYS, days));
        }
        return l;
    }

    private static String propertyTag(String name, String value, int indentLevel, String indentMarker) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < indentLevel + 1; ++i) {
            buf.append(indentMarker);
        }
        buf.append("<Property ");
        buf.append("name=\"" + name + "\" ");
        buf.append("value=\"" + value + "\"/>");
        return buf.toString();
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String fld_Date1 = VarListUtil.getValueStringForName(variables, LBL_COMPARISON_DATE);
        String fld_Operator = VarListUtil.getValueStringForName(variables, LBL_OPERATION);
        String fld_NumOfDays = VarListUtil.getValueStringForName(variables, LBL_NUM_OF_DAYS);
        out.println(DaysProfile.propertyTag("date1", fld_Date1, indentLevel, indentMarker));
        out.println(DaysProfile.propertyTag("operator", fld_Operator, indentLevel, indentMarker));
        out.println(DaysProfile.propertyTag("days", fld_NumOfDays, indentLevel, indentMarker));
    }

    static List<String> getSupportedFieldList(ClassRepositoryHelper helper, String selectedField) {
        ArrayList<String> availableFields = new ArrayList<String>();
        if (selectedField == null || selectedField.equals("CurrentTime()") || selectedField.equals("StartTime()")) {
            availableFields.addAll(helper.getFieldListForContext("ALL fields", true));
        } else {
            List<String> contextsForField = helper.getAllContextsForField(selectedField);
            if (contextsForField != null) {
                availableFields.addAll(helper.getFieldMappableFieldsForField(true, selectedField));
            }
        }
        ArrayList<String> availableDateFields = new ArrayList<String>();
        for (String field : availableFields) {
            FieldDefinition fd = helper.getClassRepository().getFieldDefinitionByName(field);
            DataType type = fd.getTypedDataType();
            if (type != DataType.DATE && type != DataType.TIME || fd.isComplexType()) continue;
            availableDateFields.add(fd.getFieldName());
        }
        return availableDateFields;
    }

    List<String> getSupportedFields(String selectedField) {
        ArrayList<String> availableFields = new ArrayList<String>();
        if (selectedField == null || selectedField.equals("CurrentTime()") || selectedField.equals("StartTime()")) {
            availableFields.addAll(this.myRepositoryHelper.getFieldListForContext("ALL fields", true));
        } else {
            List<String> contextsForField = this.myRepositoryHelper.getAllContextsForField(selectedField);
            if (contextsForField != null) {
                availableFields.addAll(this.myRepositoryHelper.getFieldMappableFieldsForField(true, selectedField));
            }
        }
        ArrayList<String> availableDateFields = new ArrayList<String>();
        for (String field : availableFields) {
            FieldDefinition fd = this.myRepository.getFieldDefinitionByName(field);
            DataType type = fd.getTypedDataType();
            if (type != DataType.DATE && (!this.mySupportDataSetTimeField || type != DataType.TIME) || fd.isComplexType()) continue;
            availableDateFields.add(fd.getFieldName());
        }
        return availableDateFields;
    }

    @Override
    public boolean needsRepository() {
        return true;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        this.myRepository = repository;
        this.myRepositoryHelper = new ClassRepositoryHelper(this.myRepository);
        List<String> enabledFeatures = ConstraintService.constrainFeatures(this, repository, DaysProfile.getSupportedFeatures());
        this.mySupportDataSetTimeField = enabledFeatures.contains(DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        StringBuilder buf = new StringBuilder();
        String selectedFieldName = VarListUtil.getValueStringForName(variables, "Selected field");
        if (selectedFieldName == null) {
            selectedFieldName = super.getDescription(variables);
        }
        buf.append("<b>" + selectedFieldName + "</b> (");
        buf.append(GuiUtil.replaceSubString(this.getDescription(variables) + ")\n", "<", "&lt;"));
        buf.append(this.getComment(variables));
        return GuiUtil.multilineTooltipWrapper(buf.toString());
    }

    @Override
    public String getDescription(List<Variable> variables) {
        StringBuilder buf = new StringBuilder();
        String displayableFieldName = this.getFieldNameToDisplay(variables);
        buf.append(VarListUtil.getStringValueForName(variables, LBL_COMPARISON_DATE) + " - ");
        buf.append(displayableFieldName);
        buf.append(" " + this.tokenToOperator(VarListUtil.getStringValueForName(variables, LBL_OPERATION)) + " ");
        buf.append(VarListUtil.getValueStringForName(variables, LBL_NUM_OF_DAYS));
        return buf.toString();
    }

    private String getFieldNameToDisplay(List<Variable> variables) {
        String displayableName;
        String selectedFieldName = VarListUtil.getValueStringForName(variables, "Selected field");
        if (selectedFieldName == null) {
            displayableName = super.getDescription(variables);
        } else {
            Object indexObject = VarListUtil.getValueForName(variables, FieldSelectionConditionProfile.LBL_INDEX);
            ValueFieldCompositeObject vfco = this.getValueFieldCompositeObjectOrNull(indexObject);
            FieldDefinition fieldDefinition = this.myRepository.getFieldDefinitionByName(selectedFieldName);
            displayableName = FieldOrientedPluginProfileUtil.formatFieldNameStringWithIndexOrKeyIfPresent(fieldDefinition, vfco, this.myRepository);
        }
        return displayableName;
    }

    private ValueFieldCompositeObject getValueFieldCompositeObjectOrNull(Object indexObj) {
        ValueFieldCompositeObject vfco = null;
        if (indexObj instanceof ValueFieldCompositeObject) {
            vfco = (ValueFieldCompositeObject)indexObj;
        } else if (indexObj instanceof Integer) {
            vfco = new ValueFieldCompositeObject(ValueFieldCompositeObject.Mode.Value, indexObj.toString());
        }
        return vfco;
    }

    static List<String> getSupportedFeatures() {
        return Arrays.asList(DATE_TIME_INTEROPERABILITY_FEATURE);
    }
}

