/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.field;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationDefs;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.HierarchicalFieldFilter;
import com.ericsson.ere.selectiontree.conditions.AbstractFieldOrientedConditionProfile;
import com.ericsson.ere.selectiontree.conditions.field.DoesFieldExistConditionProfileContract;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.FieldListBuilderWithLegacySupport;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.IndexVariableFactory;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.LazyFieldDropDownVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Constrainable(contractClass=DoesFieldExistConditionProfileContract.class)
public class DoesFieldExistConditionProfile
extends AbstractFieldOrientedConditionProfile
implements TestCaseGenerationConditionInterface {
    private static final String LBL_FIELD = "Field";
    private static final String LBL_FIELD_INDEX = "Index";
    private static final String LBL_CHECK_VALUE_FOR_KEY = "Check map value";
    private static final String MSG_NO_FIELDS_EXIST = "No available fields found";
    private static final String ARRAY_MAP_SUPPORT_FEATURE = "Array_Map_Support";
    private static final String DATE_TIME_INTEROPERABILITY_FEATURE = "Date_Time_Interoperability_Support";
    private static final String HIDE_MAP_ENTRY_OPTION_FEATURE = "Hide_Map_Entry_Option";
    private static final String FORCE_MAP_ENTRY_OPTION_FEATURE = "Force_Map_Entry_Option";
    private static final String INDEX_MANDATORY_MSG = "Indexing is mandatory for the selected field";
    private static final String INDEX_NOT_ALLOWED_MSG = "Indexing is no longer allowed for the selected field";
    private boolean mySupportArrayMap;
    private boolean mySupportDateTimeInteroperability;

    @Override
    public List<Variable> getVariables() {
        return this.getVariables(null, null, true);
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        Element fieldNode = XMLUtil.getFirstElementNamed(LBL_FIELD, (Element)iterator);
        String fieldName = XMLUtil.getFirstTextContent(fieldNode);
        Element indexElement = XMLUtil.getFirstElementNamed(LBL_FIELD_INDEX, fieldNode);
        return this.getVariables(fieldName, indexElement, false);
    }

    private List<Variable> getVariables(String fieldName, Element indexElement, boolean createDefaultIndexIfMissing) {
        ArrayList<Variable> varList = new ArrayList<Variable>(3);
        FieldHierarchyNode field = this.myClassRepository.getFieldRepository().getFieldByName(fieldName);
        AvailableFieldListBuilder builder = new FieldListBuilderWithLegacySupport(this.myClassRepository).withLegacyField(field).withHierarchicalFields().withConstraints(this, null).withFilter(new SupportedHierarchicalFieldFilter(this, this.mySupportArrayMap)).withFilter(this.createFieldFilter()).withFilter(new ComplexFieldFilter(this.mySupportArrayMap));
        if (!builder.filtersAllow(field)) {
            List<FieldHierarchyNode> availableFields = builder.buildList();
            if (availableFields.isEmpty()) {
                varList.add(new NotAllowedVariable(LBL_FIELD, MSG_NO_FIELDS_EXIST));
            } else {
                String defaultSelectedField = fieldName != null ? fieldName : availableFields.get(0).getCanonicalName();
                varList.add(FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(LBL_FIELD, null, availableFields, defaultSelectedField));
                varList.addAll(this.createMapEntryOptionVariables(defaultSelectedField, indexElement, createDefaultIndexIfMissing));
            }
        } else {
            varList.add(new LazyFieldDropDownVariable(LBL_FIELD, builder, fieldName));
            varList.addAll(this.createMapEntryOptionVariables(fieldName, indexElement, createDefaultIndexIfMissing));
        }
        return varList;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String fieldName = this.getFieldName(variables);
        out.print(this.indentation(indentLevel + 1, indentMarker));
        String indexConfig = "";
        ValueFieldCompositeObject vfco = this.createObjectForIndexVariable(VarListUtil.getVariableForKey(variables, LBL_FIELD_INDEX));
        if (vfco != null) {
            indexConfig = XMLUtil.wrapXMLInTag(LBL_FIELD_INDEX, vfco.getXMLRepresentation());
        }
        out.println(XMLUtil.wrapXMLInTag(LBL_FIELD, fieldName + indexConfig));
    }

    private String getFieldName(List<Variable> variables) {
        String fieldName = VarListUtil.getValueStringForName(variables, LBL_FIELD);
        if (fieldName.equals(MSG_NO_FIELDS_EXIST)) {
            fieldName = "";
        }
        return fieldName;
    }

    @Override
    public boolean parameterChanged(String variableLabel, Variable variable, List<Variable> variableList) {
        boolean hasChanged = false;
        if (LBL_FIELD.equals(variableLabel)) {
            hasChanged |= this.removeVariablesAfter(variable, variableList);
            hasChanged |= variableList.addAll(this.createMapEntryOptionVariables(variable.getValueString(), null, true));
        } else if (LBL_CHECK_VALUE_FOR_KEY.equals(variableLabel)) {
            boolean clearUsingKey = Boolean.valueOf(variable.getValueString());
            String fieldName = VarListUtil.getValueStringForName(variableList, LBL_FIELD);
            hasChanged |= VarListUtil.removeVariablesByKey(variableList, LBL_FIELD_INDEX);
            MapEntryOption option = this.investigateMapEntryOption(fieldName);
            if (clearUsingKey) {
                switch (option) {
                    case FORCE_MAP_ENTRY: {
                        variable.setAllowEdit(false);
                    }
                    case SHOW_MAP_ENTRY: {
                        this.addIndexVariable(LBL_FIELD_INDEX, LBL_FIELD_INDEX, fieldName, null, variableList, this.createIndexVariableFactory());
                        break;
                    }
                    case HIDE_MAP_ENTRY: {
                        variable.setAllowEdit(true);
                        variableList.add(this.createNotAllowedVariable(INDEX_NOT_ALLOWED_MSG));
                        break;
                    }
                }
                hasChanged = true;
            } else {
                switch (option) {
                    case FORCE_MAP_ENTRY: {
                        variable.setAllowEdit(true);
                        variableList.add(this.createNotAllowedVariable(INDEX_MANDATORY_MSG));
                        hasChanged = true;
                        break;
                    }
                    case HIDE_MAP_ENTRY: {
                        variable.setAllowEdit(false);
                        hasChanged = true;
                        break;
                    }
                }
            }
        }
        return hasChanged;
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        super.setClassRepository(repository);
        this.checkFeaturesViaClassRepository(this.myClassRepository);
    }

    private void checkFeaturesViaClassRepository(ClassRepository repository) {
        List<String> enabledFeatures = ConstraintService.constrainFeatures(this, repository, this.getSupportedFeatures(null));
        this.mySupportArrayMap = enabledFeatures.contains(ARRAY_MAP_SUPPORT_FEATURE);
        this.mySupportDateTimeInteroperability = enabledFeatures.contains(DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    private Variable createClearKeyVariable(boolean initialState) {
        return new BoolVariable(LBL_CHECK_VALUE_FOR_KEY, initialState);
    }

    private Variable createNotAllowedVariable(String msg) {
        return new NotAllowedVariable(LBL_FIELD_INDEX, msg);
    }

    private List<Variable> createMapEntryOptionVariables(String fieldName, Element indexElement, boolean createDefaultIndexIfMissing) {
        ArrayList<Variable> varList = new ArrayList<Variable>();
        MapEntryOption option = this.investigateMapEntryOption(fieldName);
        switch (option) {
            case SHOW_MAP_ENTRY: {
                varList.add(this.createClearKeyVariable(indexElement != null));
                if (indexElement == null) break;
                this.addIndexVariable(LBL_FIELD_INDEX, LBL_FIELD_INDEX, fieldName, indexElement, varList, this.createIndexVariableFactory());
                break;
            }
            case FORCE_MAP_ENTRY: {
                Variable clearKeyVariable = this.createClearKeyVariable(true);
                varList.add(clearKeyVariable);
                if (indexElement != null) {
                    clearKeyVariable.setAllowEdit(false);
                    this.addIndexVariable(LBL_FIELD_INDEX, LBL_FIELD_INDEX, fieldName, indexElement, varList, this.createIndexVariableFactory());
                    break;
                }
                if (createDefaultIndexIfMissing) {
                    clearKeyVariable.setAllowEdit(false);
                    this.addIndexVariable(LBL_FIELD_INDEX, LBL_FIELD_INDEX, fieldName, null, varList, this.createIndexVariableFactory());
                    break;
                }
                clearKeyVariable.setValue(false);
                varList.add(this.createNotAllowedVariable(INDEX_MANDATORY_MSG));
                break;
            }
            case HIDE_MAP_ENTRY: {
                if (indexElement == null) break;
                varList.add(this.createClearKeyVariable(true));
                varList.add(this.createNotAllowedVariable(INDEX_NOT_ALLOWED_MSG));
                break;
            }
        }
        return varList;
    }

    private boolean removeVariablesAfter(Variable lastVariable, List<Variable> variableList) {
        boolean variableWasRemoved = false;
        while (variableList.get(variableList.size() - 1) != lastVariable) {
            variableList.remove(variableList.size() - 1);
            variableWasRemoved = true;
        }
        return variableWasRemoved;
    }

    protected List<FieldDefinition> getSupportedFieldList(ClassRepository repository) {
        return FieldOrientedPluginProfileUtil.getSupportedFields(ClassRepositoryHelper.extractVisibleFields(repository), this.createFieldFilter());
    }

    protected List<String> getSupportedFieldNameList(ClassRepository repository) {
        AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(repository);
        builder.withHierarchicalFields();
        builder.withFilter(new TopLevelHierarchicalFieldFilter());
        builder.withFilter(this.createFieldFilter());
        return builder.buildFieldNameList();
    }

    protected boolean isFieldSupported(FieldDefinition field) {
        return field != null && field.isFieldOriented() && !FieldOrientedPluginProfileUtil.fieldIsTDF(field) && !FieldOrientedPluginProfileUtil.fieldIsVirtual(field);
    }

    protected boolean isComplexFieldSupportEnabled() {
        return this.mySupportArrayMap;
    }

    protected List<String> getSupportedFeatures(String fieldName) {
        if (fieldName != null) {
            return Arrays.asList(HIDE_MAP_ENTRY_OPTION_FEATURE, FORCE_MAP_ENTRY_OPTION_FEATURE);
        }
        return Arrays.asList(ARRAY_MAP_SUPPORT_FEATURE, DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        return null;
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        String fieldName = XMLUtil.getFirstTextContent(XMLUtil.getNamedElement(LBL_FIELD, variableValueIterator.getChildNodes()));
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(fieldName, TestCaseGenerationDefs.USE_SIMULATION_FIELD);
        return values;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String field = VarListUtil.getValueStringForName(variables, LBL_FIELD);
        return GuiUtil.multilineTooltipWrapper("<b>" + this.getName() + "</b> (" + field + ")\n" + this.getComment(variables));
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String field = VarListUtil.getValueStringForName(variables, LBL_FIELD);
        ValueFieldCompositeObject vfco = FieldOrientedPluginProfileUtil.createValueFieldCompositeObjectForVariable(VarListUtil.getVariableForKey(variables, LBL_FIELD_INDEX));
        FieldHierarchyNode fn = this.myClassRepository.getFieldRepository().getFieldByName(field);
        String formattedFieldName = fn != null ? FieldOrientedPluginProfileUtil.formatFieldNameStringWithIndexOrKeyIfPresent(fn, vfco, this.myClassRepository) : field;
        return this.getName() + " (" + formattedFieldName + ")";
    }

    @Override
    public String[] getTreeDefinedFieldInUse(List<Variable> vars) {
        HashSet<String> usedTDFs = new HashSet<String>();
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(vars, LBL_FIELD), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(vars, LBL_FIELD_INDEX), this.myClassRepository, true));
        return usedTDFs.toArray(new String[usedTDFs.size()]);
    }

    private boolean fieldIsMap(String fieldName) {
        FieldDefinition fd = this.myClassRepository.getFieldDefinitionByName(fieldName);
        return fd != null && fd.isMap();
    }

    @Override
    public Map<String, Object> getDisplayValues(Node configuration, Map<String, Object> prev) {
        HashMap<String, Object> displayValues = prev != null ? prev : new HashMap<String, Object>();
        Element fieldNode = XMLUtil.getFirstElementNamed(LBL_FIELD, (Element)configuration);
        String fieldName = XMLUtil.getFirstTextContent(fieldNode);
        displayValues.put(LBL_FIELD, fieldName);
        Element indexElement = XMLUtil.getFirstElementNamed(LBL_FIELD_INDEX, fieldNode);
        if (indexElement != null) {
            displayValues.put(LBL_CHECK_VALUE_FOR_KEY, true);
            displayValues.put(LBL_FIELD_INDEX, indexElement.getTextContent());
        } else {
            FieldDefinition field = this.myClassRepository.getFieldDefinitionByName(fieldName);
            if (field != null && field.isMap()) {
                displayValues.put(LBL_CHECK_VALUE_FOR_KEY, false);
            }
        }
        return displayValues;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        Map<String, Object> displayValues = super.getDisplayValues(variables, prev);
        Variable var = VarListUtil.getVariableForKey(variables, LBL_FIELD_INDEX);
        if (var != null) {
            displayValues.put(LBL_FIELD_INDEX, var.getValueString());
        }
        return displayValues;
    }

    protected FieldFilter createFieldFilter() {
        return new GeneralFieldFilter();
    }

    private MapEntryOption investigateMapEntryOption(String fieldName) {
        MapEntryOption option = MapEntryOption.NO_MAP;
        FieldHierarchyNode fieldByName = this.myClassRepository.getFieldRepository().getFieldByName(fieldName);
        if (fieldByName != null) {
            if (fieldByName.isLeaf()) {
                FieldStructure parent = fieldByName.getParent();
                if (parent != null && (parent.getComplexType() == FieldHierarchyNode.ComplexType.MAP || parent.getComplexType() == FieldHierarchyNode.ComplexType.ARRAY)) {
                    option = MapEntryOption.FORCE_MAP_ENTRY;
                }
            } else {
                option = MapEntryOption.HIDE_MAP_ENTRY;
            }
        }
        if (option == MapEntryOption.NO_MAP) {
            ConstraintContext ctx = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, fieldName).build();
            List<String> enabledFeatures = ConstraintService.constrainFeatures(this, ctx, this.myClassRepository, Arrays.asList(HIDE_MAP_ENTRY_OPTION_FEATURE, FORCE_MAP_ENTRY_OPTION_FEATURE));
            boolean fieldIsMap = this.fieldIsMap(fieldName);
            boolean forceMapEntryOption = enabledFeatures.contains(FORCE_MAP_ENTRY_OPTION_FEATURE);
            boolean hideMapEntryOption = enabledFeatures.contains(HIDE_MAP_ENTRY_OPTION_FEATURE);
            if (fieldIsMap) {
                option = forceMapEntryOption ? MapEntryOption.FORCE_MAP_ENTRY : (hideMapEntryOption ? MapEntryOption.HIDE_MAP_ENTRY : MapEntryOption.SHOW_MAP_ENTRY);
            }
        }
        return option;
    }

    private IndexVariableFactory createIndexVariableFactory() {
        return IndexVariableFactory.buildFactory().withHierarchicalFieldSupport(true).withDateTimeInteroperability(this.mySupportDateTimeInteroperability).withFilterableFieldVariable(true).andRepository(this.myClassRepository);
    }

    private static enum MapEntryOption {
        NO_MAP,
        FORCE_MAP_ENTRY,
        HIDE_MAP_ENTRY,
        SHOW_MAP_ENTRY;

    }

    private static class ComplexFieldFilter
    implements FieldFilter {
        private final boolean allowComplex;

        private ComplexFieldFilter(boolean allowComplex) {
            this.allowComplex = allowComplex;
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return this.allowComplex ? true : !field.isComplexType() || field.isSet();
        }
    }

    protected static class GeneralFieldFilter
    implements FieldFilter {
        protected GeneralFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return field.isFieldOriented() && !FieldOrientedPluginProfileUtil.fieldIsTDF(field) && !FieldOrientedPluginProfileUtil.fieldIsVirtual(field);
        }
    }

    private class SupportedHierarchicalFieldFilter
    implements HierarchicalFieldFilter {
        private final DoesFieldExistConditionProfile myProfile;
        private final boolean mySupportArrayMap;

        SupportedHierarchicalFieldFilter(DoesFieldExistConditionProfile profile, boolean supportArrayMap) {
            this.myProfile = profile;
            this.mySupportArrayMap = supportArrayMap;
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            return !field.isKey() && !this.isFieldArrayOrMapAndNotSupported(field) && !this.isHiddenMapDataField(field) && !this.isHiddenMapField(field);
        }

        private boolean isFieldArrayOrMapAndNotSupported(FieldHierarchyNode field) {
            boolean retVal = false;
            FieldHierarchyNode.ComplexType complexType = field.getComplexType();
            if (complexType == FieldHierarchyNode.ComplexType.ARRAY || complexType == FieldHierarchyNode.ComplexType.MAP) {
                retVal = !this.mySupportArrayMap;
            } else {
                FieldStructure parent = field.getParent();
                if (parent != null && (parent.getComplexType() == FieldHierarchyNode.ComplexType.ARRAY || parent.getComplexType() == FieldHierarchyNode.ComplexType.MAP)) {
                    retVal = !this.mySupportArrayMap;
                }
            }
            return retVal;
        }

        private boolean isHiddenMapDataField(FieldHierarchyNode field) {
            boolean retVal = false;
            FieldStructure parent = field.getParent();
            if (parent != null && parent.getComplexType() == FieldHierarchyNode.ComplexType.MAP) {
                ConstraintContext ctx = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, parent.getCanonicalName()).build();
                List<String> enabledFeatures = ConstraintService.constrainFeatures(this.myProfile, ctx, DoesFieldExistConditionProfile.this.myClassRepository, Arrays.asList(DoesFieldExistConditionProfile.HIDE_MAP_ENTRY_OPTION_FEATURE, DoesFieldExistConditionProfile.FORCE_MAP_ENTRY_OPTION_FEATURE));
                retVal = !enabledFeatures.contains(DoesFieldExistConditionProfile.FORCE_MAP_ENTRY_OPTION_FEATURE) && enabledFeatures.contains(DoesFieldExistConditionProfile.HIDE_MAP_ENTRY_OPTION_FEATURE);
            }
            return retVal;
        }

        private boolean isHiddenMapField(FieldHierarchyNode field) {
            boolean retVal = false;
            if (!field.isLeaf() && field.getComplexType() == FieldHierarchyNode.ComplexType.MAP) {
                ConstraintContext ctx = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, field.getCanonicalName()).build();
                List<String> enabledFeatures = ConstraintService.constrainFeatures(this.myProfile, ctx, DoesFieldExistConditionProfile.this.myClassRepository, Arrays.asList(DoesFieldExistConditionProfile.FORCE_MAP_ENTRY_OPTION_FEATURE));
                retVal = enabledFeatures.contains(DoesFieldExistConditionProfile.FORCE_MAP_ENTRY_OPTION_FEATURE);
            }
            return retVal;
        }
    }

    private class TopLevelHierarchicalFieldFilter
    implements HierarchicalFieldFilter {
        private TopLevelHierarchicalFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            return field.getParent() == null;
        }
    }
}

