/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.field;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresMapField;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresSetField;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.variable.VariableChangeEvent;
import com.ericsson.ere.variable.VariableChangeListener;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.ConditionProfile;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.FilterableTypedDropDownVariable;
import ericsson.vareditor.variable.ItemModel;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FieldProfileModel
implements ItemModel,
VariableChangeListener {
    public static final String CONDITION_ATTR = "condition";
    public static final String FIELD_ATTR = "field";
    public static final String FIELD_TAG = "Field";
    public static final String FIELD_LABEL = "Name";
    public static final String CONDITION_LABEL = "Condition";
    private VarTableModel myVarTableModel;
    private final ClassRepositoryHelper myHelper;
    private final FieldHierarchyNode myField;

    public FieldProfileModel(FieldHierarchyNode field, ClassRepositoryHelper helper) {
        this.myField = field;
        this.myHelper = helper;
        this.createVarTableModel(null);
    }

    public FieldProfileModel(FieldHierarchyNode field, Element config, ClassRepositoryHelper helper) {
        this.myField = field;
        this.myHelper = helper;
        this.createVarTableModel(config);
    }

    @Override
    public void appendXML(Node parent) {
        List<Variable> vars = this.myVarTableModel.getData();
        String field = XMLUtil.escape(VarListUtil.getValueStringForName(vars, FIELD_LABEL));
        String condition = XMLUtil.escape(VarListUtil.getValueStringForName(vars, CONDITION_LABEL));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<Subcondition>FieldSelection<").append(FIELD_TAG).append(" field='").append(field).append("' condition='").append(condition).append("'/>");
        String preamble = stringBuilder.toString();
        String postamble = "</Subcondition>";
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ConditionProfile usedConditionProfile = this.getUsedConditionProfile();
        if (usedConditionProfile != null) {
            usedConditionProfile.printParameters(pw, 0, "", vars);
        }
        try {
            String allOfIt = preamble + sw.toString() + postamble;
            Element element = XMLUtil.buildDocumentFromString(allOfIt).getDocumentElement();
            XMLUtil.adoptNode(parent.getOwnerDocument(), element);
            parent.appendChild(element);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void valueChanged(VariableChangeEvent event) {
        for (Variable var : this.myVarTableModel.getData()) {
            var.removeVariableChangeListener(this);
        }
        Variable var = event.getVariable();
        String label = var.getLabel();
        if (FIELD_LABEL.equals(label)) {
            this.removeAllAfter(var);
            FilterableTypedDropDownVariable fieldVar = (FilterableTypedDropDownVariable)var;
            Variable conditionDropDown = this.createConditionDropDown((FieldDefinition)fieldVar.getSelectedItem());
            this.myVarTableModel.getData().add(conditionDropDown);
            ConditionProfile usedConditionProfile = this.getUsedConditionProfile();
            if (conditionDropDown.isValueValid() && usedConditionProfile != null) {
                this.myVarTableModel.getData().addAll(usedConditionProfile.getVariables());
            }
            this.myVarTableModel.fireTableDataChanged();
        } else if (CONDITION_LABEL.equals(label)) {
            this.removeAllAfter(var);
            ConditionProfile usedConditionProfile = this.getUsedConditionProfile();
            if (usedConditionProfile != null) {
                this.myVarTableModel.getData().addAll(usedConditionProfile.getVariables());
            }
            this.myVarTableModel.fireTableDataChanged();
        } else if (this.getUsedConditionProfile().parameterChanged(label, var, this.myVarTableModel.getData())) {
            this.myVarTableModel.fireTableDataChanged();
        }
        for (Variable vara : this.myVarTableModel.getData()) {
            vara.addVariableChangeListener(this);
        }
    }

    @Override
    public ItemModel clone() {
        Element root;
        try {
            root = XMLUtil.buildDocumentFromString("<Clone />").getDocumentElement();
        }
        catch (Exception e) {
            throw new AssertionError((Object)"Clone of FieldProfileModel failed!");
        }
        this.appendXML(root);
        return new FieldProfileModel(this.myField, (Element)root.getFirstChild(), this.myHelper);
    }

    @Override
    public String describe() {
        String ret = null;
        ConditionProfile prof = this.getUsedConditionProfile();
        ret = prof != null ? prof.getDescription(this.myVarTableModel.getData()) : "Error";
        return ret;
    }

    private List<FieldDefinition> getFields() {
        AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myHelper.getClassRepository()).withHierarchicalFields().withSetSubFields().withFilter(new ScopeFilter());
        return builder.buildFieldDefinitionList();
    }

    private Variable createConditionDropDown(FieldDefinition chosenField) {
        BaseVariable ret = null;
        if (chosenField == null) {
            ret = new NotAllowedVariable(CONDITION_LABEL, "No field is chosen; no conditions available.");
        } else {
            List<String> conditions;
            String fieldName = chosenField.getCanonicalName();
            switch (chosenField.getComplexType()) {
                case ARRAY: 
                case MAP: {
                    conditions = Arrays.asList(this.myHelper.getAnnotatedConditionsForField(fieldName, RequiresMapField.class));
                    break;
                }
                case SET: {
                    conditions = Arrays.asList(this.myHelper.getAnnotatedConditionsForField(fieldName, RequiresSetField.class));
                    break;
                }
                default: {
                    conditions = this.myHelper.getContextConditionProfileNamesForField(fieldName);
                    conditions.removeAll(Arrays.asList(this.myHelper.getAnnotatedConditionsForField(fieldName, RequiresSetField.class)));
                    conditions.removeAll(Arrays.asList(this.myHelper.getAnnotatedConditionsForField(fieldName, RequiresMapField.class)));
                }
            }
            if (conditions.size() == 0) {
                ret = new NotAllowedVariable(CONDITION_LABEL, "No conditions available.");
            } else {
                Object[] condArr = conditions.toArray(new String[0]);
                Object[] aliases = this.fetchConditionAliases((String[])condArr);
                ret = new DropDownVariable(CONDITION_LABEL, aliases, condArr, (Object)condArr[0]);
            }
        }
        return ret;
    }

    private ConditionProfile getUsedConditionProfile() {
        Variable fieldVar = VarListUtil.getVariableForName(this.myVarTableModel.getData(), FIELD_LABEL);
        Variable condVar = VarListUtil.getVariableForName(this.myVarTableModel.getData(), CONDITION_LABEL);
        ConditionProfile prof = null;
        if (fieldVar.isValueValid() && condVar.isValueValid()) {
            prof = this.myHelper.getConditionProfile(fieldVar.getValueString(), condVar.getValueString());
        }
        return prof;
    }

    private String[] fetchConditionAliases(String[] conditionNames) {
        ArrayList<String> list = new ArrayList<String>();
        for (String conditionName : conditionNames) {
            list.add(this.myHelper.getClassRepository().getBaseConditionAliasOrName(conditionName));
        }
        return list.toArray(new String[list.size()]);
    }

    private void removeAllAfter(Variable var) {
        int index = this.myVarTableModel.getData().indexOf(var);
        while (index < this.myVarTableModel.getData().size() - 1) {
            this.myVarTableModel.getData().remove(this.myVarTableModel.getData().size() - 1);
        }
    }

    private void createVarTableModel(Element config) {
        Element fieldXml;
        ArrayList<Variable> vars = new ArrayList<Variable>();
        this.myVarTableModel = new VarTableModel(vars);
        FilterableTypedDropDownVariable<FieldDefinition> fieldVar = FieldOrientedPluginProfileUtil.createFilterableFieldListVariable(FIELD_LABEL, FIELD_LABEL, this.getFields(), (FieldDefinition)null);
        vars.add(fieldVar);
        Element element = fieldXml = config == null ? null : XMLUtil.getFirstElementNamed(FIELD_TAG, config);
        if (fieldXml != null) {
            fieldVar.setValue(XMLUtil.getAttributeFromElement(fieldXml, FIELD_ATTR, null));
        }
        Variable condVar = this.createConditionDropDown(fieldVar.getSelectedItem());
        vars.add(condVar);
        if (fieldXml != null) {
            condVar.setValue(XMLUtil.getAttributeFromElement(fieldXml, CONDITION_ATTR, null));
        }
        if (condVar.isValueValid()) {
            ConditionProfile prof = this.getUsedConditionProfile();
            if (fieldXml != null) {
                vars.addAll(prof.getVariables(config));
            } else {
                vars.addAll(prof.getVariables());
            }
        }
        for (Variable var : vars) {
            var.addVariableChangeListener(this);
        }
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        List<Variable> list = this.myVarTableModel.getData();
        for (Variable var : list) {
            if (var.isValueValid()) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public VarTableModel getVarTableModel() {
        return this.myVarTableModel;
    }

    private class ScopeFilter
    implements FieldFilter {
        private ScopeFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return field.getParent() == FieldProfileModel.this.myField;
        }
    }
}

