/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.selectiontree.conditions.logic.CompareAmountCondition;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.AmountVariable;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractCompareAmountConditionProfile
extends AbstractConditionProfileV2 {
    public static final String LABEL_AMOUNT_CONDITION = "AmountFieldCondition";
    public static final String LABEL_AMOUNT_FIELD = "Field";
    public static final String LABEL_AMOUNT_OPERATOR = "Operator";
    public static final String LABEL_AMOUNT_VALUE = "Amount value";
    public static final String LABEL_AMOUNT_COMPARE_TO_FIELD = "Compare to field";
    public static final String LABEL_AMOUNT_FIELD2 = "Field 2";

    protected abstract String[] getAllAmountFields();

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        l.add(new DropDownVariable(LABEL_AMOUNT_FIELD, (Object)this.getAllAmountFields()[0], (Object[])this.getAllAmountFields()));
        l.add(new DropDownVariable(LABEL_AMOUNT_OPERATOR, (Object)CompareAmountCondition.operatorString[0], (Object[])CompareAmountCondition.operatorString));
        l.add(new BoolVariable(LABEL_AMOUNT_COMPARE_TO_FIELD, false));
        l.add(new AmountVariable(LABEL_AMOUNT_VALUE, "0", false));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        NodeList childNodes = iterator.getChildNodes();
        Element field1Node = XMLUtil.getNamedElement("AmountField", childNodes);
        String field = XMLUtil.getFirstTextContent(field1Node);
        Element operatorNode = XMLUtil.getNamedElement(LABEL_AMOUNT_OPERATOR, childNodes);
        String operator = XMLUtil.getFirstTextContent(operatorNode);
        String field2 = null;
        Element field2Node = XMLUtil.getNamedElement("AmountField2", childNodes);
        if (field2Node != null) {
            field2 = XMLUtil.getFirstTextContent(field2Node);
        }
        String valueField = null;
        Element valueFieldNode = XMLUtil.getNamedElement("AmountValue", childNodes);
        if (valueFieldNode != null) {
            valueField = XMLUtil.getFirstTextContent(valueFieldNode);
        }
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        l.add(new DropDownVariable(LABEL_AMOUNT_FIELD, (Object)field, (Object[])this.getAllAmountFields()));
        l.add(new DropDownVariable(LABEL_AMOUNT_OPERATOR, (Object)XMLUtil.unEscape(operator), (Object[])CompareAmountCondition.operatorString));
        l.add(new BoolVariable(LABEL_AMOUNT_COMPARE_TO_FIELD, field2 != null));
        if (field2 == null) {
            l.add(new AmountVariable(LABEL_AMOUNT_VALUE, valueField, false));
        } else {
            l.add(new DropDownVariable(LABEL_AMOUNT_FIELD2, (Object)field2, (Object[])this.getAllAmountFields()));
        }
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        int i;
        String field2 = null;
        String value = null;
        String field = VarListUtil.getValueStringForName(variables, LABEL_AMOUNT_FIELD);
        String operator = VarListUtil.getValueStringForName(variables, LABEL_AMOUNT_OPERATOR);
        value = VarListUtil.getValueStringForName(variables, LABEL_AMOUNT_VALUE);
        field2 = VarListUtil.getValueStringForName(variables, LABEL_AMOUNT_FIELD2);
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<AmountField>" + field + "</" + "AmountField" + ">");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<Operator>" + XMLUtil.escape(operator) + "</" + LABEL_AMOUNT_OPERATOR + ">");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        if (field2 == null) {
            out.println("<AmountValue>" + value + "</" + "AmountValue" + ">");
        } else {
            out.println("<AmountField2>" + field2 + "</" + "AmountField2" + ">");
        }
    }

    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        if (LABEL_AMOUNT_COMPARE_TO_FIELD.equals(reference)) {
            BoolVariable useField = (BoolVariable)VarListUtil.getVariableForName(vars, LABEL_AMOUNT_COMPARE_TO_FIELD);
            boolean isSelected = (Boolean)useField.getValueObject();
            if (isSelected) {
                Variable amountValueVar = VarListUtil.getVariableForName(vars, LABEL_AMOUNT_VALUE);
                if (amountValueVar != null) {
                    vars.remove(amountValueVar);
                }
                vars.add(new DropDownVariable(LABEL_AMOUNT_FIELD2, (Object)this.getAllAmountFields()[0], (Object[])this.getAllAmountFields()));
            } else {
                Variable amountField2 = VarListUtil.getVariableForName(vars, LABEL_AMOUNT_FIELD2);
                if (amountField2 != null) {
                    vars.remove(amountField2);
                }
                vars.add(new AmountVariable(LABEL_AMOUNT_VALUE, "0", false));
            }
            return true;
        }
        return false;
    }
}

