/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.conditions.logic.util.AmountField;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.util.OperatorUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.Amount;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class AmountCondition
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
TraceableV2 {
    public static final String TAG_AMOUNT_CONDITION = "AmountCondition";
    public static final String TAG_AMOUNT_OPERATOR = "Operator";
    public static final String TAG_AMOUNT_VALUE = "AmountValue";
    private final int myOperator;
    private final AmountField myAmountField;
    private final String myStringValue;

    private AmountCondition(ParseContext ctx) {
        super(ctx);
        Node config = ctx.getXMLNode();
        NodeList childNodes = config.getChildNodes();
        Element operatorNode = XMLUtil.getNamedElement(TAG_AMOUNT_OPERATOR, childNodes);
        if (operatorNode == null) {
            throw new PluginCreationException("Missing tag: Operator");
        }
        String operator = XMLUtil.getFirstTextContent(operatorNode);
        operator = OperatorUtil.tokenToOperator(operator);
        Element fieldValueNode = XMLUtil.getNamedElement(TAG_AMOUNT_VALUE, childNodes);
        if (fieldValueNode == null) {
            throw new PluginCreationException("Missing tag: AmountValue");
        }
        this.myStringValue = XMLUtil.getFirstTextContent(fieldValueNode);
        this.myAmountField = new AmountField(this.myStringValue);
        this.myOperator = this.myAmountField.getOperatorInt(operator);
    }

    public static ImmutableCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new AmountCondition(ctx);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myAmountField == null ? 0 : this.myAmountField.hashCode());
        result = 31 * result + this.myOperator;
        result = 31 * result + (this.myStringValue == null ? 0 : this.myStringValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() || !super.equalsImpl(obj)) {
            return false;
        }
        AmountCondition other = (AmountCondition)obj;
        if (this.myAmountField == null ? other.myAmountField != null : !this.myAmountField.equals(other.myAmountField)) {
            return false;
        }
        if (this.myOperator != other.myOperator) {
            return false;
        }
        return !(this.myStringValue == null ? other.myStringValue != null : !this.myStringValue.equals(other.myStringValue));
    }

    @Override
    public boolean test(DataSet theData) {
        boolean testRes = false;
        try {
            Amount amount = (Amount)this.extractFieldValueFromDataSet(theData, this.myField);
            AmountField amountValueInDataSet = new AmountField(amount);
            testRes = amountValueInDataSet.compare(this.myOperator, this.myAmountField, theData);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return testRes;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String testedFieldValue = null;
        try {
            Amount fieldAmount = (Amount)this.extractFieldValueFromDataSet(dataSet, this.myField);
            if (fieldAmount != null) {
                testedFieldValue = this.describeValue(fieldAmount, dataSet);
            }
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.createTraceDescriptionText("Amount", this.describeFieldName(dataSet), testedFieldValue, this.myAmountField.getOperatorString(this.myOperator), this.describeValue(this.myStringValue, dataSet));
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }
}

