/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.selectiontree.AnnotationBasedPluginConfiguration;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.logic.DatePart;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompareDateWithMaskConfiguration
extends AnnotationBasedPluginConfiguration {
    public static final String TAG_MASK = "Mask";
    private DatePart[] mySelectedDateParts = null;

    protected CompareDateWithMaskConfiguration(ParseContext ctx) {
        super(ctx);
        NodeList children = ctx.getXMLNode().getChildNodes();
        Element maskNode = XMLUtil.getNamedElement(TAG_MASK, children);
        if (maskNode != null) {
            String mask = XMLUtil.getFirstTextContent(maskNode);
            this.mySelectedDateParts = CompareDateWithMaskConfiguration.getDatePartsFromString(mask);
        }
    }

    protected CompareDateWithMaskConfiguration(DatePart[] selected) {
        super(null);
        this.mySelectedDateParts = selected;
    }

    public static CompareDateWithMaskConfiguration create(ParseContext ctx) {
        return new CompareDateWithMaskConfiguration(ctx);
    }

    @Override
    public void appendXML(Node parent) {
        Element maskElement = parent.getOwnerDocument().createElement(TAG_MASK);
        parent.appendChild(maskElement);
        maskElement.setTextContent(this.getSelectedAsString());
    }

    public DatePart[] getSelectedDateParts() {
        return this.mySelectedDateParts;
    }

    private String getSelectedAsString() {
        return StringUtil.join((Object[])this.mySelectedDateParts, ",");
    }

    private static DatePart[] getDatePartsFromString(String datePartsString) {
        String[] datePartStrings = datePartsString.split(",");
        ArrayList<DatePart> dateParts = new ArrayList<DatePart>();
        for (int i = 0; i < datePartStrings.length; ++i) {
            dateParts.add(DatePart.valueOf(datePartStrings[i]));
        }
        return dateParts.toArray(new DatePart[dateParts.size()]);
    }
}

