/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.selectiontree.AnnotationBasedPluginConfiguration;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompareFieldConfiguration
extends AnnotationBasedPluginConfiguration {
    private static final String TAG_FIELD1 = "Field1";
    private static final String TAG_FIELD2 = "Field2";
    private static final String TAG_INDEX = "Index";
    private static final String TAG_OPERATOR = "Operator";
    private static final String TAG_FIELD_VALUE = "FieldValue";
    private String myFirstOperandField;
    private ValueFieldCompositeObject myFirstOperandIndex;
    private String myOperator;
    private String mySecondOperandField;
    private ValueFieldCompositeObject mySecondOperandIndex;
    private String myFieldValue;

    protected CompareFieldConfiguration(ParseContext ctx) {
        super(ctx);
        Element valueFieldNode;
        Element field2Node;
        Element operatorNode;
        NodeList childNodes = ctx.getXMLNode().getChildNodes();
        Element field1Node = XMLUtil.getNamedElement(TAG_FIELD1, childNodes);
        if (field1Node != null) {
            this.myFirstOperandField = XMLUtil.getFirstTextContent(field1Node);
            Element firstIndexElement = XMLUtil.getNamedElement(TAG_INDEX, field1Node.getChildNodes());
            this.myFirstOperandIndex = FieldOrientedPluginUtil.createValueFieldCompositeObjectFromIndexElement(firstIndexElement);
        }
        if ((operatorNode = XMLUtil.getNamedElement(TAG_OPERATOR, childNodes)) != null) {
            this.myOperator = XMLUtil.getFirstTextContent(operatorNode);
        }
        if ((field2Node = XMLUtil.getNamedElement(TAG_FIELD2, childNodes)) != null) {
            this.mySecondOperandField = XMLUtil.getFirstTextContent(field2Node);
            Element secondIndexElement = XMLUtil.getNamedElement(TAG_INDEX, field2Node.getChildNodes());
            this.mySecondOperandIndex = FieldOrientedPluginUtil.createValueFieldCompositeObjectFromIndexElement(secondIndexElement);
        }
        if ((valueFieldNode = XMLUtil.getNamedElement(TAG_FIELD_VALUE, childNodes)) != null) {
            this.myFieldValue = XMLUtil.getFirstTextContent(valueFieldNode);
        }
    }

    protected CompareFieldConfiguration() {
        super(null);
    }

    public static CompareFieldConfiguration create(ParseContext ctx) {
        return new CompareFieldConfiguration(ctx);
    }

    public String getFirstOperandField() {
        return this.myFirstOperandField;
    }

    public void setFirstOperandField(String firstOperandField) {
        this.myFirstOperandField = firstOperandField;
    }

    public ValueFieldCompositeObject getFirstOperandIndex() {
        return this.myFirstOperandIndex;
    }

    public Element getFirstOperandIndexConfiguration() {
        return this.extractVFCOConfiguration(this.myFirstOperandIndex);
    }

    public void setFirstOperandIndex(ValueFieldCompositeObject firstOperandIndex) {
        this.myFirstOperandIndex = firstOperandIndex;
    }

    public String getOperator() {
        return this.myOperator;
    }

    public void setOperator(String operator) {
        this.myOperator = operator;
    }

    public String getSecondOperandField() {
        return this.mySecondOperandField;
    }

    public void setSecondOperandField(String secondOperandField) {
        this.mySecondOperandField = secondOperandField;
    }

    public ValueFieldCompositeObject getSecondOperandIndex() {
        return this.mySecondOperandIndex;
    }

    public Element getSecondOperandIndexConfiguration() {
        return this.extractVFCOConfiguration(this.mySecondOperandIndex);
    }

    public void setSecondOperandIndex(ValueFieldCompositeObject secondOperandIndex) {
        this.mySecondOperandIndex = secondOperandIndex;
    }

    public String getFieldValue() {
        return this.myFieldValue;
    }

    public void setFieldValue(String fieldValue) {
        this.myFieldValue = fieldValue;
    }

    @Override
    public void appendXML(Node parent) {
        this.checkMandatoryParameters();
        Document ownerDocument = parent.getOwnerDocument();
        Element firstFieldElement = ownerDocument.createElement(TAG_FIELD1);
        parent.appendChild(firstFieldElement);
        firstFieldElement.setTextContent(this.myFirstOperandField == null ? "" : this.myFirstOperandField);
        if (this.myFirstOperandIndex != null) {
            Element indexElement = ownerDocument.createElement(TAG_INDEX);
            firstFieldElement.appendChild(indexElement);
            this.myFirstOperandIndex.appendXML(indexElement);
        }
        Element operandElement = ownerDocument.createElement(TAG_OPERATOR);
        parent.appendChild(operandElement);
        operandElement.setTextContent(this.myOperator == null ? "" : this.myOperator);
        if (this.mySecondOperandField != null) {
            Element secondFieldElement = ownerDocument.createElement(TAG_FIELD2);
            parent.appendChild(secondFieldElement);
            secondFieldElement.setTextContent(this.mySecondOperandField);
            if (this.mySecondOperandIndex != null) {
                Element indexElement = ownerDocument.createElement(TAG_INDEX);
                secondFieldElement.appendChild(indexElement);
                this.mySecondOperandIndex.appendXML(indexElement);
            }
        } else if (this.myFieldValue != null) {
            Element valueElement = ownerDocument.createElement(TAG_FIELD_VALUE);
            parent.appendChild(valueElement);
            valueElement.setTextContent(this.myFieldValue);
        }
    }

    private Element extractVFCOConfiguration(ValueFieldCompositeObject vfco) {
        Element configuration = null;
        if (vfco != null) {
            Document doc = XMLUtil.createEmptyDocument();
            configuration = doc.createElement(TAG_INDEX);
            vfco.appendXML(configuration);
        }
        return configuration;
    }

    private void checkMandatoryParameters() throws IllegalStateException {
        if (this.myFirstOperandField == null || this.myOperator == null || this.mySecondOperandField == null && this.myFieldValue == null) {
            throw new IllegalStateException("Mandatory parameter missing. Mandatory parameters = first operand field, operator and (second operand field or field value)");
        }
    }
}

