/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableParentCondition;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class ImmutableCompoundBoolean
extends ImmutableParentCondition
implements TraceableV2 {
    private final OperationType myOperationType;

    public static ImmutableCompoundBoolean create(ParseContext ctx, TariffStructureNode[] children) {
        Node iterator = ctx.getXMLNode();
        Element opNode = XMLUtil.getNamedElement("Operation", iterator.getChildNodes());
        if (opNode == null) {
            throw new IllegalArgumentException("Missing tag: Operation");
        }
        String operation = XMLUtil.getFirstTextContent(opNode);
        OperationType opType = null;
        try {
            opType = OperationType.valueOf(operation);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unrecognized boolean operator: " + operation);
        }
        return ImmutableCompoundBoolean.create(opType, ctx, children);
    }

    public static ImmutableCompoundBoolean create(OperationType operationType, ParseContext ctx, TariffStructureNode[] children) {
        if (operationType == OperationType.NOT && children.length > 1) {
            throw new IllegalArgumentException("CompoundBooleanCondition: Boolean NOT operation requires single argument");
        }
        return new ImmutableCompoundBoolean(operationType, ctx, children);
    }

    private ImmutableCompoundBoolean(OperationType operator, ParseContext ctx, TariffStructureNode[] children) {
        super(ctx, children);
        this.myOperationType = operator;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myOperationType == null ? 0 : this.myOperationType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableCompoundBoolean other = (ImmutableCompoundBoolean)obj;
        return !(this.myOperationType == null ? other.myOperationType != null : !this.myOperationType.equals((Object)other.myOperationType));
    }

    @Override
    public void enter(DataSet theData) {
        int len = this.myConditions.length;
        for (int i = 0; i < len; ++i) {
            this.myConditions[i].enter(theData);
        }
    }

    @Override
    public boolean test(DataSet data) {
        return this.myOperationType.test(this, data);
    }

    private boolean testAND(DataSet theData) {
        Conditionality tc;
        boolean condRes;
        int ncond = this.myConditions.length;
        boolean match = true;
        for (int i = 0; i < ncond && (match &= (condRes = this.testConditionUsingExecutor(tc = this.myConditions[i], theData))); ++i) {
        }
        return match;
    }

    private boolean testOR(DataSet theData) {
        int ncond = this.myConditions.length;
        boolean match = false;
        for (int i = 0; i < ncond; ++i) {
            Conditionality tc = this.myConditions[i];
            boolean condRes = this.testConditionUsingExecutor(tc, theData);
            if (condRes) {
                return true;
            }
            match |= condRes;
        }
        return match;
    }

    private boolean testXOR(DataSet theData) {
        boolean match = false;
        for (Conditionality condition : this.myConditions) {
            match ^= this.testConditionUsingExecutor(condition, theData);
        }
        return match;
    }

    private boolean testNOT(DataSet theData) {
        Conditionality tc = this.myConditions[0];
        boolean condRes = this.testConditionUsingExecutor(tc, theData);
        boolean match = !condRes;
        return match;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public long getConditionSatisfiedDuration(DataSet theData) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getConditionUnsatisfiedDuration(DataSet theData) {
        return Long.MAX_VALUE;
    }

    @Override
    public boolean isReadyToLeave(DataSet data) {
        boolean retVal = true;
        int len = this.myConditions.length;
        for (int i = 0; i < len; ++i) {
            boolean result = this.myConditions[i].isReadyToLeave(data);
            retVal = retVal ? result : retVal;
        }
        return retVal;
    }

    @Override
    public void leave(DataSet data) {
        for (int j = this.myConditions.length; j > 0; --j) {
            this.myConditions[j - 1].leave(data);
        }
    }

    @Override
    public String describeTrace(TracePoint tp) {
        StringBuilder traceDescription = new StringBuilder();
        traceDescription.append("CompoundBoolean : Using ").append((Object)this.myOperationType).append(" on the result from");
        traceDescription.append(this.myConditions.length > 1 ? " all children" : " the child");
        return traceDescription.toString();
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    public static enum OperationType {
        AND{

            @Override
            public boolean test(ImmutableCompoundBoolean cond, DataSet dataSet) {
                return cond.testAND(dataSet);
            }
        }
        ,
        OR{

            @Override
            public boolean test(ImmutableCompoundBoolean cond, DataSet dataSet) {
                return cond.testOR(dataSet);
            }
        }
        ,
        XOR{

            @Override
            public boolean test(ImmutableCompoundBoolean cond, DataSet dataSet) {
                return cond.testXOR(dataSet);
            }
        }
        ,
        NOT{

            @Override
            public boolean test(ImmutableCompoundBoolean cond, DataSet dataSet) {
                return cond.testNOT(dataSet);
            }
        };


        public abstract boolean test(ImmutableCompoundBoolean var1, DataSet var2);
    }
}

