/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic.util;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.conditions.logic.util.AbstractField;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.interfaces.UnsignedInt;
import java.util.Comparator;

public abstract class AbstractNumericField<T extends Number>
extends AbstractField<T> {
    protected AbstractNumericField(Object value, DataType dataType, Comparator<? super T> comparator) {
        super(value, dataType, comparator);
    }

    protected AbstractNumericField(String name, boolean useTag, int tag, FieldIndexKeyContainer keyContainer, DataType dataType, Comparator<? super T> comparator) {
        super(name, useTag, tag, keyContainer, dataType, comparator);
    }

    public static String[] getOperatorArray() {
        return AbstractField.Operator.toStringArray(AbstractField.Operator.values());
    }

    public long getLongValue(DataSet data) {
        return ((Number)this.getValue(data)).longValue();
    }

    protected static int compareUnsignedLongs(long l1, long l2) {
        int res;
        int n = l1 < l2 ? -1 : (res = l1 > l2 ? 1 : 0);
        if (l1 >= 0L && l2 >= 0L || l1 < 0L && l2 < 0L) {
            return res;
        }
        return -res;
    }

    protected static class UnsignedIntComparator
    implements Comparator<UnsignedInt> {
        protected UnsignedIntComparator() {
        }

        @Override
        public int compare(UnsignedInt o1, UnsignedInt o2) {
            long l1 = o1.longValue();
            long l2 = o2.longValue();
            return AbstractNumericField.compareUnsignedLongs(l1, l2);
        }
    }

    protected static class UnsignedNumberComparator
    implements Comparator<Number> {
        protected UnsignedNumberComparator() {
        }

        @Override
        public int compare(Number o1, Number o2) {
            long l1 = o1.longValue();
            long l2 = o2.longValue();
            return AbstractNumericField.compareUnsignedLongs(l1, l2);
        }
    }
}

