/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic.util;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.conditions.logic.util.AbstractField;
import com.ericsson.ere.selectiontree.conditions.logic.util.Field;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import ericsson.ere.datatype.DataType;

public class StringField
extends AbstractField<String> {
    private static String[] operators = new String[]{"Begins_with", "Ends_with", "Contains", "Exact_match"};
    private static final int BEGINS_WIDTH = 0;
    private static final int ENDS_WIDTH = 1;
    private static final int CONTAINS = 2;
    private static final int EXACT_MATCH = 3;

    public StringField(Object value) {
        super(value, DataType.STRING, null);
    }

    public StringField(String value) {
        super(value, DataType.STRING, null);
    }

    public StringField(String name, boolean useTag, int tag, FieldIndexKeyContainer keyContainer) {
        super(name, useTag, tag, keyContainer, DataType.STRING, null);
    }

    @Override
    public int getOperatorInt(String operator) {
        for (int ii = 0; ii < operators.length; ++ii) {
            if (!operator.equals(operators[ii])) continue;
            return ii;
        }
        return -1;
    }

    public static String[] getOperatorArray() {
        return operators;
    }

    @Override
    public boolean compare(int operator, Field<String> fieldToCompare, DataSet data) {
        String string1 = (String)this.getValue(data);
        String string2 = fieldToCompare.getValue(data);
        switch (operator) {
            case 0: {
                return string1.startsWith(string2);
            }
            case 1: {
                return string1.endsWith(string2);
            }
            case 2: {
                return string1.contains(string2);
            }
            case 3: {
                return string1.equals(string2);
            }
        }
        return false;
    }

    @Override
    public String getOperatorString(int operator) {
        if (operator >= 0 && operator < operators.length) {
            return operators[operator];
        }
        return "[UNKNOWN]";
    }
}

