/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.number.AbstractImmutableNumberCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import java.math.BigInteger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class ULongCondition
extends AbstractImmutableNumberCondition<Long>
implements ContextCondition {
    protected static final String[] tagsToTest = new String[]{"IntValue", "ShortValue", "Case", "Code", "Status", "Type"};

    private ULongCondition(ParseContext context) {
        super(context, "ULong", DataType.UNSIGNEDLONG);
    }

    public static ULongCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new ULongCondition(ctx);
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.UNSIGNEDLONG);
    }

    @Override
    protected String getValueString(Node config) {
        for (String tagToTest : tagsToTest) {
            if (((Element)config).getElementsByTagName(tagToTest).getLength() <= 0) continue;
            return XMLUtil.getFirstTextContent(XMLUtil.getNamedElement(tagToTest, config.getChildNodes()));
        }
        throw new NullPointerException();
    }

    @Deprecated
    public boolean isFloat() {
        return false;
    }

    @Override
    protected Long parseValue(String value) {
        return new BigInteger(value).longValue();
    }

    @Override
    protected String getValueAsString(Long value) {
        return DataType.ULongParser(value);
    }

    @Override
    protected Long getValueFromDataSet(DataSet dataset) {
        return this.fetchNumberFromDataSet(dataset).longValue();
    }

    @Override
    protected boolean evaluate(Long value, Long dataSetValue) throws Exception {
        return this.compareUnsignedNumbers(value, dataSetValue);
    }

    @Override
    protected String describeValue(Object value, DataSet dataSet) {
        ClassRepository repo = ULongCondition.getClassRepository(dataSet);
        FieldDefinition field = repo.getFieldDefinitionByName(this.key);
        return field.getTypedDataType() == DataType.UNSIGNEDLONG ? super.describeValue(value, dataSet) : this.getValueAsString((Long)value);
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest((Long)exeCtx.getValue(DataType.LONG));
    }
}

