/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.number.AbstractImmutableNumberCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class UShortCondition
extends AbstractImmutableNumberCondition<Short>
implements ContextCondition {
    protected static final String[] tagsToTest = new String[]{"IntValue", "ShortValue", "Case", "Code", "Status", "Type"};

    protected UShortCondition(ParseContext ctx) {
        super(ctx, "UShort", DataType.UNSIGNEDSHORT);
    }

    public static UShortCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new UShortCondition(ctx);
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.UNSIGNEDSHORT);
    }

    @Override
    protected String getValueString(Node config) {
        for (String tagToTest : tagsToTest) {
            if (((Element)config).getElementsByTagName(tagToTest).getLength() <= 0) continue;
            return XMLUtil.getFirstTextContent(XMLUtil.getNamedElement(tagToTest, config.getChildNodes()));
        }
        throw new NullPointerException();
    }

    @Deprecated
    public boolean isFloat() {
        return false;
    }

    @Override
    protected Short parseValue(String value) {
        return Integer.valueOf(value).shortValue();
    }

    @Override
    protected String getValueAsString(Short value) {
        return DataType.UShortParser(value);
    }

    @Override
    protected Short getValueFromDataSet(DataSet dataset) {
        return this.fetchNumberFromDataSet(dataset).shortValue();
    }

    @Override
    protected boolean evaluate(Short value, Short dataSetValue) throws Exception {
        return this.compareUnsignedNumbers(value.shortValue(), dataSetValue.shortValue());
    }

    @Override
    protected String describeValue(Object value, DataSet dataSet) {
        ClassRepository repo = UShortCondition.getClassRepository(dataSet);
        FieldDefinition field = repo.getFieldDefinitionByName(this.key);
        return field.getTypedDataType() == DataType.UNSIGNEDSHORT ? super.describeValue(value, dataSet) : this.getValueAsString((Short)value);
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest((Short)exeCtx.getValue(DataType.SHORT));
    }
}

