/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.numberseries;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class NumberTree
implements Comparable<NumberTree> {
    private static final char[] DELIMS = new char[]{' ', ',', '\t', '\n', '\r', '\u0000', '\u00a0'};
    private NumberTree[] next;
    private int result = 0;
    private transient int hash;

    public NumberTree(String theNumbers) throws IllegalArgumentException {
        this.addNumbers(theNumbers);
    }

    private NumberTree() {
        this.next = null;
    }

    public boolean checkNumber(String theNumber) {
        return this.checkNumber(theNumber, 0);
    }

    private boolean isBitSet(int tempNumber) {
        return (this.result & 1 << tempNumber) != 0;
    }

    public boolean checkNumber(String theNumber, int theLevel) {
        int tempNumber;
        if (theNumber.length() == theLevel) {
            return false;
        }
        try {
            tempNumber = NumberTree.convertDigit(theNumber.charAt(theLevel));
        }
        catch (Exception e) {
            return false;
        }
        if (this.isBitSet(tempNumber)) {
            return true;
        }
        if (this.next == null || this.next[tempNumber] == null) {
            return false;
        }
        return this.next[tempNumber].checkNumber(theNumber, theLevel + 1);
    }

    public boolean checkNumber(byte[] theNumber, int theLevel) {
        if (theNumber.length == theLevel) {
            return false;
        }
        int tempNumber = theNumber[theLevel];
        if (tempNumber > 15 && ((tempNumber = NumberTree.convertDigit((byte)tempNumber)) < 0 || tempNumber > 15)) {
            return false;
        }
        if (this.isBitSet(tempNumber)) {
            return true;
        }
        if (this.next == null || this.next[tempNumber] == null) {
            return false;
        }
        return this.next[tempNumber].checkNumber(theNumber, theLevel + 1);
    }

    public boolean checkNumber(byte[] theNumber) {
        if (theNumber == null) {
            return false;
        }
        NumberTree tree = this;
        for (int i = 0; tree != null && i < theNumber.length; ++i) {
            byte b = theNumber[i];
            if (b > 15) {
                b = (byte)NumberTree.convertDigit(b);
            }
            if (b < 0 || b > 15) {
                return false;
            }
            if (tree.isBitSet(b)) {
                return true;
            }
            if (tree.next == null) {
                return false;
            }
            tree = tree.next[b];
        }
        return false;
    }

    @Override
    public int compareTo(NumberTree other) {
        if (this.next != null && other.next == null) {
            return 1;
        }
        if (this.next == null && other.next != null) {
            return -1;
        }
        if (this.result < other.result) {
            return -1;
        }
        if (this.result > other.result) {
            return 1;
        }
        if (this.next == null) {
            return 0;
        }
        for (int i = 0; i < this.next.length; ++i) {
            int res;
            if (this.next[i] == null && other.next[i] != null) {
                return -1;
            }
            if (this.next[i] != null && other.next[i] == null) {
                return 1;
            }
            if (this.next[i] == null || (res = this.next[i].compareTo(other.next[i])) == 0) continue;
            return res;
        }
        return 0;
    }

    public int hashCode() {
        int res = this.hash;
        if (res == 0) {
            int prime = 31;
            res = 1;
            res = 31 * res + Arrays.hashCode(this.next);
            this.hash = res = 31 * res + this.result;
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumberTree other = (NumberTree)obj;
        if (!Arrays.equals(this.next, other.next)) {
            return false;
        }
        return this.result == other.result;
    }

    private void addNumbers(String theNumbers) throws IllegalArgumentException {
        if (this.next != null) {
            throw new IllegalArgumentException("Cannot add new numbers to already initialized tree.");
        }
        char[] data = theNumbers.toCharArray();
        int idx = 0;
        while (idx < data.length) {
            while (idx < data.length && this.isDelimiter(data[idx])) {
                ++idx;
            }
            if (idx >= data.length) break;
            int mark = idx;
            int rangeIndicatorPos = -1;
            while (idx < data.length && !this.isDelimiter(data[idx])) {
                if ('-' == data[idx]) {
                    rangeIndicatorPos = idx;
                }
                ++idx;
            }
            int len = idx - mark;
            if (rangeIndicatorPos < 0) {
                this.addNumber(data, mark, 0, len);
                continue;
            }
            this.addNumberRange(data, mark, rangeIndicatorPos - mark, rangeIndicatorPos + 1, idx - rangeIndicatorPos - 1);
        }
        this.optimize();
    }

    private boolean isDelimiter(char c) {
        for (int i = 0; i < DELIMS.length; ++i) {
            if (DELIMS[i] != c) continue;
            return true;
        }
        return false;
    }

    private void optimize() {
        if (this.next != null) {
            for (int i = 0; i < this.next.length; ++i) {
                if (this.next[i] == null) continue;
                NumberTree n = Cache.fetch(this.next[i]);
                if (n != null && n != this.next[i]) {
                    this.next[i] = n;
                    continue;
                }
                this.next[i].optimize();
            }
        }
    }

    private void addNumber(char[] theNumber, int offset, int theLevel, int maxLevel) {
        int tempNumber = NumberTree.convertDigit(theNumber[offset + theLevel]);
        if (maxLevel == theLevel + 1) {
            if (this.isBitSet(tempNumber)) {
                throw new IllegalArgumentException("Number already exists: " + new String(theNumber, offset, maxLevel));
            }
            this.result |= 1 << tempNumber;
            if (this.next != null) {
                this.next[tempNumber] = null;
            }
            return;
        }
        if (this.next == null) {
            this.next = new NumberTree[16];
        }
        if (this.next[tempNumber] == null) {
            this.next[tempNumber] = new NumberTree();
        }
        this.next[tempNumber].addNumber(theNumber, offset, theLevel + 1, maxLevel);
    }

    private void addNumberRange(char[] data, int fromOffset, int fromLen, int toOffset, int toLen) {
        if (!this.isDigit(data, fromOffset, fromLen) || !this.isDigit(data, toOffset, toLen)) {
            throw new IllegalArgumentException("Invalid format of input, only digits are allowed in number range (\"" + new String(data, fromOffset, fromLen) + "-" + new String(data, toOffset, toLen) + "\")");
        }
        if (fromLen > toLen || NumberTree.compareCharArrays(data, fromOffset, fromLen, data, toOffset, toLen) >= 0) {
            throw new IllegalArgumentException("The from number (\"" + new String(data, fromOffset, fromLen) + "\") must be less than the to number (\"" + new String(data, toOffset, toLen) + "\")");
        }
        int significantDigits = toLen;
        while (NumberTree.compareCharArrays(data, fromOffset, fromLen, data, toOffset + toLen - significantDigits, significantDigits) < 0) {
            this.addNumber(data, toOffset + toLen - significantDigits, 0, significantDigits);
            int newDigits = NumberTree.minusOnACharArray(data, toOffset, toLen);
            if (newDigits >= significantDigits) continue;
            significantDigits = Math.max(newDigits, fromLen);
        }
        this.addNumber(data, fromOffset, 0, fromLen);
    }

    public static int convertDigit(char theDigit) throws IllegalArgumentException {
        switch (theDigit) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case '*': 
            case 'B': 
            case 'b': {
                return 11;
            }
            case '#': 
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalArgumentException("Invalid format of input only digits are allowed");
    }

    public static int convertDigit(byte theDigit) throws IllegalArgumentException {
        if (theDigit == 42) {
            return 11;
        }
        if (theDigit == 35) {
            return 12;
        }
        if (theDigit >= 97) {
            return theDigit - 97 + 10;
        }
        if (theDigit >= 65) {
            return theDigit - 65 + 10;
        }
        return theDigit - 48;
    }

    public static boolean isxDigit(char theDigit) {
        return theDigit >= '0' && theDigit <= '9' || theDigit >= 'A' && theDigit <= 'F' || theDigit >= 'a' && theDigit <= 'f';
    }

    public static boolean isDigit(char theDigit) {
        return theDigit >= '0' && theDigit <= '9';
    }

    private boolean isDigit(char[] theNumber, int offset, int count) {
        int len = offset + count;
        for (int i = offset; i < len; ++i) {
            if (NumberTree.isDigit(theNumber[i])) continue;
            return false;
        }
        return true;
    }

    private static int compareCharArrays(char[] left, int leftOffset, int leftLen, char[] right, int rightOffset, int rightLen) {
        assert (rightLen >= leftLen);
        int maxLen = leftLen > rightLen ? leftLen : rightLen;
        int leftAdjust = maxLen - leftLen;
        for (int i = 0; i < maxLen; ++i) {
            char rc;
            char lc = i >= leftAdjust ? left[leftOffset + i - leftAdjust] : (char)'0';
            if (lc == (rc = right[rightOffset + i])) continue;
            return lc - rc;
        }
        return leftLen - rightLen;
    }

    private static int minusOnACharArray(char[] theNumber, int offset, int len) {
        int i = offset + len - 1;
        boolean stop = false;
        while (i >= offset && !stop) {
            char c = theNumber[i];
            if (c == '0') {
                theNumber[i] = 57;
                --i;
                continue;
            }
            int n = i;
            theNumber[n] = (char)(theNumber[n] - '\u0001');
            stop = true;
        }
        for (i = 0; i < len && theNumber[i + offset] == '0'; ++i) {
        }
        return len - i;
    }

    public static class Cache {
        private static Map<NumberTree, NumberTree> treeCache = new TreeMap<NumberTree, NumberTree>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static NumberTree fetch(NumberTree wanted) {
            NumberTree res;
            Map<NumberTree, NumberTree> map = treeCache;
            synchronized (map) {
                res = treeCache.get(wanted);
                if (res == null) {
                    treeCache.put(wanted, wanted);
                    res = wanted;
                }
            }
            return res;
        }
    }
}

